/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.junit.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PdfcServerInfo {
    private static final String DEFAULT_URL = "http://localhost:9900/api/comparison";
    private String servicePath = "http://localhost:9900/api/comparison";
    private List<String> cookies;
    private String user;
    private String password;
    private String token;

    public void readCookies(@Nonnull HttpResponse<?> response) {
        List<String> cookies = response.headers().allValues("Set-Cookie");
        if (cookies != null) {
            cookies = new ArrayList<String>(cookies);
            for (int i = 0; i < cookies.size(); ++i) {
                String cookie = cookies.get(i);
                int idx = cookie.indexOf(59);
                if (idx <= 0) continue;
                cookies.set(i, cookie.substring(0, idx));
            }
            if (this.cookies != null) {
                this.cookies.addAll(cookies);
            } else {
                this.cookies = cookies;
            }
        }
    }

    @Nullable
    private String getAuthorization() {
        if (this.user != null && this.password != null) {
            return "Basic " + Base64.getMimeEncoder().encodeToString((this.user + ":" + this.password).getBytes(StandardCharsets.UTF_8));
        }
        return "Bearer " + this.token;
    }

    public void setServicePath(@Nonnull String servicePath) {
        if (((String)servicePath).indexOf("://") < 0) {
            servicePath = "http://" + (String)servicePath;
        }
        try {
            URL url = new URL((String)servicePath);
            String path = url.getPath();
            if (path.isEmpty() || path.equals("/")) {
                servicePath = new URL(url, "/api/comparison").toString();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (!Objects.equals(servicePath, this.servicePath)) {
            this.cookies = null;
        }
        this.servicePath = servicePath;
    }

    public void setCredentials(@Nullable String user, @Nullable String password) {
        if (!Objects.equals(user, this.user) || !Objects.equals(password, this.password) || this.token != null) {
            this.cookies = null;
        }
        this.user = user;
        this.password = password == null ? "" : password;
        this.token = null;
    }

    public void setCredentials(@Nullable String token) {
        if (!Objects.equals(token, this.token) || this.user != null) {
            this.cookies = null;
        }
        this.token = token;
        this.user = null;
        this.password = null;
    }

    public String getServicePath() {
        if (this.servicePath == null) {
            this.servicePath = DEFAULT_URL;
        }
        return this.servicePath;
    }

    public void setAuth(@Nonnull HttpRequest.Builder requestBuilder) {
        String auth = this.getAuthorization();
        if (auth != null) {
            requestBuilder.header("Authorization", auth);
        }
    }

    public void setCookies(@Nonnull HttpRequest.Builder requestBuilder) {
        if (this.cookies != null) {
            for (String cookie : this.cookies) {
                requestBuilder.header("Cookie", cookie);
            }
        }
    }
}

