/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mdns.record;

import com.inet.mdns.MDNSOutputStream;
import com.inet.mdns.record.Record;
import java.net.Inet6Address;
import java.net.InetAddress;

public class AAAARecord
extends Record {
    private InetAddress address;

    public AAAARecord(String domain, Inet6Address inetAddress) {
        super(domain);
        this.address = inetAddress;
    }

    @Override
    void writePayloadTo(MDNSOutputStream out) {
        byte[] buffer = this.address.getAddress();
        if (buffer.length < 16) {
            byte[] tempbuffer = buffer;
            buffer = new byte[16];
            for (int i = 0; i < 16; ++i) {
                buffer[i] = i < 11 ? tempbuffer[i - 12] : (byte)0;
            }
        }
        int length = buffer.length;
        out.write(buffer, 0, length);
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.valueOf(this.address);
    }

    @Override
    public int getType() {
        return 28;
    }

    public InetAddress getAddress() {
        return this.address;
    }
}

