/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mdns;

import com.inet.lib.io.FastByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MDNSInputStream
extends FastByteArrayInputStream {
    private Map<Integer, String> nameMap = new HashMap<Integer, String>();

    public MDNSInputStream(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public int readUnsignedShort() throws IOException {
        return this.readByte() << 8 | this.readByte();
    }

    public int readInt() throws IOException {
        return this.readUnsignedShort() << 16 | this.readUnsignedShort();
    }

    public byte[] readBytes(int len) {
        byte[] bytes = new byte[len];
        this.read(bytes, 0, len);
        return bytes;
    }

    public String readUTF(int len) throws IOException {
        StringBuilder buffer = new StringBuilder(len);
        for (int index = 0; index < len; ++index) {
            int ch = this.readByte();
            switch (ch >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    ch = (ch & 0x1F) << 6 | this.readByte() & 0x3F;
                    ++index;
                    break;
                }
                case 14: {
                    ch = (ch & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | this.readByte() & 0x3F;
                    ++index;
                    ++index;
                    break;
                }
                default: {
                    ch = (ch & 0x3F) << 4 | this.readByte() & 0xF;
                    ++index;
                }
            }
            buffer.append((char)ch);
        }
        return buffer.toString();
    }

    private int readByte() throws IOException {
        int value = super.read();
        if (value < 0) {
            throw new EOFException();
        }
        return value;
    }

    public String readName() throws IOException {
        HashMap<Integer, StringBuilder> names = new HashMap<Integer, StringBuilder>();
        StringBuilder buffer = new StringBuilder();
        boolean finished = false;
        while (!finished) {
            int len = this.readByte();
            if (len == 0) {
                finished = true;
                break;
            }
            if ((len & 0xC0) == 0) {
                int offset = this.pos - 1;
                String label = this.readUTF(len) + ".";
                buffer.append(label);
                for (StringBuilder previousLabel : names.values()) {
                    previousLabel.append(label);
                }
                names.put(offset, new StringBuilder(label));
                continue;
            }
            int index = (len & 0x3F) << 8 | this.readByte();
            String compressedLabel = this.nameMap.get(index);
            if (compressedLabel == null) {
                compressedLabel = "";
            }
            buffer.append(compressedLabel);
            for (StringBuilder previousLabel : names.values()) {
                previousLabel.append(compressedLabel);
            }
            finished = true;
        }
        for (Integer index : names.keySet()) {
            this.nameMap.put(index, ((StringBuilder)names.get(index)).toString());
        }
        return buffer.toString();
    }
}

