/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.io.UTF8StreamReader;
import com.inet.lib.json.BaseParser;
import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonTypeResolver;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class BonParser
extends BaseParser {
    private final InputStream input;
    private final HashMap<Integer, Object> keys = new HashMap();

    BonParser(@Nonnull InputStream input, @Nonnull Map<Object, Map<String, Object>> extraFields, @Nonnull JsonTypeResolver typeResolver) throws IOException {
        super(extraFields, typeResolver, new Function<Object, Object>(){
            private HashMap<Object, Object> objectPool = new HashMap();

            @Override
            public Object apply(Object obj) {
                Object old = this.objectPool.get(obj);
                if (old != null) {
                    return old;
                }
                this.objectPool.put(obj, obj);
                return obj;
            }
        });
        this.input = input;
        if (input.read() != 66 || input.read() != 79 || input.read() != 78) {
            throw new JsonException("No valid BON data.");
        }
        input.read();
    }

    private int read() throws IOException {
        int result = this.input.read();
        if (result < 0) {
            throw new JsonException("Unexpected end of stream");
        }
        return result;
    }

    @Nullable
    Object parseValue(@Nonnull Type type, @Nullable Type parentType) throws IOException, JsonException {
        int token = this.read();
        return this.parseValue(token, type, parentType);
    }

    @Nullable
    private Object parseValue(int token, @Nonnull Type type, @Nullable Type parentType) throws IOException {
        switch (token) {
            case 33: {
                return null;
            }
            case 35: {
                return Boolean.TRUE;
            }
            case 34: {
                return Boolean.FALSE;
            }
            case 36: {
                return this.getObject(this.readLong(), type);
            }
            case 37: {
                return this.getObject(this.readLong() ^ 0xFFFFFFFFFFFFFFFFL, type);
            }
            case 38: {
                return this.readFloat(type);
            }
            case 39: {
                return this.readDouble(type);
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                return this.getObject(token & 0x1F, type);
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return this.getObject(~(token & 0x1F), type);
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                return this.readString(token & 0x3F, type);
            }
            case 44: {
                return this.readString((int)this.readLong(), type);
            }
            case 45: {
                return this.readBytes();
            }
            case 40: {
                return this.parseArray(type);
            }
            case 46: {
                return this.parseArrayWithLength(type, parentType);
            }
            case 41: {
                return this.parseObject(type, true, parentType);
            }
            case 42: {
                return this.parseObject(type, false, parentType);
            }
        }
        throw new JsonException("Unknown type token: " + token);
    }

    @Nonnull
    private Object parseArray(@Nonnull Type type) throws IOException, JsonException {
        Class elementType;
        Class<?> elementClass;
        Collection<Object> list;
        ClassWrapper wrapper = ClassWrapper.getWrapper(type, null);
        Class<?> clazz = wrapper.getClazz();
        Type[] types = wrapper.getTypeArguments();
        if (clazz.isArray()) {
            list = new ArrayList();
            elementClass = clazz.getComponentType();
            elementType = types != null ? types[0] : elementClass;
        } else if (type == Object.class) {
            list = new ArrayList();
            elementClass = null;
            elementType = Object.class;
        } else {
            elementClass = null;
            elementType = types != null ? types[0] : Object.class;
            list = (Collection)ClassWrapper.getWrapper(type, null).create();
        }
        if (elementType == null) {
            elementType = Object.class;
        }
        while (true) {
            int token = this.read();
            switch (token) {
                case 43: {
                    if (elementClass != null) {
                        int length = list.size();
                        Object result = Array.newInstance(elementClass, length);
                        int i = 0;
                        for (Object e : list) {
                            Array.set(result, i++, e);
                        }
                        return result;
                    }
                    return list;
                }
            }
            list.add(this.parseValue(token, (Type)((Object)elementType), type));
        }
    }

    @Nonnull
    private Object parseArrayWithLength(@Nonnull Type type, @Nullable Type parentType) throws IOException, JsonException {
        int length = (int)this.readLong();
        ClassWrapper wrapper = ClassWrapper.getWrapper(type, parentType);
        Class<?> clazz = wrapper.getClazz();
        if (clazz.isArray()) {
            Class<?> elementClass = clazz.getComponentType();
            Object array = Array.newInstance(elementClass, length);
            if (elementClass.isPrimitive()) {
                wrapper = ClassWrapper.getWrapper(elementClass, parentType);
                switch (wrapper.getJsonType()) {
                    case 9: {
                        this.parseArrayImpl((boolean[])array, length);
                        break;
                    }
                    case 11: {
                        this.parseArrayImpl((short[])array, length);
                        break;
                    }
                    case 12: {
                        this.parseArrayImpl((int[])array, length);
                        break;
                    }
                    case 13: {
                        this.parseArrayImpl((long[])array, length);
                        break;
                    }
                    case 14: {
                        this.parseArrayImpl((float[])array, length);
                        break;
                    }
                    case 15: {
                        this.parseArrayImpl((double[])array, length);
                        break;
                    }
                    case 16: {
                        this.parseArrayImpl((char[])array, length);
                        break;
                    }
                }
            } else {
                Type[] types = wrapper.getTypeArguments();
                Class<?> elementType = types != null ? types[0] : elementClass;
                this.parseArrayImpl((Object[])array, length, elementType);
            }
            return array;
        }
        Type[] types = wrapper.getTypeArguments();
        Object elementType = types != null ? types[0] : Object.class;
        Collection list = (Collection)ClassWrapper.getWrapper(type, parentType).create(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.parseValue(this.typeResolver.getCollectionValueType(list, (Type)elementType), null));
        }
        return list;
    }

    private void parseArrayImpl(boolean @Nonnull [] array, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            array[i] = this.parseValueAsLong() != 0L;
        }
    }

    private void parseArrayImpl(short @Nonnull [] array, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            array[i] = (short)this.parseValueAsLong();
        }
    }

    private void parseArrayImpl(int @Nonnull [] array, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            array[i] = (int)this.parseValueAsLong();
        }
    }

    private void parseArrayImpl(long @Nonnull [] array, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            array[i] = this.parseValueAsLong();
        }
    }

    private void parseArrayImpl(float @Nonnull [] array, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            int token = this.read();
            array[i] = token == 38 ? this.readFloat() : (float)this.parseValueAsLong(token);
        }
    }

    private void parseArrayImpl(double @Nonnull [] array, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            int token = this.read();
            array[i] = token == 39 ? this.readDouble() : (double)this.parseValueAsLong(token);
        }
    }

    private void parseArrayImpl(char @Nonnull [] array, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            array[i] = (char)this.parseValueAsLong();
        }
    }

    private void parseArrayImpl(Object @Nonnull [] array, int length, Type elementType) throws IOException {
        for (int i = 0; i < length; ++i) {
            array[i] = this.parseValue(this.typeResolver.getArrayValueType(array, i, elementType), null);
        }
    }

    private long parseValueAsLong() throws IOException {
        return this.parseValueAsLong(this.read());
    }

    private long parseValueAsLong(int token) throws IOException {
        switch (token) {
            case 35: {
                return -1L;
            }
            case 34: {
                return 0L;
            }
            case 36: {
                return this.readLong();
            }
            case 37: {
                return this.readLong() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                return token & 0x1F;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return ~(token & 0x1F);
            }
        }
        throw new JsonException("Unknown type token: " + token);
    }

    Object parseObject(@Nonnull Type type, boolean useKeyReferences, @Nullable Type parentType) throws IOException, JsonException {
        Object valueGenericType;
        Class<Object> keyGenericType;
        int objectType;
        Object obj;
        ClassWrapper wrapper = ClassWrapper.getWrapper(type, parentType);
        if (wrapper.hasGetTypeFor()) {
            obj = new BaseParser.JsonObject(wrapper);
            objectType = 2;
            keyGenericType = String.class;
            valueGenericType = null;
        } else {
            if (type == Object.class) {
                wrapper = ClassWrapper.getWrapper(Map.class, parentType);
            }
            if ((obj = wrapper.create()) instanceof Map) {
                objectType = 1;
                Type[] types = wrapper.getTypeArguments();
                if (types != null) {
                    keyGenericType = types[0];
                    valueGenericType = types[1];
                } else {
                    valueGenericType = Object.class;
                    keyGenericType = Object.class;
                }
            } else {
                objectType = 0;
                keyGenericType = String.class;
                valueGenericType = null;
            }
        }
        block9: while (true) {
            int token = this.read();
            switch (token) {
                case 43: {
                    if (objectType == 2) {
                        return ((BaseParser.JsonObject)obj).create();
                    }
                    return obj;
                }
            }
            Object key = useKeyReferences ? this.parseKeyName(token) : this.parseValue(token, (Type)((Object)keyGenericType), null);
            switch (objectType) {
                default: {
                    Field field = wrapper.findField(String.valueOf(key));
                    if (field == null) {
                        this.saveExtraField(obj, String.valueOf(key));
                        break;
                    }
                    Type fieldType = this.typeResolver.getGenericType(obj, field);
                    Object value = this.parseValue(fieldType, type);
                    try {
                        field.set(obj, value);
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace(Json.getErrorStream());
                    }
                    continue block9;
                }
                case 1: {
                    valueGenericType = this.typeResolver.getMapValueType(key, (Type)valueGenericType);
                    Object value = this.parseValue((Type)valueGenericType, null);
                    ((Map)obj).put(key, value);
                    break;
                }
                case 2: {
                    Field field = wrapper.findField(String.valueOf(key));
                    if (field == null) {
                        ((BaseParser.JsonObject)obj).extraFieldValues.put(String.valueOf(key), this.parseValue((Type)((Object)Object.class), null));
                        break;
                    }
                    Type fieldType = field.getGenericType();
                    Object value = this.parseValue(fieldType, null);
                    ((BaseParser.JsonObject)obj).fieldValues.put(String.valueOf(key), value);
                }
            }
        }
    }

    @Override
    @Nullable
    Object parseExtraFieldValue() throws JsonException, IOException {
        return this.parseValue((Type)((Object)Object.class), null);
    }

    private Object parseKeyName(int token) throws IOException {
        switch (token) {
            case 36: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                return this.keys.get(this.parseValue(token, (Type)((Object)Integer.class), null));
            }
        }
        Object key = this.parseValue(token, (Type)((Object)String.class), null);
        this.keys.put(this.keys.size(), key);
        return key;
    }

    private Object readString(int length, Type type) throws IOException {
        UTF8StreamReader reader = new UTF8StreamReader(this.input, false);
        char[] value = new char[length];
        reader.read(value);
        String str = new String(value);
        Object obj = ClassWrapper.getWrapper(type, null).valueOf(str, true);
        return obj == str ? this.pool(obj) : obj;
    }

    private Object readBytes() throws IOException, JsonException {
        int len = (int)this.readLong();
        byte[] value = new byte[len];
        int off = 0;
        while (len - off > 0) {
            int count = this.input.read(value, off, len);
            if (count < 0) {
                throw new JsonException("Unexpected end of stream");
            }
            off += count;
        }
        return value;
    }

    private Object getObject(long value, @Nonnull Type type) {
        int jsonType = ClassWrapper.getWrapper(type, null).getJsonType();
        switch (jsonType) {
            case 8: {
                return this.pool(new Date(value));
            }
            case 9: {
                return this.pool(value != 0L);
            }
            case 10: {
                return this.pool((byte)value);
            }
            case 11: {
                return this.pool((short)value);
            }
            case 12: {
                return this.pool((int)value);
            }
            case 13: {
                return this.pool(value);
            }
            case 14: {
                return this.pool(Float.valueOf(value));
            }
            case 15: {
                return this.pool(Double.valueOf(value));
            }
            case 16: {
                return this.pool(Character.valueOf((char)value));
            }
            case 7: {
                if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
                    return this.pool((int)value);
                }
                return this.pool(value);
            }
        }
        throw new JsonException("Unknown number type: " + jsonType);
    }

    private long readLong() throws IOException {
        int next;
        long value = 0L;
        do {
            next = this.read();
            value = (value << 7) + (long)(next & 0x7F);
        } while ((next & 0x80) == 0);
        return value;
    }

    private float readFloat() throws IOException {
        int bits = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
        return Float.intBitsToFloat(bits);
    }

    private Object readFloat(Type type) throws IOException {
        float value = this.readFloat();
        int jsonType = ClassWrapper.getWrapper(type, null).getJsonType();
        switch (jsonType) {
            case 9: {
                return this.pool(value != 0.0f);
            }
            case 10: {
                return this.pool((byte)value);
            }
            case 11: {
                return this.pool((short)value);
            }
            case 12: {
                return this.pool((int)value);
            }
            case 13: {
                return this.pool((long)value);
            }
            case 14: {
                return this.pool(Float.valueOf(value));
            }
            case 15: {
                return this.pool(Double.valueOf(value));
            }
            case 16: {
                return this.pool(Character.valueOf((char)value));
            }
        }
        throw new JsonException("Unknown number type: " + jsonType);
    }

    private double readDouble() throws IOException {
        long bits = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
        bits <<= 32;
        return Double.longBitsToDouble(bits |= (long)this.read() << 24 | (long)(this.read() << 16) | (long)(this.read() << 8) | (long)this.read());
    }

    private Object readDouble(Type type) throws IOException {
        double value = this.readDouble();
        int jsonType = ClassWrapper.getWrapper(type, null).getJsonType();
        switch (jsonType) {
            case 9: {
                return this.pool(value != 0.0);
            }
            case 10: {
                return this.pool((byte)value);
            }
            case 11: {
                return this.pool((short)value);
            }
            case 12: {
                return this.pool((int)value);
            }
            case 13: {
                return this.pool((long)value);
            }
            case 14: {
                return this.pool(Float.valueOf((float)value));
            }
            case 15: {
                return this.pool(value);
            }
            case 16: {
                return this.pool(Character.valueOf((char)value));
            }
        }
        throw new JsonException("Unknown number type: " + jsonType);
    }
}

