/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.internal;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.config.ConfigurationManager;
import com.inet.logging.LogManager;
import com.inet.logging.SystemEventLog;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;

@InternalApi
public class NodeRestarter
implements PersistenceListener<RestartNodeEvent> {
    @Override
    public void eventReceived(RestartNodeEvent event) {
        NodeRestarter.restartThisServerNode();
    }

    public static void restartAllServerNodes() {
        Persistence.getInstance().sendEvent(new RestartNodeEvent());
        NodeRestarter.restartThisServerNode();
    }

    public static void restartThisServerNode() {
        try {
            final int n2 = Integer.valueOf(System.getProperty("restart.exitcode"));
            SystemEventLog.ServerRestarted.log(new Object[0]);
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            if (userAccount != null && userAccount.getID() != UserManager.PRIVILEGED_ACCOUNT_ID) {
                ServerPluginManager.getInstance().getStartProperties().setProperty("initiator", userAccount.getDisplayName());
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConfigurationManager.getInstance().getCurrent().flush();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    LogManager.getConfigLogger().status("Restarting server!");
                    System.exit(n2);
                }
            }).start();
        }
        catch (Exception exception) {
            LogManager.getConfigLogger().debug(exception);
        }
    }

    @JsonData
    static class RestartNodeEvent {
        RestartNodeEvent() {
        }
    }
}

