/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.base;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.FormLoginServlet;
import com.inet.authentication.LoginListener;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.RemoteLoginProcessor;
import com.inet.authentication.base.BasicLoginProcessor;
import com.inet.authentication.base.LoginApiAccessor;
import com.inet.authentication.base.NtlmMessage;
import com.inet.authentication.base.ServletLoginProcessor;
import com.inet.authentication.base.TempLoginProcessor;
import com.inet.authentication.stayloggedin.StayLoggedInHandler;
import com.inet.cache.MemoryStoreMap;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.config.RecoveryConfigValue;
import com.inet.error.ErrorCode;
import com.inet.error.ServiceUnavailableException;
import com.inet.http.ClientMessageException;
import com.inet.http.PluginDispatcherServlet;
import com.inet.http.error.HttpFailedException;
import com.inet.http.error.ServletErrorHandler;
import com.inet.http.servlet.DisabledNtlmServletResponse;
import com.inet.http.servlet.SessionStore;
import com.inet.http.utils.Browser;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.SecurityEventLog;
import com.inet.permissions.Permission;
import com.inet.plugin.DynamicExtension;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.veto.VetoManager;
import com.inet.search.veto.UserSearchIndexVetoPower;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class LoginManager {
    private static final RecoveryConfigValue<Boolean> a;
    private static final RecoveryConfigValue<HashMap<String, String>[]> b;
    private static com.inet.authentication.base.a c;
    public static final String WEB_USER_INFO = "WebUserInfo";
    public static final String LOGIN_EXCEPTION = "Login.Exception";
    private static final String ADD_SIGN_UP_STATE = "SignUp.State";
    private static final String LOGOUT_INFO = "Logout.timestamp";
    private static final String AUTHENTICATION_DESCRIPTION_COOKIE = "AUTHENTICATION_DESCRIPTION_COOKIE";
    private static final DynamicExtension<LoginListener> d;
    private static final long START_TIME;
    private static final MemoryStoreMap<String, Object> e;

    LoginManager() {
    }

    private static void a() {
        DynamicExtensionManager dynamicExtensionManager = DynamicExtensionManager.getInstance();
        if (b == null || ServerPluginManager.getInstance().getState() != ServerPluginManager.ServerPluginManagerState.INIT) {
            return;
        }
        List<AuthenticationProvider> list = dynamicExtensionManager.get(AuthenticationProvider.class);
        c = new com.inet.authentication.base.a(list, (HashMap[])b.get());
        e.clear();
    }

    private static void b() {
        if (c == null) {
            LoginManager.a();
        }
    }

    @Nonnull
    public static List<AuthenticationProvider> getProviders() {
        LoginManager.b();
        return LoginManager.c.g;
    }

    public static boolean isGuestAccount() {
        LoginManager.b();
        return LoginManager.c.a != null;
    }

    public static String getGuestAccountName() {
        LoginManager.b();
        return LoginManager.c.a;
    }

    public static boolean isUserCanRegister() {
        LoginManager.b();
        if (!((Boolean)a.get()).booleanValue()) {
            return false;
        }
        block9: for (AuthenticationDescription authenticationDescription : LoginManager.c.d) {
            switch (authenticationDescription.getName()) {
                case "master": 
                case "guest": {
                    continue block9;
                }
                case "product": {
                    if (LoginManager.c.b == com.inet.authentication.base.LoginManager$b.c) break;
                    continue block9;
                }
            }
            return true;
        }
        return LoginManager.c.b == com.inet.authentication.base.LoginManager$b.c;
    }

    public static boolean isUserCanChangePassword() {
        LoginManager.b();
        return LoginManager.c.b != com.inet.authentication.base.LoginManager$b.a;
    }

    public static boolean isApplicationRequest(@Nonnull HttpServletRequest request) {
        String string = request.getHeader("Accept");
        if (string == null) {
            return true;
        }
        if (string.contains("application/json")) {
            return true;
        }
        Browser browser = Browser.parseBrowser(request.getHeader("User-Agent"));
        switch (browser) {
            case Java: 
            case HdMobile: 
            case HdApplication: 
            case PDFCNetViewer: 
            case PDFCNUnit: 
            case Designer: {
                return true;
            }
        }
        if (string.contains("text/html")) {
            return false;
        }
        return !string.endsWith("*/*") || browser != Browser.IE;
    }

    public static void userLoggedOut(HttpServletRequest request, HttpServletResponse response) {
        UserAccount userAccount;
        if (request != null && response != null) {
            StayLoggedInHandler.handleCookie(null, request, response, false);
        }
        if ((userAccount = UserManager.getInstance().getCurrentUserAccount()) != null) {
            for (LoginListener object2 : d.get()) {
                try {
                    object2.userLoggedOut(userAccount);
                }
                catch (Exception iterator) {
                    LoginProcessor.LOGGER.error(iterator);
                }
            }
        }
        SecurityEventLog.UserLogout.log(new Object[0]);
        HttpSession httpSession = request != null ? request.getSession(false) : SessionStore.getHttpSession();
        if (httpSession == null) {
            return;
        }
        ArrayList<String> arrayList = Collections.list(httpSession.getAttributeNames());
        for (String string : arrayList) {
            httpSession.removeAttribute(string);
        }
        httpSession.setAttribute(LOGOUT_INFO, Boolean.TRUE);
        if (response != null) {
            LoginManager.setAuthenticationDescriptionCookie("", request, response);
        }
    }

    public static boolean initHttpRequest(HttpServletRequest req, HttpServletResponse res) {
        block24: {
            try {
                Object object;
                boolean bl;
                Object object2;
                HttpSession httpSession = req.getSession(false);
                LoginProcessor loginProcessor = null;
                boolean bl2 = false;
                if (httpSession != null) {
                    loginProcessor = LoginManager.getLoginProcessor(httpSession);
                    if (loginProcessor != null) {
                        if (loginProcessor instanceof ServletLoginProcessor) {
                            ((ServletLoginProcessor)loginProcessor).a(req);
                        }
                        bl2 = LoginManager.a(loginProcessor, req, res);
                    } else {
                        object2 = httpSession.getAttribute(LOGOUT_INFO);
                        if (object2 != null) {
                            return LoginManager.a(req.getHeader("Authorization"), req, res);
                        }
                    }
                }
                if ((object2 = LoginManager.a(req)) != null) {
                    loginProcessor = ((a)object2).b;
                    bl2 = false;
                }
                String string = req.getHeader("Authorization");
                if (bl2) {
                    StayLoggedInHandler.checkCookie(httpSession, req, res);
                    return LoginManager.a(string, req, res);
                }
                if (loginProcessor == null && StayLoggedInHandler.handleCookie(null, req, res, true)) {
                    return true;
                }
                boolean bl3 = LoginManager.isApplicationRequest(req);
                if (loginProcessor == null) {
                    loginProcessor = LoginManager.createLoginProcessor(string, req, res, bl3);
                    bl = true;
                } else {
                    bl = false;
                }
                if (loginProcessor instanceof RemoteLoginProcessor && (string != null || loginProcessor.getLoginID() == null)) {
                    RemoteLoginProcessor remoteLoginProcessor = (RemoteLoginProcessor)loginProcessor;
                    httpSession = req.getSession();
                    if (LoginManager.a(req, bl3, LoginManager.a(req, bl3))) {
                        res = new DisabledNtlmServletResponse(res);
                    }
                    if (!remoteLoginProcessor.transferClientLoginData(req, res)) {
                        LoginManager.a(req, loginProcessor);
                        LoginManager.b(string, req, res);
                        return false;
                    }
                    if (loginProcessor.getLoginID() != null) {
                        object = loginProcessor.getAuthenticationDescription();
                        if (object != null) {
                            LoginManager.setAuthenticationDescriptionCookie(((AuthenticationDescription)object).getName(), req, res);
                        }
                    } else if (!bl && loginProcessor.getLoginID() == null) {
                        LoginManager.b(string, req, res);
                    }
                }
                if (loginProcessor == null && ConfigurationManager.isRecoveryMode() && (loginProcessor = LoginProcessor.getCurrent()) != null) {
                    LoginManager.a(req, loginProcessor);
                }
                if (loginProcessor == null || object2 != null) break block24;
                try {
                    LoginManager.a(loginProcessor, req, res);
                }
                catch (ClientMessageException clientMessageException) {
                    object = req.getServletPath();
                    if ("/login/windows".equals(object)) {
                        HttpServletResponse httpServletResponse = res;
                        while (httpServletResponse instanceof HttpServletResponseWrapper) {
                            httpServletResponse = (HttpServletResponse)((HttpServletResponseWrapper)httpServletResponse).getResponse();
                        }
                        httpServletResponse.setStatus(401);
                        httpServletResponse = new HttpServletResponseWrapper(httpServletResponse){

                            @Override
                            public void setStatus(int sc) {
                            }
                        };
                        ServletErrorHandler.sendErrorPage(req, httpServletResponse, clientMessageException);
                        return false;
                    }
                    throw clientMessageException;
                }
            }
            catch (Exception exception) {
                LoginProcessor.LOGGER.error(exception);
                req.setAttribute(LOGIN_EXCEPTION, exception);
            }
        }
        return !res.isCommitted();
    }

    private static boolean a(String string, @Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) {
        if (string != null && (string.startsWith("NTLM ") || string.startsWith("Negotiate ")) && "POST".equals(httpServletRequest.getMethod()) && httpServletRequest.getContentLength() == 0) {
            for (AuthenticationDescription authenticationDescription : LoginManager.getAuthenticationDescriptions(httpServletRequest)) {
                try {
                    AuthenticationProvider authenticationProvider = authenticationDescription.getProvider();
                    LoginProcessor loginProcessor = authenticationProvider.createLoginProcessor(authenticationDescription, string, httpServletRequest, true);
                    if (!(loginProcessor instanceof RemoteLoginProcessor)) continue;
                    return ((RemoteLoginProcessor)loginProcessor).transferClientLoginData(httpServletRequest, httpServletResponse);
                }
                catch (RuntimeException runtimeException) {
                }
            }
        }
        return !httpServletResponse.isCommitted();
    }

    public static void initUserAccount(@Nonnull HttpSession session) {
        LoginProcessor loginProcessor = LoginManager.getLoginProcessor(session);
        if (loginProcessor != null) {
            LoginManager.a(loginProcessor, null, null);
        }
    }

    @Nullable
    public static LoginProcessor getLoginProcessor(@Nonnull HttpSession session) {
        try {
            return (LoginProcessor)session.getAttribute(WEB_USER_INFO);
        }
        catch (ClassCastException classCastException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private static boolean a(@Nonnull LoginProcessor loginProcessor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        GUID gUID = FormLoginServlet.getUserAccountIDInternal(loginProcessor, httpServletRequest, httpServletResponse);
        if (gUID != null) {
            LoginProcessor.setCurrent(loginProcessor);
            UserManager userManager = UserManager.getInstance();
            userManager.setCurrentUserAccountID(gUID);
            return true;
        }
        return loginProcessor.getLoginID() != null;
    }

    public static LoginProcessor createLoginProcessor(@Nullable String authorization, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, boolean isApplication) {
        boolean bl = authorization != null && authorization.startsWith("Basic ");
        LoginProcessor loginProcessor = null;
        RuntimeException runtimeException = null;
        List<AuthenticationDescription> list = LoginManager.a(request, isApplication);
        for (AuthenticationDescription authenticationDescription : list) {
            try {
                AuthenticationProvider authenticationProvider = authenticationDescription.getProvider();
                LoginProcessor loginProcessor2 = authenticationProvider.createLoginProcessor(authenticationDescription, authorization, request, isApplication);
                if (loginProcessor2 == null) continue;
                if (FormLoginServlet.getUserAccountIDInternal(loginProcessor2, request, response) == null && loginProcessor2.getLoginID() == null) {
                    if (bl) {
                        if (loginProcessor != null) continue;
                        loginProcessor = loginProcessor2;
                        continue;
                    }
                } else if (!LoginManager.isTokenLoginSource(authenticationProvider.name())) {
                    LoginManager.a(request, loginProcessor2);
                    LoginManager.setAuthenticationDescriptionCookie(authenticationDescription.getName(), request, response);
                }
                return loginProcessor2;
            }
            catch (ClientMessageException clientMessageException) {
                throw clientMessageException;
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
            }
        }
        if (loginProcessor == null || loginProcessor.getLoginID() == null) {
            if (runtimeException != null) {
                throw runtimeException;
            }
            LoginManager.b(authorization, request, response);
        }
        return loginProcessor;
    }

    private static void b(String string, @Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) {
        if (string == null) {
            return;
        }
        String string2 = null;
        if (string.startsWith("Basic ")) {
            string2 = BasicLoginProcessor.a(string)[0];
        } else {
            NtlmMessage ntlmMessage = NtlmMessage.parseAuthorizationHttpHeader(string);
            if (ntlmMessage != null) {
                string2 = ntlmMessage.getUser();
            }
        }
        if (string2 != null) {
            if (e.get(string) != null) {
                return;
            }
            e.put(string, string);
            SecurityEventLog.LoginFailed.log(string2);
            for (LoginListener loginListener : DynamicExtensionManager.getInstance().get(LoginListener.class)) {
                try {
                    loginListener.userLoginFailed(string2, httpServletRequest, httpServletResponse);
                }
                catch (Exception exception) {
                    LoginProcessor.LOGGER.error(exception);
                }
            }
        }
    }

    public static void setAuthenticationDescriptionCookie(@Nonnull String name, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        Cookie cookie = new Cookie(AUTHENTICATION_DESCRIPTION_COOKIE + request.getLocalPort(), name);
        cookie.setHttpOnly(true);
        cookie.setSecure(request.isSecure());
        String string = request.getContextPath();
        cookie.setPath(string.isEmpty() ? "/" : string);
        cookie.setMaxAge(StringFunctions.isEmpty(name) ? 0 : -1);
        cookie.setAttribute("SameSite", StayLoggedInHandler.SAME_SITE.get());
        response.addCookie(cookie);
    }

    public static List<AuthenticationDescription> getAuthenticationDescriptions(@Nonnull HttpServletRequest request) {
        boolean bl = LoginManager.isApplicationRequest(request);
        return LoginManager.a(request, bl);
    }

    private static List<AuthenticationDescription> a(@Nonnull HttpServletRequest httpServletRequest, boolean bl) {
        LoginManager.b();
        boolean bl2 = ProxyHttpServletRequest.isProxyRequest(httpServletRequest);
        return bl ? (bl2 ? LoginManager.c.e : LoginManager.c.c) : (bl2 ? LoginManager.c.f : LoginManager.c.d);
    }

    @Nonnull
    public static List<AuthenticationDescription> getAllAuthenticationDescriptions() {
        LoginManager.b();
        return LoginManager.c.i;
    }

    @Nonnull
    public static List<AuthenticationDescription> getBrowserAuthenticationDescriptions() {
        LoginManager.b();
        return LoginManager.c.d;
    }

    @Nonnull
    public static Set<String> getActiveStayLoginProviders() {
        LoginManager.b();
        return LoginManager.c.j;
    }

    @SuppressFBWarnings(value={"COOKIE_USAGE"}, justification="cookie data need live longer as session")
    public static boolean forceLogin(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        boolean bl;
        LoginProcessor loginProcessor = LoginProcessor.getCurrent();
        if (loginProcessor != null) {
            return LoginManager.b(loginProcessor, request, response);
        }
        List<AuthenticationDescription> list = LoginManager.getAuthenticationDescriptions(request);
        Cookie[] cookieArray = request.getCookies();
        if (cookieArray != null) {
            String string = AUTHENTICATION_DESCRIPTION_COOKIE + request.getLocalPort();
            for (Cookie cookie : cookieArray) {
                if (!Objects.equals(string, cookie.getName())) continue;
                String string2 = cookie.getValue();
                for (AuthenticationDescription authenticationDescription : list) {
                    if (!Objects.equals(string2, authenticationDescription.getName())) continue;
                    return LoginManager.forceLogin(authenticationDescription, request, response);
                }
                response.setStatus(401);
                return false;
            }
        }
        if (!(bl = LoginManager.isApplicationRequest(request)) && ServerPluginManager.getInstance().isPluginLoaded("remotegui") && (list.size() > 1 || list.size() == 1 && list.get(0).getBasicSupport() == AuthenticationDescription.BasicSupport.Only || list.size() == 0 && LoginManager.isGuestAccount())) {
            block9: {
                try {
                    PluginDispatcherServlet.forward("/login/", request, response);
                }
                catch (Exception exception) {
                    if (ServletErrorHandler.isClientAbort(exception)) break block9;
                    LoginProcessor.LOGGER.debug(exception);
                    ErrorCode.throwAny(exception);
                }
            }
            return false;
        }
        if (LoginManager.a(request, bl, list)) {
            response = new DisabledNtlmServletResponse(response);
        }
        for (AuthenticationDescription authenticationDescription : list) {
            if (LoginManager.isTokenLoginSource(authenticationDescription.getName()) || bl && authenticationDescription.getBasicSupport() == AuthenticationDescription.BasicSupport.No) continue;
            return LoginManager.forceLogin(authenticationDescription, request, response);
        }
        response.setStatus(403);
        return false;
    }

    private static boolean a(HttpServletRequest httpServletRequest, boolean bl, List<AuthenticationDescription> list) {
        String string;
        String string2 = httpServletRequest.getParameter("login");
        if (string2 != null) {
            switch (string2) {
                case "": 
                case "true": {
                    return true;
                }
                case "windows": {
                    return false;
                }
            }
        }
        if ((string = httpServletRequest.getHeader("Authorization")) != null && (string.startsWith("NTLM ") || string.startsWith("Negotiate "))) {
            return false;
        }
        int n2 = 0;
        for (AuthenticationDescription authenticationDescription : list) {
            if (LoginManager.isTokenLoginSource(authenticationDescription.getName()) || bl && authenticationDescription.getBasicSupport() == AuthenticationDescription.BasicSupport.No) continue;
            ++n2;
        }
        return n2 > 1;
    }

    public static boolean isUserManagerAvailable() {
        return VetoManager.getInstance().isAlreadyProcessed(UserSearchIndexVetoPower.TYPE);
    }

    public static boolean isTokenLoginSource(String loginSource) {
        LoginManager.b();
        return LoginManager.c.k.contains(loginSource);
    }

    private static boolean b(LoginProcessor loginProcessor, @Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            httpSession.removeAttribute(LOGOUT_INFO);
        }
        LoginManager.a(loginProcessor, httpServletRequest, httpServletResponse);
        if (loginProcessor.getLoginID() == null) {
            if (VetoManager.getInstance().isCurrentlyVetoed() && !LoginManager.isUserManagerAvailable() && ("master" != loginProcessor.getLoginSource() || START_TIME + 5000L > System.currentTimeMillis())) {
                if (httpSession != null) {
                    httpSession.removeAttribute(WEB_USER_INFO);
                }
                throw new ServiceUnavailableException();
            }
            if (loginProcessor instanceof RemoteLoginProcessor) {
                ((RemoteLoginProcessor)loginProcessor).requestLoginData(httpServletRequest, httpServletResponse);
                return false;
            }
            httpServletResponse.setStatus(403);
            HttpFailedException httpFailedException = new HttpFailedException(403, "Authentication unsuccessful. There seems to be an error in the login settings: " + loginProcessor.getClass().getName());
            ServletErrorHandler.sendErrorPage(httpServletRequest, httpServletResponse, httpFailedException);
            return false;
        }
        LoginManager.a(httpServletRequest, loginProcessor);
        return true;
    }

    public static boolean forceLogin(@Nonnull AuthenticationDescription authDesc, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        boolean bl;
        AuthenticationProvider authenticationProvider = authDesc.getProvider();
        LoginProcessor loginProcessor = authenticationProvider.create(authDesc);
        AuthenticationDescription.BasicSupport basicSupport = authDesc.getBasicSupport();
        if (basicSupport != AuthenticationDescription.BasicSupport.Only && response.getClass() != DisabledNtlmServletResponse.class || basicSupport == AuthenticationDescription.BasicSupport.No) {
            LoginManager.a(request, loginProcessor);
        }
        if (bl = LoginManager.b(loginProcessor, request, response)) {
            LoginManager.setAuthenticationDescriptionCookie(authDesc.getName(), request, response);
        } else {
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {
                LoginProcessor.LOGGER.error(iOException);
            }
        }
        return bl;
    }

    public static String normalizeSlashes(String string) {
        if (string != null) {
            return string.replaceAll("\\\\", "/");
        }
        return string;
    }

    public static void setCurrentLoginProcessor(@Nonnull HttpServletRequest request, @Nonnull LoginProcessor login) {
        LoginManager.a(request, login);
    }

    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="data are save")
    private static void a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull LoginProcessor loginProcessor) {
        HttpSession httpSession = httpServletRequest.getSession();
        a a2 = (a)httpSession.getAttribute(ADD_SIGN_UP_STATE);
        if (a2 != null) {
            a2.b = loginProcessor;
        } else {
            httpSession.setAttribute(WEB_USER_INFO, loginProcessor);
        }
    }

    @Nullable
    private static a a(@Nonnull HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            return (a)httpSession.getAttribute(ADD_SIGN_UP_STATE);
        }
        return null;
    }

    public static void startAddSignUpMode(@Nonnull HttpServletRequest request, @Nullable AuthenticationDescription authDesc, GUID accountID) {
        a a2 = LoginManager.a(request);
        if (a2 == null || accountID != null && !accountID.equals(a2.a)) {
            a2 = new a();
            a2.a = accountID;
            if (authDesc != null) {
                AuthenticationProvider authenticationProvider = authDesc.getProvider();
                a2.b = authenticationProvider.create(authDesc);
            }
            request.getSession().setAttribute(ADD_SIGN_UP_STATE, a2);
        }
    }

    public static boolean isAddSignUpMode(@Nonnull HttpServletRequest request) {
        a a2 = LoginManager.a(request);
        if (a2 == null) {
            return false;
        }
        return a2.c == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static LoginSettings getAddSignUpModeResult(HttpServletRequest request) throws ClientMessageException {
        a a2 = LoginManager.a(request);
        if (a2 == null) {
            return null;
        }
        try {
            if (a2.c != null) {
                LoginSettings loginSettings = a2.c;
                return loginSettings;
            }
            LoginProcessor loginProcessor = a2.b;
            if (loginProcessor == null) {
                LoginSettings loginSettings = null;
                return loginSettings;
            }
            GUID gUID = FormLoginServlet.getUserAccountIDInternal(loginProcessor, null, null);
            if (gUID != null && a2.c == null) {
                LoginSettings loginSettings = loginProcessor.createLoginSettings(loginProcessor.getLoginID());
                if (gUID.equals(a2.a)) {
                    LoginSettings loginSettings2 = loginSettings;
                    return loginSettings2;
                }
                throw new ClientMessageException(LoginApiAccessor.I18N.getMsg("login.already.use", loginSettings.getDisplayName()));
            }
            if (a2.c == null) {
                LoginSettings loginSettings = null;
                return loginSettings;
            }
            LoginSettings loginSettings = a2.c;
            return loginSettings;
        }
        finally {
            request.getSession().removeAttribute(ADD_SIGN_UP_STATE);
        }
    }

    @Nonnull
    public static GUID loginTempUser(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse res, @Nonnull String loginID, @Nonnull String displayName, Permission ... permissions) {
        HttpSession httpSession = req.getSession();
        TempLoginProcessor tempLoginProcessor = new TempLoginProcessor(loginID, displayName, permissions);
        LoginManager.setCurrentLoginProcessor(req, tempLoginProcessor);
        LoginManager.initUserAccount(httpSession);
        StayLoggedInHandler.handleCookie(tempLoginProcessor.getLoginSource(), req, res, true);
        return tempLoginProcessor.getUserAccountID();
    }

    static {
        DynamicExtensionManager.getInstance().registerListener(AuthenticationProvider.class, list -> LoginManager.a());
        RecoveryConfigValue<String> recoveryConfigValue = new RecoveryConfigValue<String>(ConfigKey.MASTER_PASSWORD){

            @Override
            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                ForkJoinPool.commonPool().execute(() -> LoginManager.a());
            }
        };
        a = new RecoveryConfigValue(ConfigKey.AUTHENTICATION_ALLOW_NEW_USER);
        b = new RecoveryConfigValue<HashMap<String, String>[]>(ConfigKey.AUTHENTICATION_SETTINGS){

            @Override
            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                LoginManager.a();
            }
        };
        LoginApiAccessor.a(new c());
        d = new DynamicExtension<LoginListener>(LoginListener.class);
        START_TIME = System.currentTimeMillis();
        e = new MemoryStoreMap(300, true);
    }

    static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b();
        public static final /* enum */ b b = new b();
        public static final /* enum */ b c = new b();
        private static final /* synthetic */ b[] d;

        public static b[] values() {
            return (b[])d.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{a, b, c};
        }

        static {
            d = com.inet.authentication.base.LoginManager$b.a();
        }
    }

    private static class a {
        private GUID a;
        private LoginProcessor b;
        private LoginSettings c;

        private a() {
        }
    }

    private static class c
    extends LoginApiAccessor {
        private c() {
        }

        @Override
        @Nullable
        public UserAccount createUserAccount(@Nonnull UserAccountType accountType, @Nonnull LoginSettings settings, @Nonnull MutableUserData userData) throws IllegalArgumentException {
            a a2;
            HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
            if (httpServletRequest != null && (a2 = LoginManager.a(httpServletRequest)) != null) {
                a2.c = settings;
                return null;
            }
            return super.createUserAccount(accountType, settings, userData);
        }

        @Override
        public boolean isAddSignUpMode() {
            HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
            if (httpServletRequest != null) {
                return LoginManager.isAddSignUpMode(httpServletRequest);
            }
            return super.isAddSignUpMode();
        }
    }
}

