/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.taskplanner.openweathermap;

/**
 * Defines the available units setting for getting weather data.
 */
public enum Units {

    /**
     * Default units with Kelvin and meters per second
     */
    DEFAULT( "K", "m/s" ),
    /**
     * Metric units with Celsius und kilometers per hour
     */
    METRIC( "°C", "km/h" ),
    /**
     * Imperial units with Fahrenheit and miles per hour
     */
    IMPERIAL( "°F", "mph" );

    private String temperatureUnit;
    private String speedUnit;

    /**
     * Creates the units.
     * @param temperatureUnit the unit for the temperature
     * @param speedUnit the unit for the wind speed
     */
    private Units( String temperatureUnit, String speedUnit ) {
        this.temperatureUnit = temperatureUnit;
        this.speedUnit = speedUnit;
    }

    /**
     * Returns the unit for the temperature
     * @return the unit for the temperature
     */
    public String getTemperatureUnit() {
        return temperatureUnit;
    }

    /**
     * Returns the unit for the wind speed
     * @return the unit for the wind speed
     */
    public String getSpeedUnit() {
        return speedUnit;
    }

}
