/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.index;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.http.servlet.ClientLocale;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.command.PhraseSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.index.IdType;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.ListenerTokenMatcher;
import com.inet.search.index.SearchResultHolder;
import com.inet.search.index.SearchResultListener;
import com.inet.search.index.a;
import com.inet.search.index.i;
import com.inet.search.index.o;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class TagIndex<ID> {
    protected static final String VERSION = "version";
    protected static final String DATATYPE = "datatype";
    protected static final String ID_DATATYPE = "iddatatype";
    @Nonnull
    private final SearchTag a;
    private static final MemoryStoreMap<Map<? extends Object, String>, i> b = new MemoryStoreMap(900, true);
    private CopyOnWriteArrayList<SearchResultListener<ID>> c;
    public static final Comparable<?> NULL = "null.88487u7u6fodk4fcum69y";

    protected TagIndex(@Nonnull SearchTag searchTag) {
        this.a = searchTag;
    }

    protected abstract boolean isNew();

    protected String getTag() {
        return this.a.getTag();
    }

    @Nonnull
    protected SearchDataType getDataType() {
        return this.a.getDataType();
    }

    protected Class<?> getDataClass() {
        switch (this.getDataType()) {
            case String: 
            case ID: 
            case StringMap: {
                return String.class;
            }
            case Integer: 
            case IntegerMap: {
                return Integer.class;
            }
            case Long: 
            case Date: {
                return Long.class;
            }
            case Double: {
                return Double.class;
            }
        }
        throw new IllegalStateException("Unknown data type: " + String.valueOf((Object)this.getDataType()));
    }

    protected SearchTag getSearchTag() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    a c() {
        Map<Comparable<?>, String> map = this.a.getMapData();
        i i2 = (i)b.get(map);
        if (i2 == null) {
            MemoryStoreMap<Map<? extends Object, String>, i> memoryStoreMap = b;
            synchronized (memoryStoreMap) {
                i2 = (i)b.get(map);
                if (i2 == null) {
                    TextSearchTokenizer textSearchTokenizer = TextSearchTokenizer.DEFAULT;
                    i2 = new i(null, IdType.a);
                    for (Map.Entry<Comparable<?>, String> entry : map.entrySet()) {
                        Comparable<?> comparable = entry.getKey();
                        for (String string : textSearchTokenizer.tokens(entry.getValue(), 3)) {
                            if (string.length() <= 0) continue;
                            i2.a(comparable, (Comparable<?>)((Object)TagIndex.a(string)));
                        }
                    }
                    b.put(map, i2);
                }
            }
        }
        return i2;
    }

    @Nonnull
    private static String a(String string) {
        if (string.length() > 100) {
            string = string.substring(0, 100);
        }
        return string.toLowerCase();
    }

    void a(ID ID, @Nullable Object object) {
        try {
            switch (this.a.getDataType()) {
                case String: 
                case ID: 
                case StringMap: {
                    this.c(ID, this.a.getTokenizer().tokens(object, 3));
                    break;
                }
                default: {
                    this.c(ID, object);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Invalid value for " + this.getTag() + ", index type: " + String.valueOf((Object)this.a.getDataType()) + ", id: " + String.valueOf(ID) + ", value: " + String.valueOf(object), throwable);
        }
    }

    Object b(ID ID, @Nullable Object object) {
        switch (this.a.getDataType()) {
            case String: 
            case ID: 
            case StringMap: {
                return this.a.getTokenizer().tokens(object, 3);
            }
        }
        return object;
    }

    void c(ID ID, @Nullable Object object) {
        try {
            if (object instanceof Collection) {
                for (Comparable comparable : (Collection)object) {
                    this.addToken(ID, this.a(comparable));
                }
            } else {
                this.addToken(ID, this.a(object));
            }
            this.a();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Invalid value for " + this.getTag() + ", index type: " + String.valueOf((Object)this.a.getDataType()) + ", id: " + String.valueOf(ID) + ", value: " + String.valueOf(object), throwable);
        }
    }

    void a(ID ID, Object object, Object object2) {
        if (Objects.equals(object, object2)) {
            return;
        }
        switch (this.a.getDataType()) {
            case String: 
            case ID: 
            case StringMap: {
                Set<String> set = this.a.getTokenizer().tokens(object, 3);
                Set<String> set2 = this.a.getTokenizer().tokens(object2, 3);
                for (String string : set2) {
                    if (set.contains(string)) continue;
                    this.addToken(ID, this.a(string));
                }
                for (String string : set) {
                    if (set2.contains(string)) continue;
                    this.removeToken(ID, this.a(string));
                }
                break;
            }
            default: {
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    Collection collection2 = (Collection)object2;
                    for (Comparable comparable : collection) {
                        if (collection2.contains(comparable)) continue;
                        this.removeToken(ID, this.a(comparable));
                    }
                    for (Comparable comparable : collection2) {
                        if (collection.contains(comparable)) continue;
                        this.addToken(ID, this.a(comparable));
                    }
                    break;
                }
                this.removeToken(ID, this.a(object));
                this.addToken(ID, this.a(object2));
            }
        }
        this.a();
    }

    protected abstract boolean addToken(ID var1, @Nullable Comparable<?> var2);

    protected abstract boolean removeToken(ID var1, @Nullable Comparable<?> var2);

    protected void searchToken(@Nonnull Object token, SearchCondition condition, SearchResultHolder<ID> resultHolder) {
        Object[] objectArray;
        String string;
        try {
            SearchCondition.SearchTermOperator searchTermOperator = condition.getOperator();
            switch (searchTermOperator) {
                case BETWEEN: 
                case NOT_BETWEEN: {
                    string = null;
                    Object[] objectArray2 = (Object[])token;
                    objectArray = new Object[]{this.a(objectArray2[0]), this.a(objectArray2[1])};
                    break;
                }
                case IN: {
                    String string2 = null;
                    SearchCondition searchCondition = new SearchCondition(condition, SearchCondition.SearchTermOperator.Equals);
                    for (Object object : (Collection)token) {
                        object = this.a(object);
                        this.search(object, searchCondition, resultHolder, string2);
                    }
                    return;
                }
                default: {
                    string = String.valueOf(token);
                    switch (this.getDataType()) {
                        case StringMap: 
                        case IntegerMap: {
                            if (!condition.isFromTextExpression()) break;
                            if (searchTermOperator == SearchCondition.SearchTermOperator.Equals) {
                                String string3 = PhraseSearchExpression.normalize(string);
                                Map<Comparable<?>, String> map = this.a.getMapData();
                                for (Map.Entry<Comparable<?>, String> entry : map.entrySet()) {
                                    String string4 = PhraseSearchExpression.normalize(entry.getValue());
                                    if (!string3.equals(string4)) continue;
                                    this.search(entry.getKey(), condition, resultHolder, string);
                                }
                                if (this.getSearchTag().showAlsoNonMapValues() && this.getDataType() == SearchDataType.StringMap) {
                                    this.search(string, condition, resultHolder, string);
                                }
                            } else if (this.a.useDisplaynamesForComparisonSign() || searchTermOperator == SearchCondition.SearchTermOperator.StartsWith || searchTermOperator == SearchCondition.SearchTermOperator.Contains) {
                                o o2 = new o();
                                a a2 = this.c();
                                a2.a(token, condition, o2, this.getTag(), string);
                                o2.e();
                                SearchCondition searchCondition = new SearchCondition(condition, SearchCondition.SearchTermOperator.Equals);
                                for (Comparable comparable : (HashSet)o2.e) {
                                    this.search(comparable, searchCondition, resultHolder, string);
                                }
                            } else {
                                String string5 = PhraseSearchExpression.normalize(string);
                                Map<Comparable<?>, String> map = this.a.getMapData();
                                for (Map.Entry<Comparable<?>, String> entry : map.entrySet()) {
                                    String string6 = PhraseSearchExpression.normalize(entry.getValue());
                                    if (!string5.equals(string6)) continue;
                                    Comparable<?> comparable = entry.getKey();
                                    this.search(comparable, condition, resultHolder, string);
                                    return;
                                }
                                if (searchTermOperator == SearchCondition.SearchTermOperator.Unequals) {
                                    if (this.getDataType() == SearchDataType.IntegerMap) {
                                        this.search(Integer.MIN_VALUE, new SearchCondition(condition, SearchCondition.SearchTermOperator.GE), resultHolder, string);
                                    } else {
                                        this.search("", new SearchCondition(condition, SearchCondition.SearchTermOperator.GE), resultHolder, string);
                                    }
                                }
                            }
                            return;
                        }
                    }
                    objectArray = this.a(token);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (condition.getLeftOperand() != null) {
                IndexSearchEngine.LOGGER.debug(numberFormatException);
            }
            return;
        }
        this.search(objectArray, condition, resultHolder, string);
    }

    protected abstract void search(Object var1, SearchCondition var2, SearchResultHolder<ID> var3, String var4);

    @Nullable
    Comparable<?> a(Object object) throws NumberFormatException, IllegalStateException {
        return TagIndex.convertToken(object, this.a);
    }

    @Nullable
    public static Comparable<?> convertToken(@Nullable Object token, @Nonnull SearchTag searchTag) throws NumberFormatException, IllegalStateException {
        if (token == null) {
            return null;
        }
        switch (searchTag.getDataType()) {
            case ID: {
                return String.valueOf(token);
            }
            case StringMap: {
                if (!searchTag.showAlsoNonMapValues()) {
                    return String.valueOf(token);
                }
            }
            case String: {
                return TagIndex.a(String.valueOf(token));
            }
            case Integer: 
            case IntegerMap: {
                return token.getClass() == Integer.class ? (Integer)token : (token.getClass() == Boolean.class ? (((Boolean)token).booleanValue() ? 1 : 0) : Integer.valueOf(String.valueOf(token)));
            }
            case Long: 
            case Date: {
                return token.getClass() == Long.class ? (Long)token : Long.valueOf(String.valueOf(token));
            }
            case Double: {
                if (token.getClass() == Double.class) {
                    return (Double)token;
                }
                String string = token.toString();
                try {
                    Number number = NumberFormat.getInstance(ClientLocale.getThreadLocale()).parse(string);
                    return number.getClass() == Double.class ? (Double)number : Double.valueOf(number.doubleValue());
                }
                catch (ParseException parseException) {
                    throw new NumberFormatException(string);
                }
            }
            case Api: {
                return (Comparable)token;
            }
        }
        throw new IllegalStateException("Unknown data type: " + String.valueOf((Object)searchTag.getDataType()));
    }

    protected abstract void getAllIds(SearchResultHolder<ID> var1, SearchCondition var2);

    void d(ID ID, Object object) {
        switch (this.a.getDataType()) {
            case String: 
            case ID: 
            case StringMap: {
                for (String string : this.a.getTokenizer().tokens(object, 3)) {
                    this.removeToken(ID, this.a(string));
                }
                break;
            }
            default: {
                if (object instanceof Collection) {
                    for (Comparable comparable : (Collection)object) {
                        this.removeToken(ID, this.a(comparable));
                    }
                    break;
                }
                this.removeToken(ID, this.a(object));
            }
        }
        this.a();
    }

    protected abstract void finishIndexing();

    protected abstract Object getMinToken();

    protected abstract Object getMaxToken();

    @Nonnull
    protected abstract <T> Iterator<T> createIterator(boolean var1, @Nonnull IteratorType var2, @Nullable Comparable<?> var3, @Nonnull Predicate<ID> var4, @Nullable Function<Object, String> var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(SearchResultListener<ID> searchResultListener, boolean bl) {
        TagIndex tagIndex = this;
        synchronized (tagIndex) {
            if (this.c == null) {
                this.c = new CopyOnWriteArrayList();
            }
            if (bl) {
                this.c.add(searchResultListener);
            } else {
                this.c.remove(searchResultListener);
            }
        }
    }

    private void a() {
        if (this.c != null) {
            for (SearchResultListener<ID> searchResultListener : this.c) {
                searchResultListener.markPossibleChanged();
            }
        }
    }

    protected abstract void handleTokenChangedListener(@Nonnull Comparable<?> var1, @Nonnull SearchResultListener<ID> var2, boolean var3);

    protected abstract void handleTokenChangedListener(@Nonnull ListenerTokenMatcher var1, @Nonnull SearchResultListener<ID> var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTokenChangedListener(Object token, SearchCondition condition, @Nonnull SearchResultListener<ID> listener, boolean add) {
        Object object;
        if (token == null) {
            token = NULL;
        }
        SearchCondition.SearchTermOperator searchTermOperator = condition.getOperator();
        switch (searchTermOperator) {
            case Equals: {
                switch (this.getDataType()) {
                    case StringMap: 
                    case IntegerMap: {
                        if (!condition.isFromTextExpression()) break;
                        String string = String.valueOf(token);
                        String string2 = PhraseSearchExpression.normalize(string);
                        Map<Comparable<?>, String> map = this.getSearchTag().getMapData();
                        for (Map.Entry<Comparable<?>, String> entry : map.entrySet()) {
                            String string3 = PhraseSearchExpression.normalize(entry.getValue());
                            if (!string2.equals(string3)) continue;
                            SearchCondition searchCondition = new SearchCondition(this.getTag(), SearchCondition.SearchTermOperator.Equals, entry.getKey());
                            this.handleTokenChangedListener(entry.getKey(), searchCondition, listener, add);
                        }
                        return;
                    }
                }
                if (token != NULL) {
                    try {
                        token = this.a(token);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
                this.handleTokenChangedListener(token, listener, add);
                return;
            }
            case IN: {
                SearchCondition searchCondition = new SearchCondition(condition, SearchCondition.SearchTermOperator.Equals);
                TagIndex tagIndex = this;
                synchronized (tagIndex) {
                    for (Object e2 : (Collection)((Object)token)) {
                        this.handleTokenChangedListener(e2, searchCondition, listener, add);
                    }
                }
                return;
            }
            case StartsWith: 
            case Contains: 
            case GT: 
            case GE: 
            case LT: 
            case LE: 
            case Unequals: {
                switch (this.getDataType()) {
                    case StringMap: 
                    case IntegerMap: {
                        if (!condition.isFromTextExpression()) break;
                        o o2 = new o();
                        a a2 = this.c();
                        object = new SearchCondition(condition, SearchCondition.SearchTermOperator.Equals);
                        a2.a(token, (SearchCondition)object, o2, this.getTag(), null);
                        o2.e();
                        Set set = (Set)o2.e;
                        if (set.isEmpty()) {
                            return;
                        }
                        switch (searchTermOperator) {
                            case StartsWith: 
                            case Contains: {
                                object = new SearchCondition(condition.getLeftOperand(), SearchCondition.SearchTermOperator.IN, set);
                                this.handleTokenChangedListener(set, (SearchCondition)object, listener, add);
                                return;
                            }
                        }
                        token = set.iterator().next();
                    }
                }
                switch (searchTermOperator) {
                    case StartsWith: 
                    case Contains: {
                        if (this.getDataClass() == String.class) break;
                        return;
                    }
                }
                try {
                    token = this.a(token);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.getDataClass().isInstance(token)) break;
                return;
            }
            case BETWEEN: {
                if (this.getDataType() != SearchDataType.Date) break;
                token = ((Object[])token)[0];
                searchTermOperator = SearchCondition.SearchTermOperator.GE;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf((Object)searchTermOperator) + ":" + String.valueOf(token));
            }
        }
        object = new ListenerTokenMatcher(token, searchTermOperator);
        this.handleTokenChangedListener((ListenerTokenMatcher)object, listener, add);
    }

    protected void dumpTo(PrintStream target) throws IOException {
        target.println("\t" + String.valueOf(this));
    }

    public static final class IteratorType
    extends Enum<IteratorType> {
        public static final /* enum */ IteratorType ID = new IteratorType();
        public static final /* enum */ IteratorType VALUES = new IteratorType();
        public static final /* enum */ IteratorType ENTRY = new IteratorType();
        private static final /* synthetic */ IteratorType[] a;

        public static IteratorType[] values() {
            return (IteratorType[])a.clone();
        }

        public static IteratorType valueOf(String name) {
            return Enum.valueOf(IteratorType.class, name);
        }

        private static /* synthetic */ IteratorType[] a() {
            return new IteratorType[]{ID, VALUES, ENTRY};
        }

        static {
            a = IteratorType.a();
        }
    }
}

