/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.fs;

import com.inet.plugin.fs.ArchiveFile;
import com.inet.plugin.fs.ResourceFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javax.annotation.Nonnull;

public class VirtualFile
implements ResourceFile {
    private final String a;
    private final long b;
    private final InputStream c;
    private final long d;

    public VirtualFile(String name, long lastModified, InputStream content, long length) {
        this.a = name;
        this.b = lastModified;
        this.c = content;
        this.d = length;
    }

    @Override
    public ResourceFile createChild(@Nonnull String child) {
        return new VirtualFile(child, 0L, null, 0L);
    }

    @Override
    public String getName() {
        return this.a;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public String getAbsolutePath() {
        return this.a;
    }

    @Override
    public ResourceFile[] listFiles() {
        return null;
    }

    @Override
    public ArchiveFile createArchiveFile() throws ZipException, IOException {
        return new ArchiveFile(){

            @Override
            public String getName() {
                return VirtualFile.this.a;
            }

            @Override
            public InputStream getInputStream(ZipEntry entry) throws IOException {
                return null;
            }

            @Override
            public ZipEntry getEntry(String name) throws IOException {
                return null;
            }

            @Override
            public ZipEntry getNextEntry() throws IOException {
                return null;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public String getPath() {
        return this.a;
    }

    @Override
    public long lastModified() {
        return this.b;
    }

    @Override
    @Nonnull
    public URL getURL() throws MalformedURLException {
        throw new UnsupportedOperationException("A virtual file does not have a URL.");
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws FileNotFoundException {
        if (this.c == null) {
            throw new FileNotFoundException("There is no content available for '" + this.a + "'");
        }
        return this.c;
    }

    protected void finalize() throws Throwable {
        if (this.c != null) {
            try {
                this.c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public long length() {
        return this.d;
    }
}

