/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin;

import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.utils.CompoundEnumeration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DependencyClassLoader
extends URLClassLoader {
    private final HashMap<String, ClassLoader> a = new HashMap();
    private final String b;
    private final boolean c;
    private URLClassLoader d;
    private static final Object e = new Object();
    private static boolean f;
    private static Method g;
    private static final ClassLoader h;

    public DependencyClassLoader(URL[] urls, String pluginId) {
        this(urls, pluginId, false);
    }

    DependencyClassLoader(URL[] urls, String pluginId, boolean useTranslationURL) {
        super(urls);
        this.b = pluginId;
        this.c = useTranslationURL;
    }

    DependencyClassLoader(URL[] urls, ClassLoader parent, String pluginId, boolean useTranslationURL) {
        super(urls, parent);
        this.b = pluginId;
        this.c = useTranslationURL;
    }

    public String getPluginId() {
        return this.b;
    }

    public void addClassLoader(String packageName, @Nonnull ClassLoader cl) throws IllegalStateException {
        Objects.requireNonNull(cl, "ClassLoader");
        ClassLoader classLoader = this.a.put(packageName, cl);
        if (classLoader != null && classLoader != cl) {
            throw new IllegalStateException("Redefine classloader for package " + packageName + " of classloader " + String.valueOf(cl) + " and replace with " + String.valueOf(classLoader));
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("java.") || name.startsWith("javax.")) {
            try {
                return h.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        String string = name;
        ClassNotFoundException classNotFoundException = null;
        while (true) {
            ClassLoader classLoader;
            if (string.isEmpty()) {
                try {
                    return super.loadClass(name, resolve);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    if (classNotFoundException == null) {
                        classNotFoundException = classNotFoundException2;
                    }
                    classNotFoundException.addSuppressed(new Exception("Plugin " + this.b + " " + String.valueOf(Arrays.asList(this.getURLs())) + "\n\tdependencies: " + String.valueOf(this.a.keySet())));
                    throw classNotFoundException;
                }
            }
            int n2 = string.lastIndexOf(46);
            if (n2 < 0) {
                n2 = 0;
            }
            if ((classLoader = this.a.get(string = string.substring(0, n2))) == null) continue;
            try {
                return classLoader != this ? classLoader.loadClass(name) : super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException classNotFoundException3) {
                if (classNotFoundException == null) {
                    classNotFoundException = classNotFoundException3;
                }
                if (classNotFoundException3.getCause() != null) continue;
                classNotFoundException.addSuppressed(new Exception(this.a(classLoader, string)));
                continue;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (!(noClassDefFoundError.getCause() instanceof ClassNotFoundException) || (classNotFoundException = (ClassNotFoundException)noClassDefFoundError.getCause()).getCause() != null) continue;
                classNotFoundException.addSuppressed(new Exception(this.a(classLoader, string)));
                continue;
            }
            break;
        }
    }

    private String a(ClassLoader classLoader, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Plugin ").append(this.b);
        stringBuilder.append(" for package ").append(string);
        if (classLoader instanceof DependencyClassLoader) {
            stringBuilder.append(" in dependencies ").append(((DependencyClassLoader)classLoader).b);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTranslation() {
        if (this.c) {
            URLClassLoader uRLClassLoader;
            Object object = e;
            synchronized (object) {
                uRLClassLoader = this.d;
                this.d = null;
            }
            if (uRLClassLoader != null) {
                try {
                    uRLClassLoader.close();
                }
                catch (IOException iOException) {
                    LogManager.getConfigLogger().error(iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        if (this.c) {
            URL[] uRLArray;
            Object object;
            Object object2;
            Object object3;
            URLClassLoader uRLClassLoader = this.d;
            if (uRLClassLoader == null) {
                if (ServerPluginManager.getInstance().getCorePluginId() == null) {
                    return this.a(name);
                }
                object3 = ServerPluginManager.getInstance().getTranslationsDir();
                try {
                    object2 = object3.createChild(this.b + ".translation.zip");
                    if (object2.exists()) {
                        LogManager.getConfigLogger().debug("Use custom translation for plugin: " + this.b);
                    }
                    object = object2.getURL();
                    uRLArray = new URL[]{object};
                }
                catch (MalformedURLException malformedURLException) {
                    uRLArray = new URL[]{};
                }
                object2 = e;
                synchronized (object2) {
                    if (this.d == null) {
                        this.d = new URLClassLoader(uRLArray, null);
                    }
                    uRLClassLoader = this.d;
                }
            }
            if ((object3 = ((ClassLoader)uRLClassLoader).getResourceAsStream(name)) != null) {
                uRLArray = name.endsWith(".properties") ? super.getResource(name) : null;
                try {
                    object2 = new FastByteArrayOutputStream();
                    if (uRLArray != null) {
                        object = uRLArray.openStream();
                        try {
                            IOFunctions.copyData((InputStream)object, (OutputStream)object2);
                        }
                        finally {
                            if (object != null) {
                                ((InputStream)object).close();
                            }
                        }
                        ((FastByteArrayOutputStream)object2).write(10);
                    }
                    object = object3;
                    try {
                        IOFunctions.copyData((InputStream)object, (OutputStream)object2);
                    }
                    finally {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                    return IOFunctions.getDataUrl("", ((FastByteArrayOutputStream)object2).toByteArray());
                }
                catch (IOException iOException) {
                    LogManager.getConfigLogger().error(iOException);
                }
            }
        }
        return this.a(name);
    }

    private URL a(String string) {
        URL uRL;
        int n2;
        ClassLoader classLoader;
        String string2 = string;
        do {
            if (string2.isEmpty()) {
                return super.getResource(string);
            }
            n2 = string2.lastIndexOf(47);
            if (n2 >= 0) continue;
            n2 = 0;
        } while ((classLoader = this.a.get((string2 = string2.substring(0, n2)).replace('/', '.'))) == null || (uRL = classLoader != this ? classLoader.getResource(string) : super.getResource(string)) == null);
        return uRL;
    }

    @Override
    @Nonnull
    public @Nonnull Enumeration<@Nonnull URL> getResources(@Nonnull String name) throws IOException {
        ArrayList<Enumeration<URL>> arrayList = new ArrayList<Enumeration<URL>>();
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>();
        this.a(name, arrayList, hashSet);
        return new CompoundEnumeration<URL>(arrayList.toArray(new Enumeration[arrayList.size()]));
    }

    @Nullable
    public ClassLoader getClassLoaderOfResource(String name) {
        URL uRL = this.a(name);
        if (uRL == null) {
            return null;
        }
        String string = "jar".equals(uRL.getProtocol()) ? uRL.getFile() : uRL.toString();
        return this.a(name, string, new HashSet<DependencyClassLoader>());
    }

    @Nullable
    private ClassLoader a(String string, String string2, Set<DependencyClassLoader> set) {
        ClassLoader classLoader;
        if (!set.add(this)) {
            return null;
        }
        String string3 = string;
        while (true) {
            Object object;
            if (string3.isEmpty()) {
                for (URL uRL : this.getURLs()) {
                    if (!string2.startsWith(uRL.toString())) continue;
                    return this;
                }
                return null;
            }
            int n2 = string3.lastIndexOf(47);
            if (n2 < 0) {
                n2 = 0;
            }
            if ((classLoader = this.a.get((string3 = string3.substring(0, n2)).replace('/', '.'))) == null) continue;
            if (classLoader.getClass() == DependencyClassLoader.class) {
                object = ((DependencyClassLoader)classLoader).a(string, string2, set);
                if (object == null) continue;
                return object;
            }
            object = classLoader.getResource(string);
            if (object != null) break;
        }
        return classLoader;
    }

    private void a(String string, ArrayList<Enumeration<URL>> arrayList, HashSet<ClassLoader> hashSet) throws IOException {
        hashSet.add(this);
        for (ClassLoader classLoader : this.a.values()) {
            if (hashSet.contains(classLoader)) continue;
            if (classLoader instanceof DependencyClassLoader) {
                ((DependencyClassLoader)classLoader).a(string, arrayList, hashSet);
                continue;
            }
            hashSet.add(classLoader);
            arrayList.add(classLoader.getResources(string));
        }
        arrayList.add(super.getResources(string));
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        ClassLoader classLoader = null;
        try {
            if (System.getSecurityManager() != null) {
                this.a();
                classLoader = this.getClass().getClassLoader();
                if (g != null && classLoader instanceof SecureClassLoader) {
                    return (PermissionCollection)g.invoke((Object)classLoader, codesource);
                }
            }
            return super.getPermissions(codesource);
        }
        catch (Exception exception) {
            LogManager.getConfigLogger().error(classLoader);
            LogManager.getConfigLogger().error(exception);
            return super.getPermissions(codesource);
        }
    }

    private void a() {
        if (!f) {
            Method method;
            f = true;
            try {
                method = SecureClassLoader.class.getDeclaredMethod("getPermissions", CodeSource.class);
                method.setAccessible(true);
            }
            catch (Exception exception) {
                LogManager.getConfigLogger().warn(exception);
                method = null;
            }
            g = method;
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.b;
    }

    static {
        h = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            public ClassLoader a() {
                return ClassLoader.getSystemClassLoader();
            }

            @Override
            public /* synthetic */ Object run() {
                return this.a();
            }
        });
    }
}

