/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.ico;

import com.inet.lib.ico.LittleEndianInputStream;
import com.inet.lib.ico.b;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class BMPDecoder {
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;

    private static int a(int n2, int n3) {
        return n2 >> 7 - n3 & 1;
    }

    private static int b(int n2, int n3) {
        return n2 >> 4 * (1 - n3) & 0xF;
    }

    private static void a(Color[] colorArray, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            byArray[i2] = (byte)colorArray[i2].getRed();
            byArray2[i2] = (byte)colorArray[i2].getGreen();
            byArray3[i2] = (byte)colorArray[i2].getBlue();
        }
    }

    public static BufferedImage read(b infoHeader, LittleEndianInputStream lis) throws IOException {
        BufferedImage bufferedImage = null;
        Color[] colorArray = null;
        if (infoHeader.e <= 8) {
            colorArray = BMPDecoder.readColorTable(infoHeader, lis);
        }
        bufferedImage = BMPDecoder.read(infoHeader, lis, colorArray);
        return bufferedImage;
    }

    public static BufferedImage read(b infoHeader, LittleEndianInputStream lis, Color[] colorTable) throws IOException {
        if (infoHeader.f == 0) {
            switch (infoHeader.e) {
                case 1: {
                    return BMPDecoder.read1(infoHeader, lis, colorTable);
                }
                case 4: {
                    return BMPDecoder.read4(infoHeader, lis, colorTable);
                }
                case 8: {
                    return BMPDecoder.read8(infoHeader, lis, colorTable);
                }
                case 24: {
                    return BMPDecoder.read24(infoHeader, lis);
                }
                case 32: {
                    return BMPDecoder.read32(infoHeader, lis);
                }
            }
        }
        throw new IOException("Unrecognized bitmap format: bit count=" + infoHeader.e + ", compression=" + infoHeader.f);
    }

    public static Color[] readColorTable(b infoHeader, LittleEndianInputStream lis) throws IOException {
        Color[] colorArray = new Color[infoHeader.l];
        for (int i2 = 0; i2 < infoHeader.l; ++i2) {
            int n2 = lis.readUnsignedByte();
            int n3 = lis.readUnsignedByte();
            int n4 = lis.readUnsignedByte();
            colorArray[i2] = new Color(n4, n3, n2);
        }
        return colorArray;
    }

    public static BufferedImage read1(b infoHeader, LittleEndianInputStream lis, Color[] colorTable) throws IOException {
        int n2;
        byte[] byArray = new byte[colorTable.length];
        byte[] byArray2 = new byte[colorTable.length];
        byte[] byArray3 = new byte[colorTable.length];
        BMPDecoder.a(colorTable, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(infoHeader.b, infoHeader.c, 12, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = n2 = infoHeader.b;
        if (n3 % 32 != 0) {
            n3 = (n3 / 32 + 1) * 32;
        }
        int n4 = n3 / 8;
        int[] nArray = new int[n4];
        for (int i2 = infoHeader.c - 1; i2 >= 0; --i2) {
            int n5;
            for (n5 = 0; n5 < n4; ++n5) {
                nArray[n5] = lis.readUnsignedByte();
            }
            for (n5 = 0; n5 < infoHeader.b; ++n5) {
                int n6 = n5 / 8;
                int n7 = nArray[n6];
                int n8 = n5 % 8;
                int n9 = BMPDecoder.a(n7, n8);
                writableRaster.setSample(n5, i2, 0, n9);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read4(b infoHeader, LittleEndianInputStream lis, Color[] colorTable) throws IOException {
        byte[] byArray = new byte[colorTable.length];
        byte[] byArray2 = new byte[colorTable.length];
        byte[] byArray3 = new byte[colorTable.length];
        BMPDecoder.a(colorTable, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(4, infoHeader.l, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(infoHeader.b, infoHeader.c, 12, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = infoHeader.b * 4;
        if (n2 % 32 != 0) {
            n2 = (n2 / 32 + 1) * 32;
        }
        int n3 = n2 / 8;
        int[] nArray = new int[n3];
        for (int i2 = infoHeader.c - 1; i2 >= 0; --i2) {
            int n4;
            int n5;
            for (n5 = 0; n5 < n3; ++n5) {
                nArray[n5] = n4 = lis.readUnsignedByte();
            }
            for (n5 = 0; n5 < infoHeader.b; ++n5) {
                n4 = n5 / 2;
                int n6 = n5 % 2;
                int n7 = nArray[n4];
                int n8 = BMPDecoder.b(n7, n6);
                writableRaster.setSample(n5, i2, 0, n8);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read8(b infoHeader, LittleEndianInputStream lis, Color[] colorTable) throws IOException {
        int n2;
        byte[] byArray = new byte[colorTable.length];
        byte[] byArray2 = new byte[colorTable.length];
        byte[] byArray3 = new byte[colorTable.length];
        BMPDecoder.a(colorTable, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(8, infoHeader.l, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(infoHeader.b, infoHeader.c, 13, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = n2 = infoHeader.b;
        if (n3 % 4 != 0) {
            n3 = (n3 / 4 + 1) * 4;
        }
        int n4 = n3 - n2;
        for (int i2 = infoHeader.c - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < infoHeader.b; ++i3) {
                int n5 = lis.readUnsignedByte();
                writableRaster.setSample(i3, i2, 0, n5);
            }
            lis.skipBytes(n4);
        }
        return bufferedImage;
    }

    public static BufferedImage read24(b infoHeader, LittleEndianInputStream lis) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(infoHeader.b, infoHeader.c, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = infoHeader.b * 3;
        int n3 = n2;
        if (n3 % 4 != 0) {
            n3 = (n3 / 4 + 1) * 4;
        }
        int n4 = n3 - n2;
        for (int i2 = infoHeader.c - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < infoHeader.b; ++i3) {
                int n5 = lis.readUnsignedByte();
                int n6 = lis.readUnsignedByte();
                int n7 = lis.readUnsignedByte();
                writableRaster.setSample(i3, i2, 0, n7);
                writableRaster.setSample(i3, i2, 1, n6);
                writableRaster.setSample(i3, i2, 2, n5);
            }
            lis.skipBytes(n4);
        }
        return bufferedImage;
    }

    public static BufferedImage read32(b infoHeader, LittleEndianInputStream lis) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(infoHeader.b, infoHeader.c, 2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage.getAlphaRaster();
        for (int i2 = infoHeader.c - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < infoHeader.b; ++i3) {
                int n2 = lis.readUnsignedByte();
                int n3 = lis.readUnsignedByte();
                int n4 = lis.readUnsignedByte();
                int n5 = lis.readUnsignedByte();
                writableRaster.setSample(i3, i2, 0, n4);
                writableRaster.setSample(i3, i2, 1, n3);
                writableRaster.setSample(i3, i2, 2, n2);
                writableRaster2.setSample(i3, i2, 0, n5);
            }
        }
        return bufferedImage;
    }
}

