/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ColorModelSerializer {
    public static boolean canWrite(ColorModel colorModel) {
        if (colorModel == null) {
            return false;
        }
        if (colorModel instanceof Serializable || colorModel instanceof Externalizable) {
            return true;
        }
        for (a a2 : a.values()) {
            if (colorModel.getClass() != a2.e) continue;
            return true;
        }
        return false;
    }

    public static void write(ColorModel colorModel, ObjectOutputStream stream) throws IOException, NotSerializableException {
        if (colorModel == null) {
            throw new NotSerializableException("A null-ColorModel cannot be serialized");
        }
        if (colorModel instanceof Serializable || colorModel instanceof Externalizable) {
            stream.writeInt(a.d.ordinal());
            stream.writeObject(colorModel);
            return;
        }
        Enum enum_ = null;
        for (a a2 : a.values()) {
            if (colorModel.getClass() != a2.e) continue;
            enum_ = a2;
            break;
        }
        if (enum_ == null) {
            throw new NotSerializableException("ColorModel '" + String.valueOf(colorModel.getClass()) + "' cannot be serialized");
        }
        stream.writeInt(enum_.ordinal());
        stream.writeInt(colorModel.getPixelSize());
        stream.writeObject(colorModel.getComponentSize());
        stream.writeBoolean(colorModel.hasAlpha());
        stream.writeBoolean(colorModel.isAlphaPremultiplied());
        stream.writeInt(colorModel.getTransparency());
        stream.writeInt(colorModel.getTransferType());
        stream.writeObject(colorModel.getColorSpace());
        switch (1.a[enum_.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Object object = (DirectColorModel)colorModel;
                stream.writeInt(((DirectColorModel)object).getRedMask());
                stream.writeInt(((DirectColorModel)object).getGreenMask());
                stream.writeInt(((DirectColorModel)object).getBlueMask());
                stream.writeInt(((DirectColorModel)object).getAlphaMask());
                break;
            }
            case 3: {
                Object object = (IndexColorModel)colorModel;
                int n2 = ((IndexColorModel)object).getMapSize();
                int[] nArray = new int[n2];
                ((IndexColorModel)object).getRGBs(nArray);
                stream.writeInt(n2);
                stream.writeObject(nArray);
                stream.writeInt(((IndexColorModel)object).getTransparentPixel());
                break;
            }
        }
    }

    public static ColorModel read(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        a a2 = a.values()[stream.readInt()];
        if (a2 == a.d) {
            return (ColorModel)stream.readObject();
        }
        int n2 = stream.readInt();
        int[] nArray = (int[])stream.readObject();
        boolean bl = stream.readBoolean();
        boolean bl2 = stream.readBoolean();
        int n3 = stream.readInt();
        int n4 = stream.readInt();
        ColorSpace colorSpace = (ColorSpace)stream.readObject();
        switch (a2) {
            case a: {
                return new ComponentColorModel(colorSpace, bl, bl2, n3, n4);
            }
            case c: {
                int n5 = stream.readInt();
                int n6 = stream.readInt();
                int n7 = stream.readInt();
                int n8 = stream.readInt();
                return new DirectColorModel(colorSpace, n2, n5, n6, n7, n8, bl2, n4);
            }
            case b: {
                int n9 = stream.readInt();
                int[] nArray2 = (int[])stream.readObject();
                int n10 = stream.readInt();
                return new IndexColorModel(n2, n9, nArray2, 0, bl, n10, n4);
            }
        }
        return null;
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a(ComponentColorModel.class);
        public static final /* enum */ a b = new a(IndexColorModel.class);
        public static final /* enum */ a c = new a(DirectColorModel.class);
        public static final /* enum */ a d = new a(Serializable.class);
        private Class<?> e;
        private static final /* synthetic */ a[] f;

        public static a[] values() {
            return (a[])f.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(Class<?> clazz) {
            this.e = clazz;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d};
        }

        static {
            f = com.inet.cache.image.ColorModelSerializer$a.a();
        }
    }
}

