/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache;

import com.inet.id.GUID;
import com.inet.shared.utils.Version;
import java.util.Map;
import javax.annotation.Nonnull;

public interface MemorySize {
    public static final int CHAR_SIZE = Version.getJavaVersion().getMajor() <= 8 ? 2 : 1;

    public long getSizeInMemory();

    public static long getSizeOfObject(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof MemorySize) {
            return ((MemorySize)value).getSizeInMemory();
        }
        if (value instanceof byte[]) {
            return ((byte[])value).length;
        }
        if (value instanceof String) {
            return ((String)value).length() * CHAR_SIZE + 40;
        }
        return MemorySize.getSizeOfClass(value.getClass());
    }

    public static int getSizeOfClass(Class<?> clazz) {
        if (clazz == Integer.class || clazz == Float.class) {
            return 16;
        }
        if (clazz == Long.class || clazz == Double.class) {
            return 24;
        }
        if (clazz == GUID.class) {
            return 0;
        }
        if (clazz == Boolean.class) {
            return 0;
        }
        return 1000;
    }

    public static long getSizeOfMap(@Nonnull Map<?, ?> map) {
        long l2 = 48L;
        try {
            l2 += (long)(map.size() * 40);
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                l2 += MemorySize.getSizeOfObject(entry.getKey()) + MemorySize.getSizeOfObject(entry.getValue());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return l2;
    }
}

