/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.stayloggedin;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.base.LoginApiAccessor;
import com.inet.authentication.base.LoginManager;
import com.inet.authentication.stayloggedin.StayLoggedInHandler;
import com.inet.authentication.stayloggedin.StayLoggedInSession;
import com.inet.http.servlet.ClientLocale;
import com.inet.usersandgroups.api.takeout.TakeoutData;
import com.inet.usersandgroups.api.takeout.TakeoutDataEntry;
import com.inet.usersandgroups.api.takeout.TakeoutDataProvider;
import com.inet.usersandgroups.api.takeout.TextTakeoutDataEntry;
import com.inet.usersandgroups.api.user.UserAccount;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class StayLoggedInTakeoutDataProvider
implements TakeoutDataProvider {
    @Override
    public List<TakeoutData> getTakeoutData(@Nonnull UserAccount userAccount) {
        List<StayLoggedInSession> list = StayLoggedInHandler.getSessions(userAccount.getID());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, ClientLocale.getThreadLocale());
        List<AuthenticationDescription> list2 = LoginManager.getAllAuthenticationDescriptions();
        ArrayList<TakeoutDataEntry> arrayList = new ArrayList<TakeoutDataEntry>();
        for (StayLoggedInSession stayLoggedInSession : list) {
            String string = stayLoggedInSession.getOS().getDisplayName();
            String string2 = stayLoggedInSession.getProvider();
            for (AuthenticationDescription authenticationDescription : list2) {
                if (!Objects.equals(string2, authenticationDescription.getName())) continue;
                string2 = authenticationDescription.getDisplayName();
            }
            String string3 = dateFormat.format(new Date(stayLoggedInSession.getLastUse())) + ", " + string2 + ", " + stayLoggedInSession.getBrowser().getDisplayName();
            arrayList.add(new TextTakeoutDataEntry(string, string3));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return Collections.singletonList(new TakeoutData(LoginApiAccessor.I18N.getMsg("takeout.sessions", new Object[0]), null, arrayList, 42));
    }

    @Override
    public int getPriority() {
        return 42;
    }
}

