/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.junit;

import com.inet.pdfc.junit.ComparisonFailedException;
import com.inet.pdfc.junit.Result;
import com.inet.pdfc.junit.impl.ByteBufferInputStream;
import com.inet.pdfc.junit.impl.PdfData;
import com.inet.pdfc.junit.impl.PdfcServerInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;

public class PDFComparer {
    private Properties profile;
    private String profileName;
    private PdfcServerInfo server = new PdfcServerInfo();

    public void setProfile(@Nonnull InputStream profileXMLstream) throws IOException {
        if (profileXMLstream == null) {
            this.profile = null;
        } else {
            Properties props = new Properties();
            props.loadFromXML(profileXMLstream);
            String val = props.getProperty("LOG_LEVEL");
            if (val != null) {
                if ("OFF".equals(val)) {
                    val = "STATUS";
                }
                if ("ALL".equals(val)) {
                    val = "DEBUG";
                }
                props.setProperty("LOG_LEVEL", val);
            }
            this.profile = props;
        }
        this.profileName = null;
    }

    public void setProfile(String nameOrID) {
        this.profileName = nameOrID;
        this.profile = null;
    }

    public void setProfile(Properties settings) {
        this.profile = settings;
        this.profileName = null;
    }

    public void setServicePath(String servicePath) {
        this.server.setServicePath(servicePath);
    }

    public void setCredentials(String user, String password) {
        this.server.setCredentials(user, password);
    }

    public void setAuthToken(String bearerToken) {
        this.server.setCredentials(bearerToken);
    }

    public <T extends Result> T compare(PdfData expected, PdfData actual, T resultType) throws ComparisonFailedException {
        if (expected == null) {
            throw new ComparisonFailedException(ComparisonFailedException.ERROR_TYPE.missingFirstDocument);
        }
        if (actual == null) {
            throw new ComparisonFailedException(ComparisonFailedException.ERROR_TYPE.missingSecondDocument);
        }
        String boundary = "Boundary-" + System.currentTimeMillis();
        try {
            HashMap<Part, HttpRequest.BodyPublisher> parts = new HashMap<Part, HttpRequest.BodyPublisher>();
            parts.put(new Part("file1", expected.getFileName()), expected.toPublisher());
            parts.put(new Part("file2", expected.getFileName()), actual.toPublisher());
            parts.put(new Part("free"), HttpRequest.BodyPublishers.ofString("true"));
            if (this.profileName != null) {
                parts.put(new Part("profile"), HttpRequest.BodyPublishers.ofString(this.profileName));
            } else if (this.profile != null) {
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    this.profile.storeToXML(out, "");
                    parts.put(new Part("profile", "profile.xml"), HttpRequest.BodyPublishers.ofByteArray(out.toByteArray()));
                }
            }
            resultType.setRequestParameters(parts);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(this.server.getServicePath() + "/compare")).header("Content-Type", "multipart/form-data; boundary=" + boundary);
            this.server.setAuth(requestBuilder);
            this.server.setCookies(requestBuilder);
            HttpRequest request = requestBuilder.POST(PDFComparer.ofMultipartData(parts, boundary)).build();
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            this.server.readCookies(response);
            if (response.statusCode() != 200) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try (InputStream in = response.body();){
                    ByteBufferInputStream.copyData(in, bout);
                }
                throw new ComparisonFailedException(ComparisonFailedException.ERROR_TYPE.resultError, response.statusCode(), new String(bout.toByteArray()));
            }
            try (InputStream in = response.body();){
                resultType.handleRequest(in);
            }
            return resultType;
        }
        catch (IOException | InterruptedException e) {
            throw new ComparisonFailedException(ComparisonFailedException.ERROR_TYPE.serverError, (Throwable)e);
        }
    }

    private static HttpRequest.BodyPublisher ofMultipartData(Map<Part, HttpRequest.BodyPublisher> data, String boundary) {
        ArrayList<HttpRequest.BodyPublisher> publishers = new ArrayList<HttpRequest.BodyPublisher>();
        for (Map.Entry<Part, HttpRequest.BodyPublisher> entry : data.entrySet()) {
            Part part = entry.getKey();
            publishers.add(HttpRequest.BodyPublishers.ofByteArray(("--" + boundary + "\r\n" + part.getContentDisposition() + "\r\n\r\n").getBytes()));
            publishers.add(entry.getValue());
            publishers.add(HttpRequest.BodyPublishers.ofByteArray("\r\n".getBytes()));
        }
        publishers.add(HttpRequest.BodyPublishers.ofByteArray(("--" + boundary + "--\r\n").getBytes()));
        return HttpRequest.BodyPublishers.concat(publishers.toArray(new HttpRequest.BodyPublisher[0]));
    }

    static class Part {
        private String name;
        private String type;
        private String fileName;

        public Part(String name) {
            this.name = name;
            this.type = "form-data";
        }

        public Part(String name, String fileName) {
            this.name = name;
            this.fileName = fileName;
            this.type = "form-data";
        }

        public String getContentDisposition() {
            if (this.fileName != null) {
                return "Content-Disposition: " + this.type + "; name=\"" + this.name + "\"; filename=\"" + this.fileName + "\"";
            }
            return "Content-Disposition: " + this.type + "; name=\"" + this.name + "\"";
        }
    }
}

