/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.remote.client;

import com.inet.mdns.AbstractMulticastDNS;
import com.inet.mdns.ServiceListener;
import com.inet.pdfc.remote.client.RPCClient;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServiceDiscovery {
    private long timeout = 1000L;

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getAnyServiceLocation() throws IOException {
        Map<String, String> services = this.listPDFCServices(true);
        return services.values().stream().findFirst().orElse(null);
    }

    public Map<String, String> getAllServiceLocations() throws IOException {
        return this.listPDFCServices(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> listPDFCServices(final boolean useFirst) throws IOException {
        final Object msgSync = new Object();
        final LinkedHashMap serviceMap = new LinkedHashMap();
        try (AbstractMulticastDNS multicastDNS = new AbstractMulticastDNS(){

            @Override
            protected void logError(Throwable ex) {
                RPCClient.getLogger().error(ex);
            }
        };){
            ServiceListener listener = new ServiceListener(){

                @Override
                public void onServiceReceived(String name, String hostname, int port) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTextReceived(String name, String text) {
                    Object object = msgSync;
                    synchronized (object) {
                        serviceMap.put(name, text);
                        if (useFirst) {
                            msgSync.notifyAll();
                        }
                    }
                }
            };
            multicastDNS.queryService("_pdfcrpc._tcp", listener);
            Object object = msgSync;
            synchronized (object) {
                try {
                    msgSync.wait(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(serviceMap);
                return linkedHashMap;
            }
        }
    }
}

