/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.HasCustomData;
import com.inet.pdfc.model.DrawableElementXY;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@InternalApi
public class TagElement
extends DrawableElementXY
implements HasCustomData {
    public static final String KEY_ALT_TEXT = "alt";
    public static final String KEY_ACTUAL_TEXT = "actual";
    @Nullable
    private Rectangle2D bounds;
    @Nonnull
    private final TagType type;
    @Nullable
    private String lang;
    @Nullable
    private String actualText;
    @Nullable
    private String altText;

    public TagElement(int pageIndex, @Nonnull ElementID id, @Nonnull TagType type, @Nullable String lang, @Nullable String actualText, @Nullable String altText) {
        super(pageIndex, id);
        this.type = type;
        this.lang = lang;
        this.actualText = actualText;
        this.altText = altText;
    }

    @Nonnull
    public TagType getTagType() {
        return this.type;
    }

    @Nullable
    public String getLang() {
        return this.lang;
    }

    @Nullable
    public String getActualText() {
        return this.actualText;
    }

    @Nullable
    public String getAltText() {
        return this.altText;
    }

    @Override
    @Nonnull
    public ElementType getType() {
        return ElementType.Tag;
    }

    @Override
    public String getLabel() {
        return this.getTagType().toString();
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void setBounds(@Nonnull Rectangle2D bounds) {
        this.bounds = bounds;
        this.setX(bounds.getX());
        this.setY(bounds.getY());
    }

    @Override
    public int getCompareHash() {
        return 8;
    }

    @Override
    @Nullable
    public Map<String, String> getCustomData() {
        HashMap<String, String> customData = new HashMap<String, String>();
        if (this.altText != null && !this.altText.isBlank()) {
            customData.put(KEY_ALT_TEXT, this.altText);
        }
        if (this.actualText != null && !this.actualText.isBlank()) {
            customData.put(KEY_ACTUAL_TEXT, this.actualText);
        }
        return customData.isEmpty() ? null : customData;
    }

    public static enum TagType {
        Document(BaseType.Grouping),
        Part(BaseType.Grouping),
        Art(BaseType.Grouping),
        Sect(BaseType.Grouping),
        Div(BaseType.Grouping),
        BlockQuote(BaseType.Grouping),
        Caption(BaseType.Grouping),
        TOC(BaseType.Grouping),
        TOCI(BaseType.Grouping),
        Index(BaseType.Grouping),
        NonStruct(BaseType.Grouping),
        Private(BaseType.Grouping),
        Figure(BaseType.Grouping),
        StructTreeRoot(BaseType.Grouping),
        P(BaseType.Block),
        H(BaseType.Block),
        H1(BaseType.Block),
        H2(BaseType.Block),
        H3(BaseType.Block),
        H4(BaseType.Block),
        H5(BaseType.Block),
        H6(BaseType.Block),
        L(BaseType.Block),
        Lbl(BaseType.Block),
        LI(BaseType.Block),
        LBody(BaseType.Block),
        Table(BaseType.Block),
        TR(BaseType.Block),
        TH(BaseType.Block),
        TD(BaseType.Block),
        TBody(BaseType.Block),
        THead(BaseType.Block),
        TFoot(BaseType.Block),
        Span(BaseType.Inline),
        Quote(BaseType.Inline),
        Note(BaseType.Inline),
        Reference(BaseType.Inline),
        BibEntry(BaseType.Inline),
        Code(BaseType.Inline),
        Link(BaseType.Inline),
        Annot(BaseType.Inline),
        Ruby(BaseType.Inline),
        Warichu(BaseType.Inline),
        Footnote(BaseType.Inline),
        Endnote(BaseType.Inline);

        private static final Map<String, TagType> lcMap;
        private BaseType baseType;

        public static TagType getType(String typeString) {
            TagType type = typeString != null ? lcMap.get(typeString.toLowerCase()) : Private;
            return type != null ? type : Private;
        }

        private TagType(BaseType baseType) {
            this.baseType = baseType;
        }

        public BaseType getBaseType() {
            return this.baseType;
        }

        static {
            lcMap = new HashMap<String, TagType>();
            for (TagType type : TagType.values()) {
                lcMap.put(type.name().toLowerCase(), type);
            }
        }

        public static enum BaseType {
            Grouping,
            Block,
            Inline;

        }
    }
}

