/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.forms.ShapeSerializer;
import com.inet.pdfc.model.DrawableElementXY;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.ImageMetaData;
import com.inet.pdfc.model.Visitable;
import com.inet.pdfc.model.Visitor;
import com.inet.pdfc.model.i18n.Msg;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class ImageElement
extends DrawableElementXY
implements Visitable {
    private double width;
    private double height;
    private Dimension dataSize;
    private boolean isType3Glyph;
    private Object cacheKey;
    private AffineTransform renderTransform;
    private transient Shape clip;
    private Rectangle2D.Double bounds;
    private boolean yInverted = false;
    private ImageMetaData imageMetaData = new ImageMetaData();

    public ImageElement(Image image, Object cacheKey, AffineTransform bt, Shape clip, int pageIndex, boolean isType3Glyph, ElementID id) {
        super(pageIndex, id);
        this.renderTransform = new AffineTransform(bt);
        this.clip = clip;
        this.isType3Glyph = isType3Glyph;
        this.cacheKey = cacheKey;
        this.dataSize = new Dimension(image.getWidth(null), image.getHeight(null));
        double[] points = new double[]{0.0, 0.0, 1.0, 1.0};
        this.renderTransform.transform(points, 0, points, 0, 2);
        Rectangle2D.Double dimension = new Rectangle2D.Double(points[0], points[3], points[2] - points[0], points[1] - points[3]);
        double tmpX = dimension.getX();
        double tmpY = dimension.getY();
        double tmpWidth = dimension.getWidth();
        double tmpHeight = dimension.getHeight();
        if (tmpWidth < 0.0) {
            tmpX += tmpWidth;
            tmpWidth = -tmpWidth;
        }
        if (tmpHeight < 0.0) {
            tmpY += tmpHeight;
            tmpHeight = -tmpHeight;
        }
        this.setX(tmpX);
        this.setY(tmpY);
        this.width = tmpWidth;
        this.height = tmpHeight;
    }

    public boolean isyInverted() {
        return this.yInverted;
    }

    public void setyInverted(boolean yInverted) {
        this.yInverted = yInverted;
    }

    public Shape getRenderClip() {
        return this.clip;
    }

    public void setRenderClip(Shape clip) {
        this.clip = clip;
    }

    public void setImageMetaData(@Nonnull ImageMetaData imageMetaData) {
        this.imageMetaData = imageMetaData;
    }

    @Nonnull
    public ImageMetaData getImageMetaData() {
        return this.imageMetaData;
    }

    public AffineTransform getRenderTransform() {
        return this.renderTransform;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Dimension getDataSize() {
        return this.dataSize;
    }

    public Object getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle clip;
        if (this.bounds != null) {
            return this.bounds;
        }
        this.bounds = new Rectangle2D.Double(this.getX(), this.getY(), this.width, this.height);
        if (this.clip != null && !(clip = this.clip.getBounds()).contains(this.bounds)) {
            Rectangle2D.intersect(clip, this.bounds, this.bounds);
        }
        return this.bounds;
    }

    @Override
    public int getCompareHash() {
        return 2;
    }

    @Override
    public ElementType getType() {
        return ElementType.Image;
    }

    public boolean isType3Glyph() {
        return this.isType3Glyph;
    }

    void setWidth(double width) {
        this.width = width;
    }

    void setHeight(double height) {
        this.height = height;
    }

    @Override
    public double getRotation() {
        AffineTransform t = this.renderTransform;
        if (t.getShearX() == -t.getShearY() && Math.abs(t.getScaleX()) == Math.abs(t.getScaleY())) {
            if (t.getShearX() == 0.0 && t.getScaleX() > 0.0) {
                return 0.0;
            }
            return Math.atan2(t.getShearY(), t.getScaleX());
        }
        double[] m = new double[4];
        t.getMatrix(m);
        t = new AffineTransform(m);
        Point2D.Double p = new Point2D.Double(1.0, 0.0);
        t.transform(p, p);
        return Math.atan2(p.getY(), p.getX());
    }

    @Override
    public String getLabel() {
        Rectangle2D bounds = this.getBounds();
        String width = Long.toString(Math.round(bounds.getWidth()));
        String height = Long.toString(Math.round(bounds.getHeight()));
        return Msg.getMsg("ElementType." + String.valueOf(this.getType()), width, height);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "Image " + (int)this.getWidth() + "x" + (int)this.getHeight() + " at " + (int)this.getX() + ":" + (int)this.getY();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ShapeSerializer.writeShape(this.clip, out);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.clip = ShapeSerializer.readShape(in);
    }
}

