/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import java.io.Serializable;

@InternalApi
public enum ElementType implements Serializable
{
    Text(false),
    Shape(false),
    Image(false),
    ImagePart(false),
    TextWord(false),
    Curve(false),
    Line(false),
    LineHorizontal(false),
    LineVertical(false),
    ControlText(false),
    ControlCheckBox(false),
    ControlSignature(false),
    Annotation(false),
    TextLine(true),
    Paragraph(true),
    Table(true),
    TableRow(true, false),
    TableColumn(true, false),
    TableCell(true, false),
    Header(true),
    Footer(true),
    Page(true),
    SplittedWord(true),
    LayoutGroup(true),
    LayoutElement(true),
    Unknown(true),
    ControlList(false),
    Chart(true),
    Block(true),
    TextInfo(false),
    Language(false),
    InternalMarkup(false),
    Tag(false);

    private final boolean isStructuralType;
    private final boolean removeIfEmpty;

    private ElementType(boolean isStructuralType) {
        this(isStructuralType, true);
    }

    private ElementType(boolean isStructuralType, boolean removeIfEmpty) {
        this.isStructuralType = isStructuralType;
        this.removeIfEmpty = removeIfEmpty;
    }

    public boolean isStructuralType() {
        return this.isStructuralType;
    }

    public boolean isRemoveIfEmpty() {
        return this.removeIfEmpty;
    }

    public ElementType getBaseType() {
        switch (this) {
            case Text: 
            case TextWord: {
                return Text;
            }
            case Line: 
            case LineHorizontal: 
            case LineVertical: {
                return Line;
            }
        }
        return this;
    }
}

