/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.junit;

import com.inet.annotations.PublicApi;
import com.inet.pdfc.remote.client.PdfcServerInfo;
import com.inet.pdfc.remote.client.RPCClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Properties;
import javax.annotation.SuppressFBWarnings;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;

@PublicApi
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="client site code, library user must check")
public class PdfcAssert {
    private static Properties configuration;
    private static String configurationName;
    private static PdfcServerInfo server;

    public static void setPdfcConfiguration(String configName) throws IOException {
        if (configName == null) {
            configuration = null;
        } else {
            try (FileInputStream fileInputStream = new FileInputStream(configName);){
                Properties props = new Properties();
                props.loadFromXML(fileInputStream);
                String val = props.getProperty("LOG_LEVEL");
                if (val != null) {
                    if ("OFF".equals(val)) {
                        val = "STATUS";
                    }
                    if ("ALL".equals(val)) {
                        val = "DEBUG";
                    }
                    props.setProperty("LOG_LEVEL", val);
                }
                configuration = props;
            }
        }
        configurationName = null;
    }

    public static void setPdfcConfigurationWithName(String nameOrID) {
        configurationName = nameOrID;
        configuration = null;
    }

    public static void setPdfcConfiguration(Properties settings) {
        configuration = settings;
    }

    public static void setServicePath(String servicePath) {
        server.setServicePath(servicePath);
    }

    public static void setLogLevel(int level) {
        RPCClient.getLogger().setLogLevel(level);
    }

    public static void setCredentials(String user, String password) {
        server.setCredentials(user, password);
    }

    private static void testEquality(String message, RPCClient.PdfData expected, RPCClient.PdfData actual, boolean expectEquality) {
        if (expected == null) {
            PdfcAssert.fail("The 'expected' file is not set.");
        }
        if (actual == null) {
            PdfcAssert.fail("The 'actual' file is not set.");
        }
        try (RPCClient client = new RPCClient();){
            client.setServerInfo(server);
            if (configuration != null) {
                client.setConfiguration(configuration);
            } else {
                client.setConfigName(configurationName);
            }
            client.setActual(actual);
            client.setExpected(expected);
            try {
                int diffCount = client.runComparison();
                Throwable error = client.getError();
                if (diffCount < 0 && error != null) {
                    throw new AssertionError((Object)error);
                }
                if (expectEquality) {
                    PdfcAssert.assertEquals(message, 0L, diffCount);
                } else {
                    PdfcAssert.assertNotEquals(message, 0L, diffCount);
                }
            }
            catch (IOException ex) {
                client.cancel();
                throw ex;
            }
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private static void fail(String failMessage) {
        if (PdfcAssert.isJUnit4()) {
            PdfcAssert.fail4(failMessage);
        } else {
            PdfcAssert.fail5(failMessage);
        }
    }

    private static void fail4(String failMessage) {
        Assert.fail((String)failMessage);
    }

    private static void fail5(String failMessage) {
        Assertions.fail((String)failMessage);
    }

    private static void assertEquals(String failMessage, long expected, long actual) {
        if (PdfcAssert.isJUnit4()) {
            PdfcAssert.assertEquals4(failMessage, expected, actual);
        } else {
            PdfcAssert.assertEquals5(failMessage, expected, actual);
        }
    }

    private static void assertEquals4(String failMessage, long expected, long actual) {
        Assert.assertEquals((String)failMessage, (long)expected, (long)actual);
    }

    private static void assertEquals5(String failMessage, long expected, long actual) {
        Assertions.assertEquals((long)expected, (long)actual, (String)failMessage);
    }

    private static void assertNotEquals(String failMessage, long unexpected, long actual) {
        if (PdfcAssert.isJUnit4()) {
            PdfcAssert.assertNotEquals4(failMessage, unexpected, actual);
        } else {
            PdfcAssert.assertNotEquals5(failMessage, unexpected, actual);
        }
    }

    private static void assertNotEquals4(String failMessage, long unexpected, long actual) {
        Assert.assertNotEquals((String)failMessage, (long)unexpected, (long)actual);
    }

    private static void assertNotEquals5(String failMessage, long unexpected, long actual) {
        Assertions.assertNotEquals((long)unexpected, (long)actual, (String)failMessage);
    }

    private static boolean isJUnit4() {
        try {
            return PdfcAssert.class.getClassLoader().loadClass("org.junit.Assert") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void assertPdfEquals(File expected, File actual) {
        PdfcAssert.assertPdfEquals(null, expected, actual);
    }

    public static void assertPdfEquals(String message, File expected, File actual) {
        PdfcAssert.testEquality(message, new RPCClient.PdfData(expected), new RPCClient.PdfData(actual), true);
    }

    public static void assertPdfEquals(String expected, String actual) {
        PdfcAssert.assertPdfEquals(null, expected, actual);
    }

    public static void assertPdfEquals(String message, String expected, String actual) {
        PdfcAssert.assertPdfEquals(message, new File(expected), new File(actual));
    }

    public static void assertPdfEquals(Path expected, Path actual) {
        PdfcAssert.assertPdfEquals(null, expected, actual);
    }

    public static void assertPdfEquals(String message, Path expected, Path actual) {
        PdfcAssert.assertPdfEquals(message, expected.toFile(), actual.toFile());
    }

    public static void assertPdfEquals(URL expected, URL actual) {
        PdfcAssert.assertPdfEquals(null, expected, actual);
    }

    public static void assertPdfEquals(String message, InputStream expected, InputStream actual) {
        String baseName = PdfcAssert.getBaseName();
        PdfcAssert.testEquality(message, new RPCClient.PdfData(baseName + "expected", expected), new RPCClient.PdfData(baseName + "actual", actual), true);
    }

    private static String getBaseName() {
        StackTraceElement[] stack;
        for (StackTraceElement el : stack = new Exception().getStackTrace()) {
            String shortName;
            String className = el.getClassName();
            if (PdfcAssert.class.getName().equals(className)) continue;
            if (className.contains(".") && (shortName = className.substring(className.lastIndexOf(46))).length() > 3) {
                return shortName + "-";
            }
            return className + "-";
        }
        return "";
    }

    public static void assertPdfEquals(InputStream expected, InputStream actual) {
        PdfcAssert.assertPdfEquals(null, expected, actual);
    }

    public static void assertPdfEquals(String message, URL expected, URL actual) {
        PdfcAssert.testEquality(message, new RPCClient.PdfData(expected), new RPCClient.PdfData(actual), true);
    }

    public static void assertPdfNotEquals(File expected, File actual) {
        PdfcAssert.assertPdfNotEquals(null, expected, actual);
    }

    public static void assertPdfNotEquals(String message, File expected, File actual) {
        PdfcAssert.testEquality(message, new RPCClient.PdfData(expected), new RPCClient.PdfData(actual), false);
    }

    public static void assertPdfNotEquals(String expected, String actual) {
        PdfcAssert.assertPdfNotEquals(new File(expected), new File(actual));
    }

    public static void assertPdfNotEquals(String message, String expected, String actual) {
        PdfcAssert.assertPdfNotEquals(message, new File(expected), new File(actual));
    }

    public static void assertPdfNotEquals(Path expected, Path actual) {
        PdfcAssert.assertPdfNotEquals(expected.toFile(), actual.toFile());
    }

    public static void assertPdfNotEquals(String message, Path expected, Path actual) {
        PdfcAssert.assertPdfNotEquals(message, expected.toFile(), actual.toFile());
    }

    public static void assertPdfNotEquals(String message, InputStream expected, InputStream actual) {
        String baseName = PdfcAssert.getBaseName();
        PdfcAssert.testEquality(message, new RPCClient.PdfData(baseName + "expected", expected), new RPCClient.PdfData(baseName + "actual", actual), false);
    }

    static {
        server = new PdfcServerInfo();
    }
}

