/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.samples.steps;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKeyParser;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.ResourceFile;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupLogger;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepConfiguration;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepKey;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;

public class a
extends AutoSetupStep {
    public static final SetupStepPriority c = new SetupStepPriority(4000);
    public static final StepKey d = new StepKey("sampleDriveReports");
    private static final I18nMessages MSG = new I18nMessages("com.inet.report.samples.steps.i18n.SetupSteps", a.class);

    public StepKey stepKey() {
        return d;
    }

    public boolean hasPendingTasks() {
        if (!ConfigKeyParser.hasValidLicenseFor((String)"drive")) {
            return false;
        }
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            DriveEntry driveEntry = this.c();
            boolean bl = driveEntry == null || !driveEntry.exists();
            return bl;
        }
    }

    public void a(EmptyStepConfig emptyStepConfig, Map<String, String> map) throws StepExecutionException {
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            DriveEntry driveEntry = this.c();
            if (driveEntry != null && driveEntry.exists()) {
                SetupLogger.LOGGER.info((Object)"[SampleReports] Drive entry for sample reports already exists - not adding or updating any sample reports.");
                return;
            }
            ResourceFile resourceFile = null;
            try {
                resourceFile = ServerPluginManager.getInstance().getPluginFile("samplereports", "samplereports.zip");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (resourceFile == null) {
                SetupLogger.LOGGER.error((Object)"[SampleReports] Source of Sample Resports not found in plugin - not adding or updating any sample reports.");
                return;
            }
            driveEntry = this.d();
            this.a(resourceFile, driveEntry);
        }
        catch (DriveOperationConflictException driveOperationConflictException) {
            SetupLogger.LOGGER.error("[SampleReports] An exception occured during drive location creation. ", (Throwable)driveOperationConflictException);
            return;
        }
    }

    @Nullable
    private DriveEntry c() {
        return Drive.getInstance().resolve("/samplereports");
    }

    @Nullable
    private DriveEntry d() throws DriveOperationConflictException {
        return Drive.getInstance().createFolder("", "samplereports");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ResourceFile resourceFile, DriveEntry driveEntry) throws StepExecutionException, DriveOperationConflictException {
        try {
            SetupLogger.LOGGER.info((Object)("[SampleReports] Copy sample reports to directory: " + String.valueOf(driveEntry)));
            try (ZipInputStream zipInputStream = new ZipInputStream(resourceFile.getInputStream());){
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    Path path = Path.of(driveEntry.getPath(), zipEntry.getName());
                    if (zipEntry.isDirectory()) continue;
                    Drive.getInstance().createOrReplace(path, (InputStream)new FilterInputStream(zipInputStream){

                        @Override
                        public void close() throws IOException {
                        }
                    });
                }
            }
        }
        catch (IOException iOException) {
            driveEntry.delete(null);
            throw new StepExecutionException((Throwable)iOException);
        }
    }

    public SetupStepPriority getPriority() {
        return c;
    }

    public String getStepDisplayName() {
        return MSG.getMsg("sampleDrive.displayName", new Object[0]);
    }

    public InfoMessageGetter a(EmptyStepConfig emptyStepConfig) {
        return () -> MSG.getMsg("sampleDrive.executionMessage", new Object[0]);
    }

    public /* synthetic */ InfoMessageGetter getExecutionInfoMessage(StepConfiguration stepConfiguration) {
        return this.a((EmptyStepConfig)stepConfiguration);
    }

    public /* synthetic */ void execute(StepConfiguration stepConfiguration, Map map) throws StepExecutionException {
        this.a((EmptyStepConfig)stepConfiguration, map);
    }
}

