/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database.language;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class Language {
    public static final String CUSTOM_MESSAGE = "SS-0000";
    public static final String UNSUPPORTED_OPERATION = "SS-0001";
    public static final String CANT_LOCK_FILE = "SS-0003";
    public static final String DB_EXISTENT = "SS-0030";
    public static final String DB_NONEXISTENT = "SS-0031";
    public static final String DB_NOT_DIRECTORY = "SS-0032";
    public static final String DB_NOTCONNECTED = "SS-0033";
    public static final String DB_READONLY = "SS-0034";
    public static final String CONNECTION_CLOSED = "SS-0070";
    public static final String VIEW_INSERT = "SS-0100";
    public static final String VIEWDROP_NOT_VIEW = "SS-0101";
    public static final String VIEW_CANTDROP = "SS-0102";
    public static final String RSET_NOT_PRODUCED = "SS-0130";
    public static final String RSET_READONLY = "SS-0131";
    public static final String RSET_FWDONLY = "SS-0132";
    public static final String RSET_CLOSED = "SS-0133";
    public static final String RSET_NOT_INSERT_ROW = "SS-0134";
    public static final String RSET_ON_INSERT_ROW = "SS-0135";
    public static final String ROWSOURCE_READONLY = "SS-0136";
    public static final String STMT_IS_CLOSED = "SS-0140";
    public static final String SUBQUERY_COL_COUNT = "SS-0160";
    public static final String JOIN_DELETE = "SS-0161";
    public static final String JOIN_INSERT = "SS-0162";
    public static final String DELETE_WO_FROM = "SS-0163";
    public static final String INSERT_WO_FROM = "SS-0164";
    public static final String TABLE_CANT_RENAME = "SS-0190";
    public static final String TABLE_CANT_DROP = "SS-0191";
    public static final String TABLE_CANT_DROP_LOCKED = "SS-0192";
    public static final String TABLE_CORRUPT_PAGE = "SS-0193";
    public static final String TABLE_MODIFIED = "SS-0194";
    public static final String TABLE_DEADLOCK = "SS-0195";
    public static final String TABLE_OR_VIEW_MISSING = "SS-0196";
    public static final String TABLE_FILE_INVALID = "SS-0197";
    public static final String TABLE_OR_VIEW_FILE_INVALID = "SS-0198";
    public static final String TABLE_EXISTENT = "SS-0199";
    public static final String FK_NOT_TABLE = "SS-0220";
    public static final String PK_ONLYONE = "SS-0221";
    public static final String KEY_DUPLICATE = "SS-0222";
    public static final String MONTH_TOOLARGE = "SS-0251";
    public static final String DAYS_TOOLARGE = "SS-0252";
    public static final String HOURS_TOOLARGE = "SS-0253";
    public static final String MINUTES_TOOLARGE = "SS-0254";
    public static final String SECS_TOOLARGE = "SS-0255";
    public static final String MILLIS_TOOLARGE = "SS-0256";
    public static final String DATETIME_INVALID = "SS-0257";
    public static final String UNSUPPORTED_CONVERSION_OPER = "SS-0280";
    public static final String UNSUPPORTED_DATATYPE_OPER = "SS-0281";
    public static final String UNSUPPORTED_DATATYPE_FUNC = "SS-0282";
    public static final String UNSUPPORTED_CONVERSION_FUNC = "SS-0283";
    public static final String UNSUPPORTED_TYPE_CONV = "SS-0284";
    public static final String UNSUPPORTED_TYPE_SUM = "SS-0285";
    public static final String UNSUPPORTED_TYPE_MAX = "SS-0286";
    public static final String UNSUPPORTED_CONVERSION = "SS-0287";
    public static final String INSERT_INVALID_LEN = "SS-0288";
    public static final String SUBSTR_INVALID_LEN = "SS-0289";
    public static final String VALUE_STR_TOOLARGE = "SS-0310";
    public static final String VALUE_BIN_TOOLARGE = "SS-0311";
    public static final String VALUE_NULL_INVALID = "SS-0312";
    public static final String VALUE_CANT_CONVERT = "SS-0313";
    public static final String BYTEARR_INVALID_SIZE = "SS-0340";
    public static final String LOB_DELETED = "SS-0341";
    public static final String PARAM_CLASS_UNKNOWN = "SS-0370";
    public static final String PARAM_EMPTY = "SS-0371";
    public static final String PARAM_IDX_OUT_RANGE = "SS-0372";
    public static final String COL_DUPLICATE = "SS-0400";
    public static final String COL_MISSING = "SS-0401";
    public static final String COL_VAL_UNMATCH = "SS-0402";
    public static final String COL_INVALID_SIZE = "SS-0403";
    public static final String COL_WRONG_PREFIX = "SS-0404";
    public static final String COL_READONLY = "SS-0405";
    public static final String COL_INVALID_NAME = "SS-0406";
    public static final String COL_IDX_OUT_RANGE = "SS-0407";
    public static final String COL_AMBIGUOUS = "SS-0408";
    public static final String GROUP_AGGR_INVALID = "SS-0430";
    public static final String GROUP_AGGR_NOTPART = "SS-0431";
    public static final String ORDERBY_INTERNAL = "SS-0432";
    public static final String UNION_DIFFERENT_COLS = "SS-0433";
    public static final String INDEX_EXISTS = "SS-0460";
    public static final String INDEX_MISSING = "SS-0461";
    public static final String INDEX_FILE_INVALID = "SS-0462";
    public static final String INDEX_CORRUPT = "SS-0463";
    public static final String INDEX_TOOMANY_EQUALS = "SS-0464";
    public static final String FILE_TOONEW = "SS-0490";
    public static final String FILE_TOOOLD = "SS-0491";
    public static final String FILE_CANT_DELETE = "SS-0492";
    public static final String ROW_0_ABSOLUTE = "SS-0520";
    public static final String ROW_NOCURRENT = "SS-0521";
    public static final String ROWS_WRONG_MAX = "SS-0522";
    public static final String ROW_LOCKED = "SS-0523";
    public static final String ROW_DELETED = "SS-0524";
    public static final String SAVEPT_INVALID_TRANS = "SS-0550";
    public static final String SAVEPT_INVALID_DRIVER = "SS-0551";
    public static final String ALIAS_UNSUPPORTED = "SS-0580";
    public static final String ISOLATION_UNKNOWN = "SS-0581";
    public static final String FLAGVALUE_INVALID = "SS-0582";
    public static final String ARGUMENT_INVALID = "SS-0583";
    public static final String GENER_KEYS_UNREQUIRED = "SS-0584";
    public static final String SEQUENCE_HEX_INVALID = "SS-0585";
    public static final String SEQUENCE_HEX_INVALID_STR = "SS-0586";
    public static final String SYNTAX_BASE_OFS = "SS-0610";
    public static final String SYNTAX_BASE_END = "SS-0611";
    public static final String STXADD_ADDITIONAL_TOK = "SS-0612";
    public static final String STXADD_IDENT_EXPECT = "SS-0613";
    public static final String STXADD_IDENT_EMPTY = "SS-0614";
    public static final String STXADD_IDENT_WRONG = "SS-0615";
    public static final String STXADD_OPER_MINUS = "SS-0616";
    public static final String STXADD_FUNC_UNKNOWN = "SS-0617";
    public static final String STXADD_PARAM_INVALID_COUNT = "SS-0618";
    public static final String STXADD_JOIN_INVALID = "SS-0619";
    public static final String STXADD_FROM_PAR_CLOSE = "SS-0620";
    public static final String STXADD_KEYS_REQUIRED = "SS-0621";
    public static final String STXADD_NOT_NUMBER = "SS-0622";
    public static final String STXADD_COMMENT_OPEN = "SS-0623";
    private Map messages;
    private Map sqlStates;
    private final String[][] MESSAGES = new String[][]{{"SS-0000", "{0}"}, {"SS-0001", "Unsupported Operation {0}."}, {"SS-0003", "Can''t lock file ''{0}''. A single SmallSQL Database can only be opened from a single process."}, {"SS-0030", "Database ''{0}'' already exists."}, {"SS-0031", "Database ''{0}'' does not exist."}, {"SS-0032", "Directory ''{0}'' is not a SmallSQL database."}, {"SS-0033", "You are not connected with a Database."}, {"SS-0070", "Connection is already closed."}, {"SS-0100", "INSERT is not supported for a view."}, {"SS-0101", "Cannot use DROP VIEW with ''{0}'' because it does not is a view."}, {"SS-0102", "View ''{0}'' can''t be dropped."}, {"SS-0130", "No ResultSet was produced."}, {"SS-0131", "ResultSet is read only."}, {"SS-0132", "ResultSet is forward only."}, {"SS-0133", "ResultSet is closed."}, {"SS-0134", "Cursor is currently not on the insert row."}, {"SS-0135", "Cursor is currently on the insert row."}, {"SS-0136", "Rowsource is read only."}, {"SS-0140", "Statement is already closed."}, {"SS-0160", "Count of columns in subquery must be 1 and not {0}."}, {"SS-0161", "The method deleteRow not supported on joins."}, {"SS-0162", "The method insertRow not supported on joins."}, {"SS-0163", "The method deleteRow need a FROM expression."}, {"SS-0164", "The method insertRow need a FROM expression."}, {"SS-0190", "Table ''{0}'' can''t be renamed."}, {"SS-0191", "Table ''{0}'' can''t be dropped."}, {"SS-0192", "Table ''{0}'' can''t drop because is locked."}, {"SS-0193", "Corrupt table page at position: {0}."}, {"SS-0194", "Table ''{0}'' was modified."}, {"SS-0195", "Deadlock, can not create a lock on table ''{0}''."}, {"SS-0196", "Table or View ''{0}'' does not exist."}, {"SS-0197", "File ''{0}'' does not include a valid SmallSQL Table."}, {"SS-0198", "File ''{0}'' is not a valid Table or View store."}, {"SS-0199", "Table or View ''{0}'' already exists."}, {"SS-0220", "''{0}'' is not a table."}, {"SS-0221", "A table can have only one primary key."}, {"SS-0222", "Duplicate Key."}, {"SS-0251", "Months are too large in DATE or TIMESTAMP value ''{0}''."}, {"SS-0252", "Days are too large in DATE or TIMESTAMP value ''{0}''."}, {"SS-0253", "Hours are too large in TIME or TIMESTAMP value ''{0}''."}, {"SS-0254", "Minutes are too large in TIME or TIMESTAMP value ''{0}''."}, {"SS-0255", "Seconds are too large in TIME or TIMESTAMP value ''{0}''."}, {"SS-0256", "Milliseconds are too large in TIMESTAMP value ''{0}''."}, {"SS-0257", "''{0}'' is an invalid DATE, TIME or TIMESTAMP."}, {"SS-0280", "Unsupported conversion to data type ''{0}'' from data type ''{1}'' for operation ''{2}''."}, {"SS-0281", "Unsupported data type ''{0}'' for operation ''{1}''."}, {"SS-0282", "Unsupported data type ''{0}'' for function ''{1}''."}, {"SS-0283", "Unsupported conversion to data type ''{0}'' for function ''{1}''."}, {"SS-0284", "Unsupported type for CONVERT function: {0}."}, {"SS-0285", "Unsupported data type ''{0}'' for SUM function."}, {"SS-0286", "Unsupported data type ''{0}'' for MAX function."}, {"SS-0287", "Can''t convert ''{0}'' [{1}] to ''{2}''."}, {"SS-0288", "Invalid length ''{0}'' in function INSERT."}, {"SS-0289", "Invalid length ''{0}'' in function SUBSTRING."}, {"SS-0310", "String value too large for column."}, {"SS-0311", "Binary value with length {0} to large for column with size {1}."}, {"SS-0312", "Null values are not valid for column ''{0}''."}, {"SS-0313", "Cannot convert a {0} value to a {1} value."}, {"SS-0340", "Invalid byte array size {0} for UNIQUEIDENFIER."}, {"SS-0341", "Lob Object was deleted."}, {"SS-0370", "Unknown parameter class: ''{0}''."}, {"SS-0371", "Parameter {0} is empty."}, {"SS-0372", "Parameter index {0} out of range. The value must be between 1 and {1}."}, {"SS-0400", "There is a duplicated column name: ''{0}''."}, {"SS-0401", "Column ''{0}'' not found."}, {"SS-0402", "Columns and Values count is not identical."}, {"SS-0403", "Invalid column size {0} for column ''{1}''."}, {"SS-0404", "The column prefix ''{0}'' does not match with a table name or alias name used in this query."}, {"SS-0405", "Column {0} is read only."}, {"SS-0406", "Invalid column name ''{0}''."}, {"SS-0407", "Column index out of range: {0}."}, {"SS-0408", "Column ''{0}'' is ambiguous."}, {"SS-0430", "Aggregate function are not valid in the GROUP BY clause ({0})."}, {"SS-0431", "Expression ''{0}'' is not part of a aggregate function or GROUP BY clause."}, {"SS-0432", "Internal Error with ORDER BY."}, {"SS-0433", "Different SELECT of the UNION have different column count: {0} and {1}."}, {"SS-0460", "Index ''{0}'' already exists."}, {"SS-0461", "Index ''{0}'' does not exist."}, {"SS-0462", "File ''{0}'' is not a valid Index store."}, {"SS-0463", "Error in loading Index. Index file is corrupt. ({0})."}, {"SS-0464", "Too many equals entry in Index."}, {"SS-0490", "File version ({0}) of file ''{1}'' is too new for this runtime."}, {"SS-0491", "File version ({0}) of file ''{1}'' is too old for this runtime."}, {"SS-0492", "File ''{0}'' can't be deleted."}, {"SS-0520", "Row 0 is invalid for method absolute()."}, {"SS-0521", "No current row."}, {"SS-0522", "Wrong max rows value: {0}."}, {"SS-0523", "Row is locked from another Connection."}, {"SS-0524", "Row already deleted."}, {"SS-0550", "Savepoint is not valid for this transaction."}, {"SS-0551", "Savepoint is not valid for this driver {0}."}, {"SS-0580", "Alias not supported for this type of row source."}, {"SS-0581", "Unknown Transaction Isolation Level: {0}."}, {"SS-0582", "Invalid flag value in method getMoreResults: {0}."}, {"SS-0583", "Invalid argument in method setNeedGenratedKeys: {0}."}, {"SS-0584", "GeneratedKeys not requested."}, {"SS-0585", "Invalid hex sequence at {0}."}, {"SS-0586", "Invalid hex sequence at position {0} in ''{1}''."}, {"SS-0610", "Syntax error at offset {0} on ''{1}''. "}, {"SS-0611", "Syntax error, unexpected end of SQL string. "}, {"SS-0612", "Additional token after end of SQL statement."}, {"SS-0613", "Identifier expected."}, {"SS-0614", "Empty Identifier."}, {"SS-0615", "Wrong Identifier ''{0}''."}, {"SS-0616", "Invalid operator minus for data type VARBINARY."}, {"SS-0617", "Unknown function."}, {"SS-0618", "Invalid parameter count."}, {"SS-0619", "Invalid Join Syntax."}, {"SS-0620", "Unexpected closing parenthesis in FROM clause."}, {"SS-0621", "Required keywords are: "}, {"SS-0622", "Number value required (passed = ''{0}'')."}, {"SS-0623", "Missing end comment mark (''*/'')."}};
    private final String[][] SQL_STATES = new String[][]{{"SS-0000", "01000"}, {"SS-0001", "01000"}, {"SS-0003", "01000"}, {"SS-0030", "01000"}, {"SS-0031", "01000"}, {"SS-0032", "01000"}, {"SS-0033", "01000"}, {"SS-0070", "01000"}, {"SS-0100", "01000"}, {"SS-0101", "01000"}, {"SS-0102", "01000"}, {"SS-0130", "01000"}, {"SS-0131", "01000"}, {"SS-0132", "01000"}, {"SS-0133", "01000"}, {"SS-0134", "01000"}, {"SS-0135", "01000"}, {"SS-0136", "01000"}, {"SS-0140", "HY010"}, {"SS-0160", "01000"}, {"SS-0161", "01000"}, {"SS-0162", "01000"}, {"SS-0163", "01000"}, {"SS-0164", "01000"}, {"SS-0190", "01000"}, {"SS-0191", "01000"}, {"SS-0192", "01000"}, {"SS-0193", "01000"}, {"SS-0194", "01000"}, {"SS-0195", "01000"}, {"SS-0196", "01000"}, {"SS-0197", "01000"}, {"SS-0198", "01000"}, {"SS-0199", "01000"}, {"SS-0220", "01000"}, {"SS-0221", "01000"}, {"SS-0222", "01000"}, {"SS-0251", "01000"}, {"SS-0252", "01000"}, {"SS-0253", "01000"}, {"SS-0254", "01000"}, {"SS-0255", "01000"}, {"SS-0256", "01000"}, {"SS-0257", "01000"}, {"SS-0280", "01000"}, {"SS-0281", "01000"}, {"SS-0282", "01000"}, {"SS-0283", "01000"}, {"SS-0284", "01000"}, {"SS-0285", "01000"}, {"SS-0286", "01000"}, {"SS-0287", "01000"}, {"SS-0288", "01000"}, {"SS-0289", "01000"}, {"SS-0310", "01000"}, {"SS-0311", "01000"}, {"SS-0312", "01000"}, {"SS-0313", "01000"}, {"SS-0340", "01000"}, {"SS-0341", "01000"}, {"SS-0370", "01000"}, {"SS-0371", "01000"}, {"SS-0372", "01000"}, {"SS-0400", "01000"}, {"SS-0401", "01000"}, {"SS-0402", "01000"}, {"SS-0403", "01000"}, {"SS-0404", "01000"}, {"SS-0405", "01000"}, {"SS-0406", "01000"}, {"SS-0407", "01000"}, {"SS-0408", "01000"}, {"SS-0430", "01000"}, {"SS-0431", "01000"}, {"SS-0432", "01000"}, {"SS-0433", "01000"}, {"SS-0460", "01000"}, {"SS-0461", "01000"}, {"SS-0462", "01000"}, {"SS-0463", "01000"}, {"SS-0464", "01000"}, {"SS-0490", "01000"}, {"SS-0491", "01000"}, {"SS-0492", "01000"}, {"SS-0520", "01000"}, {"SS-0521", "01000"}, {"SS-0522", "01000"}, {"SS-0523", "01000"}, {"SS-0524", "01000"}, {"SS-0550", "01000"}, {"SS-0551", "01000"}, {"SS-0580", "01000"}, {"SS-0581", "01000"}, {"SS-0582", "01000"}, {"SS-0583", "01000"}, {"SS-0584", "01000"}, {"SS-0585", "01000"}, {"SS-0586", "01000"}, {"SS-0610", "01000"}, {"SS-0611", "01000"}, {"SS-0612", "01000"}, {"SS-0613", "01000"}, {"SS-0614", "01000"}, {"SS-0615", "01000"}, {"SS-0616", "01000"}, {"SS-0617", "01000"}, {"SS-0618", "01000"}, {"SS-0619", "01000"}, {"SS-0620", "01000"}, {"SS-0621", "01000"}, {"SS-0622", "01000"}, {"SS-0623", "01000"}};

    public static Language getLanguage(String string) {
        try {
            return Language.getFromLocaleTree(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Language.getDefaultLanguage();
        }
    }

    public static Language getDefaultLanguage() {
        String string = Locale.getDefault().toString();
        try {
            return Language.getFromLocaleTree(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new Language();
        }
    }

    private static Language getFromLocaleTree(String string) throws IllegalArgumentException {
        String string2 = string;
        while (true) {
            block6: {
                String string3 = Language.class.getName() + '_' + string2;
                try {
                    return (Language)Class.forName(string3).newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    assert (false) : "Internal error: must never happen.";
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)("Error during Language instantiation: " + instantiationException.getMessage()));
                }
            }
            int n = string2.lastIndexOf("_");
            if (n <= -1) break;
            string2 = string2.substring(0, n);
        }
        throw new IllegalArgumentException("Locale not found in the tree: " + string);
    }

    protected Language() {
        this.messages = new HashMap((int)((double)this.MESSAGES.length / 0.7));
        this.sqlStates = new HashMap((int)((double)this.MESSAGES.length / 0.7));
        this.addMessages(this.MESSAGES);
        this.setSqlStates();
    }

    protected final void addMessages(String[][] stringArray) throws IllegalArgumentException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i][0];
            if (!hashSet.add(string)) {
                throw new IllegalArgumentException("Duplicate key: " + string);
            }
            String string2 = stringArray[i][1];
            this.messages.put(string, string2);
        }
    }

    private final void setSqlStates() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.SQL_STATES.length; ++i) {
            String string = this.SQL_STATES[i][0];
            if (!hashSet.add(string)) {
                throw new IllegalArgumentException("Duplicate key: " + string);
            }
            String string2 = this.SQL_STATES[i][1];
            this.sqlStates.put(string, string2);
        }
    }

    public String getMessage(String string) {
        String string2 = (String)this.messages.get(string);
        assert (string2 != null) : "Message code not found: " + string;
        return string2;
    }

    public String getSqlState(String string) {
        String string2 = (String)this.sqlStates.get(string);
        assert (string2 != null) : "SQL State code not found: " + string;
        return string2;
    }

    public String[][] getEntries() {
        return this.MESSAGES;
    }
}

