/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.DataSource;
import smallsql.database.DataSources;
import smallsql.database.MutableNumeric;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;
import smallsql.database.TableView;

final class UnionAll
extends DataSource {
    private final DataSources dataSources = new DataSources();
    private int dataSourceIdx;
    private DataSource currentDS;
    private int row;

    UnionAll() {
    }

    void addDataSource(DataSource dataSource) {
        this.dataSources.add(dataSource);
        this.currentDS = this.dataSources.get(0);
    }

    boolean init(SSConnection sSConnection) throws Exception {
        boolean bl = false;
        int n = -1;
        for (int i = 0; i < this.dataSources.size(); ++i) {
            DataSource dataSource = this.dataSources.get(i);
            bl |= dataSource.init(sSConnection);
            int n2 = dataSource.getTableView().columns.size();
            if (n == -1) {
                n = n2;
                continue;
            }
            if (n == n2) continue;
            throw SmallSQLException.create("SS-0433", new Object[]{new Integer(n), new Integer(n2)});
        }
        return bl;
    }

    final boolean isNull(int n) throws Exception {
        return this.currentDS.isNull(n);
    }

    final boolean getBoolean(int n) throws Exception {
        return this.currentDS.getBoolean(n);
    }

    final int getInt(int n) throws Exception {
        return this.currentDS.getInt(n);
    }

    final long getLong(int n) throws Exception {
        return this.currentDS.getLong(n);
    }

    final float getFloat(int n) throws Exception {
        return this.currentDS.getFloat(n);
    }

    final double getDouble(int n) throws Exception {
        return this.currentDS.getDouble(n);
    }

    final long getMoney(int n) throws Exception {
        return this.currentDS.getMoney(n);
    }

    final MutableNumeric getNumeric(int n) throws Exception {
        return this.currentDS.getNumeric(n);
    }

    final Object getObject(int n) throws Exception {
        return this.currentDS.getObject(n);
    }

    final String getString(int n) throws Exception {
        return this.currentDS.getString(n);
    }

    final byte[] getBytes(int n) throws Exception {
        return this.currentDS.getBytes(n);
    }

    final int getDataType(int n) {
        return this.currentDS.getDataType(n);
    }

    TableView getTableView() {
        return this.currentDS.getTableView();
    }

    final boolean isScrollable() {
        return false;
    }

    final void beforeFirst() throws Exception {
        this.dataSourceIdx = 0;
        this.currentDS = this.dataSources.get(0);
        this.currentDS.beforeFirst();
        this.row = 0;
    }

    final boolean first() throws Exception {
        this.dataSourceIdx = 0;
        this.currentDS = this.dataSources.get(0);
        boolean bl = this.currentDS.first();
        this.row = bl ? 1 : 0;
        return bl;
    }

    final boolean next() throws Exception {
        boolean bl = this.currentDS.next();
        ++this.row;
        if (bl) {
            return true;
        }
        while (this.dataSources.size() > this.dataSourceIdx + 1) {
            this.currentDS = this.dataSources.get(++this.dataSourceIdx);
            this.currentDS.beforeFirst();
            bl = this.currentDS.next();
            if (!bl) continue;
            return true;
        }
        this.row = 0;
        return false;
    }

    final void afterLast() throws Exception {
        this.dataSourceIdx = this.dataSources.size() - 1;
        this.currentDS = this.dataSources.get(this.dataSourceIdx);
        this.currentDS.afterLast();
        this.row = 0;
    }

    final int getRow() throws Exception {
        return this.row;
    }

    private final int getBitCount() {
        int n = 0;
        for (int i = this.dataSources.size(); i > 0; i >>= 1) {
            ++n;
        }
        return n;
    }

    final long getRowPosition() {
        int n = this.getBitCount();
        return (long)this.dataSourceIdx | this.currentDS.getRowPosition() << n;
    }

    final void setRowPosition(long l) throws Exception {
        int n = this.getBitCount();
        int n2 = -1 >>> 32 - n;
        this.dataSourceIdx = (int)l & n2;
        this.currentDS = this.dataSources.get(this.dataSourceIdx);
        this.currentDS.setRowPosition(l >> n);
    }

    final boolean rowInserted() {
        return this.currentDS.rowInserted();
    }

    final boolean rowDeleted() {
        return this.currentDS.rowDeleted();
    }

    final void nullRow() {
        this.currentDS.nullRow();
        this.row = 0;
    }

    final void noRow() {
        this.currentDS.noRow();
        this.row = 0;
    }

    final void execute() throws Exception {
        for (int i = 0; i < this.dataSources.size(); ++i) {
            this.dataSources.get(i).execute();
        }
    }
}

