/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.DataSource;
import smallsql.database.Expression;
import smallsql.database.RowSource;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;
import smallsql.database.Table;
import smallsql.database.TableResult;
import smallsql.database.TableView;
import smallsql.database.View;
import smallsql.database.ViewResult;
import smallsql.database.Where;

abstract class TableViewResult
extends DataSource {
    SSConnection con;
    private String alias;
    private long tableTimestamp;
    int lock = 200;

    TableViewResult() {
    }

    static TableViewResult createResult(TableView tableView) {
        if (tableView instanceof Table) {
            return new TableResult((Table)tableView);
        }
        return new ViewResult((View)tableView);
    }

    static TableViewResult getTableViewResult(RowSource rowSource) throws SQLException {
        if (rowSource instanceof Where) {
            rowSource = ((Where)rowSource).getFrom();
        }
        if (rowSource instanceof TableViewResult) {
            return (TableViewResult)rowSource;
        }
        throw SmallSQLException.create("SS-0136");
    }

    void setAlias(String string) {
        this.alias = string;
    }

    String getAlias() {
        return this.alias != null ? this.alias : this.getTableView().name;
    }

    boolean hasAlias() {
        return this.alias != null;
    }

    boolean init(SSConnection sSConnection) throws Exception {
        TableView tableView = this.getTableView();
        if (this.tableTimestamp != tableView.getTimestamp()) {
            this.con = sSConnection;
            this.tableTimestamp = tableView.getTimestamp();
            return true;
        }
        return false;
    }

    abstract void deleteRow() throws SQLException;

    abstract void updateRow(Expression[] var1) throws Exception;

    abstract void insertRow(Expression[] var1) throws Exception;

    final boolean isScrollable() {
        return false;
    }
}

