/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import java.util.List;
import smallsql.database.Column;
import smallsql.database.Columns;
import smallsql.database.Expression;
import smallsql.database.MutableNumeric;
import smallsql.database.SSConnection;
import smallsql.database.Store;
import smallsql.database.StoreImpl;
import smallsql.database.StoreNull;
import smallsql.database.StorePageLink;
import smallsql.database.Table;
import smallsql.database.TableView;
import smallsql.database.TableViewResult;

final class TableResult
extends TableViewResult {
    private final Table table;
    private List insertStorePages;
    private long firstOwnInsert;
    private long maxFileOffset;
    private Store store = Store.NOROW;
    private long filePos;
    private int[] offsets;
    private int[] dataTypes;
    private int row;
    private long afterLastValidFilePos;

    TableResult(Table table) {
        this.table = table;
    }

    final boolean init(SSConnection sSConnection) throws Exception {
        if (super.init(sSConnection)) {
            Columns columns = this.table.columns;
            this.offsets = new int[columns.size()];
            this.dataTypes = new int[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                this.dataTypes[i] = columns.get(i).getDataType();
            }
            return true;
        }
        return false;
    }

    final void execute() throws Exception {
        this.insertStorePages = this.table.getInserts(this.con);
        this.firstOwnInsert = 0x4000000000000000L | (long)this.insertStorePages.size();
        this.maxFileOffset = this.table.raFile.size();
        this.beforeFirst();
    }

    final TableView getTableView() {
        return this.table;
    }

    final void deleteRow() throws SQLException {
        this.store.deleteRow(this.con);
        this.store = new StoreNull(this.store.getNextPagePos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateRow(Expression[] expressionArray) throws Exception {
        Columns columns = this.table.columns;
        int n = columns.size();
        StoreImpl storeImpl = this.table.getStoreTemp(this.con);
        Object object = this.con.getMonitor();
        synchronized (object) {
            ((StoreImpl)this.store).createWriteLock();
            for (int i = 0; i < n; ++i) {
                Expression expression = expressionArray[i];
                if (expression != null) {
                    storeImpl.writeExpression(expression, columns.get(i));
                    continue;
                }
                this.copyValueInto(i, storeImpl);
            }
            ((StoreImpl)this.store).updateFinsh(this.con, storeImpl);
        }
    }

    final void insertRow(Expression[] expressionArray) throws Exception {
        Columns columns = this.table.columns;
        int n = columns.size();
        StoreImpl storeImpl = this.table.getStoreInsert(this.con);
        for (int i = 0; i < n; ++i) {
            Column column = columns.get(i);
            Expression expression = expressionArray[i];
            if (expression == null) {
                expression = column.getDefaultValue(this.con);
            }
            storeImpl.writeExpression(expression, column);
        }
        storeImpl.writeFinsh(this.con);
        this.insertStorePages.add(storeImpl.getLink());
    }

    private final boolean moveToRow() throws Exception {
        if (this.filePos >= 0x4000000000000000L) {
            this.store = ((StorePageLink)this.insertStorePages.get((int)(this.filePos & 0x3FFFFFFFFFFFFFFFL))).getStore(this.table, this.con, this.lock);
        } else {
            Store store = this.store = this.filePos < this.maxFileOffset ? this.table.getStore(this.con, this.filePos, this.lock) : null;
            if (this.store == null && this.insertStorePages.size() > 0) {
                this.filePos = 0x4000000000000000L;
                this.store = ((StorePageLink)this.insertStorePages.get((int)(this.filePos & 0x3FFFFFFFFFFFFFFFL))).getStore(this.table, this.con, this.lock);
            }
        }
        if (this.store != null) {
            if (!this.store.isValidPage()) {
                return false;
            }
            this.store.scanObjectOffsets(this.offsets, this.dataTypes);
            this.afterLastValidFilePos = this.store.getNextPagePos();
            return true;
        }
        this.filePos = -1L;
        this.noRow();
        return false;
    }

    private final boolean moveToValidRow() throws Exception {
        while (this.filePos >= 0L) {
            if (this.moveToRow()) {
                return true;
            }
            this.setNextFilePos();
        }
        this.row = 0;
        return false;
    }

    final void beforeFirst() {
        this.filePos = 0L;
        this.store = Store.NOROW;
        this.row = 0;
    }

    final boolean first() throws Exception {
        this.filePos = this.table.getFirstPage();
        this.row = 1;
        return this.moveToValidRow();
    }

    private final void setNextFilePos() {
        if (this.filePos < 0L) {
            return;
        }
        if (this.store == Store.NOROW) {
            this.filePos = this.table.getFirstPage();
        } else if (this.filePos >= 0x4000000000000000L) {
            ++this.filePos;
            if ((this.filePos & 0x3FFFFFFFFFFFFFFFL) >= (long)this.insertStorePages.size()) {
                this.filePos = -1L;
                this.noRow();
            }
        } else {
            this.filePos = this.store.getNextPagePos();
        }
    }

    final boolean next() throws Exception {
        if (this.filePos < 0L) {
            return false;
        }
        this.setNextFilePos();
        ++this.row;
        return this.moveToValidRow();
    }

    final void afterLast() {
        this.filePos = -1L;
        this.noRow();
    }

    final int getRow() {
        return this.row;
    }

    final long getRowPosition() {
        return this.filePos;
    }

    final void setRowPosition(long l) throws Exception {
        this.filePos = l;
        if (this.filePos < 0L || !this.moveToRow()) {
            this.store = new StoreNull(this.store.getNextPagePos());
        }
    }

    final boolean rowInserted() {
        return this.filePos >= this.firstOwnInsert;
    }

    final boolean rowDeleted() {
        if (this.store instanceof StoreNull && this.store != Store.NULL) {
            return true;
        }
        return this.store instanceof StoreImpl && ((StoreImpl)this.store).isRollback();
    }

    final void nullRow() {
        this.row = 0;
        this.store = Store.NULL;
    }

    final void noRow() {
        this.row = 0;
        this.store = Store.NOROW;
    }

    final boolean isNull(int n) throws Exception {
        return this.store.isNull(this.offsets[n]);
    }

    final boolean getBoolean(int n) throws Exception {
        return this.store.getBoolean(this.offsets[n], this.dataTypes[n]);
    }

    final int getInt(int n) throws Exception {
        return this.store.getInt(this.offsets[n], this.dataTypes[n]);
    }

    final long getLong(int n) throws Exception {
        return this.store.getLong(this.offsets[n], this.dataTypes[n]);
    }

    final float getFloat(int n) throws Exception {
        return this.store.getFloat(this.offsets[n], this.dataTypes[n]);
    }

    final double getDouble(int n) throws Exception {
        return this.store.getDouble(this.offsets[n], this.dataTypes[n]);
    }

    final long getMoney(int n) throws Exception {
        return this.store.getMoney(this.offsets[n], this.dataTypes[n]);
    }

    final MutableNumeric getNumeric(int n) throws Exception {
        return this.store.getNumeric(this.offsets[n], this.dataTypes[n]);
    }

    final Object getObject(int n) throws Exception {
        return this.store.getObject(this.offsets[n], this.dataTypes[n]);
    }

    final String getString(int n) throws Exception {
        return this.store.getString(this.offsets[n], this.dataTypes[n]);
    }

    final byte[] getBytes(int n) throws Exception {
        return this.store.getBytes(this.offsets[n], this.dataTypes[n]);
    }

    final int getDataType(int n) {
        return this.dataTypes[n];
    }

    private final void copyValueInto(int n, StoreImpl storeImpl) {
        int n2 = this.offsets[n++];
        int n3 = (n < this.offsets.length ? this.offsets[n] : this.store.getUsedSize()) - n2;
        storeImpl.copyValueFrom((StoreImpl)this.store, n2, n3);
    }
}

