/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import smallsql.database.SmallSQLException;
import smallsql.database.TransactionStep;

class StorePage
extends TransactionStep {
    byte[] page;
    int pageSize;
    long fileOffset;

    StorePage(byte[] byArray, int n, FileChannel fileChannel, long l) {
        super(fileChannel);
        this.page = byArray;
        this.pageSize = n;
        this.fileOffset = l;
    }

    final void setPageData(byte[] byArray, int n) {
        this.page = byArray;
        this.pageSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long commit() throws SQLException {
        try {
            if (this.raFile != null && this.page != null) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(this.page, 0, this.pageSize);
                FileChannel fileChannel = this.raFile;
                synchronized (fileChannel) {
                    if (this.fileOffset < 0L) {
                        this.fileOffset = this.raFile.size();
                    }
                    this.raFile.position(this.fileOffset);
                    this.raFile.write(byteBuffer);
                }
            }
            return this.fileOffset;
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    final void rollback() {
        this.raFile = null;
    }
}

