/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import smallsql.database.Column;
import smallsql.database.DateTime;
import smallsql.database.Expression;
import smallsql.database.ExpressionValue;
import smallsql.database.Money;
import smallsql.database.MutableNumeric;
import smallsql.database.SQLParser;
import smallsql.database.SQLTokenizer;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;
import smallsql.database.Store;
import smallsql.database.StorePage;
import smallsql.database.StorePageLink;
import smallsql.database.Table;
import smallsql.database.TableStorePage;
import smallsql.database.TableStorePageInsert;
import smallsql.database.Utils;

public class StoreImpl
extends Store {
    private static final int DEFAULT_PAGE_SIZE = 8192;
    private static final int PAGE_MAGIC = 316478430;
    private static final int PAGE_CONTROL_SIZE = 28;
    private static final byte[] page_control = new byte[28];
    private static final ByteBuffer pageControlBuffer = ByteBuffer.wrap(page_control);
    private int status;
    private static final int NORMAL = 0;
    private static final int DELETED = 1;
    private static final int UPDATE_POINTER = 2;
    private static final int UPDATED_PAGE = 3;
    private final Table table;
    private byte[] page;
    private boolean sharedPageData;
    private StorePage storePage;
    private long filePos;
    private int sizeUsed;
    private int sizePhysical;
    private int nextPageOffset;
    private long filePosUpdated;
    private int type;
    private StoreImpl updatePointer;
    private int offset;

    private StoreImpl(Table table, StorePage storePage, int n, long l) {
        this.table = table;
        this.storePage = storePage;
        this.filePos = l;
        this.type = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StoreImpl createStore(Table table, StorePage storePage, int n, long l) throws SQLException {
        try {
            StoreImpl storeImpl = new StoreImpl(table, storePage, n, l);
            switch (n) {
                case 313: {
                    storeImpl.page = new byte[(int)l + 28];
                    storeImpl.filePos = -1L;
                    break;
                }
                case 205: 
                case 1107: {
                    storeImpl.page = new byte[8192];
                    break;
                }
                case 200: 
                case 201: 
                case 204: {
                    if (storePage.page == null) {
                        FileChannel fileChannel;
                        FileChannel fileChannel2 = fileChannel = storePage.raFile;
                        synchronized (fileChannel2) {
                            if (l >= fileChannel.size() - 28L) {
                                return null;
                            }
                            fileChannel.position(l);
                            Object object = page_control;
                            synchronized (page_control) {
                                pageControlBuffer.position(0);
                                fileChannel.read(pageControlBuffer);
                                storeImpl.page = page_control;
                                storeImpl.readPageHeader();
                                // ** MonitorExit[var8_8 /* !! */ ] (shouldn't be in output)
                                storeImpl.page = new byte[storeImpl.sizeUsed];
                                fileChannel.position(l);
                                object = ByteBuffer.wrap(storeImpl.page);
                                fileChannel.read((ByteBuffer)object);
                            }
                        }
                    }
                    storeImpl.page = storePage.page;
                    storeImpl.sharedPageData = true;
                    storeImpl.readPageHeader();
                    {
                        storeImpl = storeImpl.loadUpdatedStore();
                        break;
                    }
                }
                default: {
                    throw new Error();
                }
            }
            {
                storeImpl.offset = 28;
                return storeImpl;
            }
        }
        catch (Throwable throwable) {
            throw SmallSQLException.createFromException(throwable);
        }
    }

    static StoreImpl recreateStore(Table table, StorePage storePage, int n) throws Exception {
        StoreImpl storeImpl = new StoreImpl(table, storePage, n, -1L);
        storeImpl.page = storePage.page;
        storeImpl.sharedPageData = true;
        storeImpl.readPageHeader();
        storeImpl = storeImpl.loadUpdatedStore();
        storeImpl.offset = 28;
        return storeImpl;
    }

    private final void readPageHeader() throws SQLException {
        if (this.readInt() != 316478430) {
            throw SmallSQLException.create("SS-0193", new Object[]{new Long(this.filePos)});
        }
        this.status = this.readInt();
        this.sizeUsed = this.readInt();
        this.sizePhysical = this.readInt();
        this.nextPageOffset = this.readInt();
        this.filePosUpdated = this.readLong();
    }

    private final StoreImpl loadUpdatedStore() throws Exception {
        if (this.status != 2) {
            return this;
        }
        StoreImpl storeImpl = this.table.getStore(((TableStorePage)this.storePage).con, this.filePosUpdated, this.type);
        storeImpl.updatePointer = this;
        return storeImpl;
    }

    private void resizePage(int n) {
        int n2 = Math.max(n, this.page.length * 2);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.page, 0, byArray, 0, this.page.length);
        this.page = byArray;
    }

    boolean isValidPage() {
        return this.status == 0 || this.status == 3 && this.updatePointer != null;
    }

    int getUsedSize() {
        return this.sizeUsed;
    }

    long getNextPagePos() {
        if (this.updatePointer != null) {
            return this.updatePointer.getNextPagePos();
        }
        if (this.nextPageOffset <= 0) {
            this.nextPageOffset = this.sizePhysical;
        }
        return this.filePos + (long)this.nextPageOffset;
    }

    long writeFinsh(SSConnection sSConnection) throws SQLException {
        switch (this.type) {
            case 205: 
            case 313: 
            case 1107: {
                this.sizeUsed = this.sizePhysical = this.offset;
                break;
            }
            case 204: {
                if (this.status != 2) {
                    this.sizeUsed = this.offset;
                    break;
                }
            }
            case 201: {
                this.sizeUsed = 28;
                break;
            }
            default: {
                throw new Error("" + this.type);
            }
        }
        this.offset = 0;
        this.writeInt(316478430);
        this.writeInt(this.status);
        this.writeInt(this.sizeUsed);
        this.writeInt(this.sizePhysical);
        this.writeInt(0);
        this.writeLong(this.filePosUpdated);
        this.storePage.setPageData(this.page, this.sizeUsed);
        if (sSConnection == null) {
            return this.storePage.commit();
        }
        return 0L;
    }

    final void createWriteLock() throws SQLException {
        TableStorePage tableStorePage = this.table.requestWriteLock(((TableStorePage)this.storePage).con, (TableStorePage)this.storePage);
        if (tableStorePage == null) {
            throw SmallSQLException.create("SS-0523");
        }
        this.storePage = tableStorePage;
    }

    void updateFinsh(SSConnection sSConnection, StoreImpl storeImpl) throws SQLException {
        this.type = 204;
        if (storeImpl.offset <= this.sizePhysical || this.filePos == -1L) {
            this.page = storeImpl.page;
            this.offset = storeImpl.offset;
            if (this.sizePhysical < this.offset) {
                this.sizePhysical = this.offset;
            }
            this.writeFinsh(sSConnection);
        } else {
            storeImpl.status = 3;
            if (this.updatePointer == null) {
                ((TableStorePage)storeImpl.storePage).lockType = 1;
                this.filePosUpdated = storeImpl.writeFinsh(null);
                this.status = 2;
            } else {
                ((TableStorePage)storeImpl.storePage).lockType = 1;
                this.updatePointer.filePosUpdated = storeImpl.writeFinsh(null);
                this.updatePointer.status = 2;
                this.updatePointer.type = 204;
                this.updatePointer.createWriteLock();
                if (this.updatePointer.sharedPageData) {
                    this.updatePointer.page = new byte[28];
                }
                this.updatePointer.writeFinsh(sSConnection);
                this.status = 1;
                if (this.sharedPageData) {
                    this.page = new byte[28];
                }
            }
            this.writeFinsh(sSConnection);
        }
    }

    int getCurrentOffsetInPage() {
        return this.offset;
    }

    void setCurrentOffsetInPage(int n) {
        this.offset = n;
    }

    void writeByte(int n) {
        int n2 = this.offset + 1;
        if (n2 > this.page.length) {
            this.resizePage(n2);
        }
        this.page[this.offset++] = (byte)n;
    }

    int readByte() {
        return this.page[this.offset++];
    }

    int readUnsignedByte() {
        return this.page[this.offset++] & 0xFF;
    }

    void writeBoolean(boolean bl) {
        int n = this.offset + 1;
        if (n > this.page.length) {
            this.resizePage(n);
        }
        this.page[this.offset++] = (byte)(bl ? 1 : 0);
    }

    boolean readBoolean() {
        return this.page[this.offset++] != 0;
    }

    void writeShort(int n) {
        int n2 = this.offset + 2;
        if (n2 > this.page.length) {
            this.resizePage(n2);
        }
        this.page[this.offset++] = (byte)(n >> 8);
        this.page[this.offset++] = (byte)n;
    }

    int readShort() {
        return this.page[this.offset++] << 8 | this.page[this.offset++] & 0xFF;
    }

    void writeInt(int n) {
        int n2 = this.offset + 4;
        if (n2 > this.page.length) {
            this.resizePage(n2);
        }
        this.page[this.offset++] = (byte)(n >> 24);
        this.page[this.offset++] = (byte)(n >> 16);
        this.page[this.offset++] = (byte)(n >> 8);
        this.page[this.offset++] = (byte)n;
    }

    int readInt() {
        return this.page[this.offset++] << 24 | (this.page[this.offset++] & 0xFF) << 16 | (this.page[this.offset++] & 0xFF) << 8 | this.page[this.offset++] & 0xFF;
    }

    void writeLong(long l) {
        int n = this.offset + 8;
        if (n > this.page.length) {
            this.resizePage(n);
        }
        this.page[this.offset++] = (byte)(l >> 56);
        this.page[this.offset++] = (byte)(l >> 48);
        this.page[this.offset++] = (byte)(l >> 40);
        this.page[this.offset++] = (byte)(l >> 32);
        this.page[this.offset++] = (byte)(l >> 24);
        this.page[this.offset++] = (byte)(l >> 16);
        this.page[this.offset++] = (byte)(l >> 8);
        this.page[this.offset++] = (byte)l;
    }

    long readLong() {
        return (long)this.page[this.offset++] << 56 | (long)(this.page[this.offset++] & 0xFF) << 48 | (long)(this.page[this.offset++] & 0xFF) << 40 | (long)(this.page[this.offset++] & 0xFF) << 32 | (long)(this.page[this.offset++] & 0xFF) << 24 | (long)((this.page[this.offset++] & 0xFF) << 16) | (long)((this.page[this.offset++] & 0xFF) << 8) | (long)(this.page[this.offset++] & 0xFF);
    }

    void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    void writeNumeric(MutableNumeric mutableNumeric) {
        this.writeByte(mutableNumeric.getInternalValue().length);
        this.writeByte(mutableNumeric.getScale());
        this.writeByte(mutableNumeric.getSignum());
        for (int i = 0; i < mutableNumeric.getInternalValue().length; ++i) {
            this.writeInt(mutableNumeric.getInternalValue()[i]);
        }
    }

    MutableNumeric readNumeric() {
        int[] nArray = new int[this.readByte()];
        int n = this.readByte();
        int n2 = this.readByte();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.readInt();
        }
        return new MutableNumeric(n2, nArray, n);
    }

    void writeTimestamp(long l) {
        this.writeLong(l);
    }

    long readTimestamp() {
        return this.readLong();
    }

    void writeTime(long l) {
        this.writeInt((int)(l / 1000L % 86400L));
    }

    long readTime() {
        return (long)this.readInt() * 1000L;
    }

    void writeDate(long l) {
        this.writeInt((int)(l / 86400000L));
    }

    long readDate() {
        return (long)this.readInt() * 86400000L;
    }

    void writeSmallDateTime(long l) {
        this.writeInt((int)(l / 60000L));
    }

    long readSmallDateTime() {
        return (long)this.readInt() * 60000L;
    }

    void writeString(String string) throws SQLException {
        this.writeString(string, Short.MAX_VALUE, true);
    }

    void writeString(String string, int n, boolean bl) throws SQLException {
        int n2;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        if (n < n3) {
            throw SmallSQLException.create("SS-0310");
        }
        if (bl) {
            n = n3;
        }
        if ((n2 = this.offset + 2 + 2 * n) > this.page.length) {
            this.resizePage(n2);
        }
        this.writeShort(n);
        this.writeChars(cArray);
        for (int i = n3; i < n; ++i) {
            this.page[this.offset++] = 32;
            this.page[this.offset++] = 0;
        }
    }

    String readString() {
        int n = this.readShort() & 0xFFFF;
        return new String(this.readChars(n));
    }

    void writeBytes(byte[] byArray) {
        int n = this.offset + byArray.length;
        if (n > this.page.length) {
            this.resizePage(n);
        }
        System.arraycopy(byArray, 0, this.page, this.offset, byArray.length);
        this.offset += byArray.length;
    }

    void writeBytes(byte[] byArray, int n, int n2) {
        int n3 = this.offset + n2;
        if (n3 > this.page.length) {
            this.resizePage(n3);
        }
        System.arraycopy(byArray, n, this.page, this.offset, n2);
        this.offset += n2;
    }

    byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.page, this.offset, byArray, 0, n);
        this.offset += n;
        return byArray;
    }

    void writeBinary(byte[] byArray, int n, boolean bl) throws SQLException {
        int n2;
        int n3 = byArray.length;
        if (n < n3) {
            Object[] objectArray = new Object[]{new Integer(n3), new Integer(n)};
            throw SmallSQLException.create("SS-0311", (Object)objectArray);
        }
        if (bl) {
            n = n3;
        }
        if ((n2 = this.offset + 2 + n) > this.page.length) {
            this.resizePage(n2);
        }
        this.page[this.offset++] = (byte)(n >> 8);
        this.page[this.offset++] = (byte)n;
        this.writeBytes(byArray);
        if (!bl) {
            for (int i = n3; i < n; ++i) {
                this.page[this.offset++] = 0;
            }
        }
    }

    byte[] readBinary() {
        int n = this.readShort() & 0xFFFF;
        return this.readBytes(n);
    }

    void writeLongBinary(byte[] byArray) throws Exception {
        StoreImpl storeImpl = this.table.getLobStore(((TableStorePage)this.storePage).con, byArray.length + 4, 313);
        storeImpl.writeInt(byArray.length);
        storeImpl.writeBytes(byArray);
        this.writeLong(storeImpl.writeFinsh(null));
    }

    byte[] readLongBinary() throws Exception {
        long l = this.readLong();
        StoreImpl storeImpl = this.table.getLobStore(((TableStorePage)this.storePage).con, l, 200);
        return storeImpl.readBytes(storeImpl.readInt());
    }

    void writeChars(char[] cArray) {
        int n = cArray.length;
        int n2 = this.offset + 2 * n;
        if (n2 > this.page.length) {
            this.resizePage(n2);
        }
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            this.page[this.offset++] = (byte)c;
            this.page[this.offset++] = (byte)(c >> 8);
        }
    }

    char[] readChars(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(this.page[this.offset++] & 0xFF | this.page[this.offset++] << 8);
        }
        return cArray;
    }

    void writeLongString(String string) throws Exception {
        char[] cArray = string.toCharArray();
        StoreImpl storeImpl = this.table.getLobStore(((TableStorePage)this.storePage).con, (long)cArray.length * 2L + 4L, 313);
        storeImpl.writeInt(cArray.length);
        storeImpl.writeChars(cArray);
        this.writeLong(storeImpl.writeFinsh(null));
    }

    String readLongString() throws Exception {
        long l = this.readLong();
        StoreImpl storeImpl = this.table.getLobStore(((TableStorePage)this.storePage).con, l, 200);
        if (storeImpl == null) {
            throw SmallSQLException.create("SS-0341");
        }
        return new String(storeImpl.readChars(storeImpl.readInt()));
    }

    void writeColumn(Column column) throws Exception {
        int n = this.offset + 25;
        if (n > this.page.length) {
            this.resizePage(n);
        }
        this.writeByte(column.getFlag());
        this.writeString(column.getName());
        this.writeShort(column.getDataType());
        this.writeInt(column.getPrecision());
        this.writeByte(column.getScale());
        this.offset += column.initAutoIncrement(this.storePage.raFile, this.filePos + (long)this.offset);
        String string = column.getDefaultDefinition();
        this.writeBoolean(string == null);
        if (string != null) {
            this.writeString(column.getDefaultDefinition());
        }
    }

    Column readColumn(int n) throws Exception {
        Column column = new Column();
        column.setFlag(this.readByte());
        column.setName(this.readString());
        column.setDataType(this.readShort());
        int n2 = n == 1 ? this.readByte() : this.readInt();
        column.setPrecision(n2);
        column.setScale(this.readByte());
        this.offset += column.initAutoIncrement(this.storePage.raFile, this.filePos + (long)this.offset);
        if (!this.readBoolean()) {
            String string = this.readString();
            column.setDefaultValue(new SQLParser().parseExpression(string), string);
        }
        return column;
    }

    void copyValueFrom(StoreImpl storeImpl, int n, int n2) {
        System.arraycopy(storeImpl.page, n, this.page, this.offset, n2);
        this.offset += n2;
    }

    void writeExpression(Expression expression, Column column) throws Exception {
        boolean bl = expression.isNull();
        if (bl && !column.isNullable()) {
            throw SmallSQLException.create("SS-0312", column.getName());
        }
        int n = column.getDataType();
        if (bl) {
            this.writeBoolean(true);
            switch (n) {
                case 300: 
                case 301: 
                case 321: {
                    ++this.offset;
                    break;
                }
                case 310: 
                case 311: 
                case 322: 
                case 350: 
                case 352: 
                case 353: 
                case 355: {
                    this.offset += 2;
                    break;
                }
                case 323: 
                case 330: 
                case 336: 
                case 340: 
                case 341: 
                case 343: {
                    this.offset += 4;
                    break;
                }
                case 313: 
                case 316: 
                case 325: 
                case 331: 
                case 337: 
                case 338: 
                case 342: 
                case 359: 
                case 360: 
                case 362: 
                case 363: 
                case 371: {
                    this.offset += 8;
                    break;
                }
                case 370: {
                    this.offset += 16;
                    break;
                }
                case 332: 
                case 333: {
                    this.offset += 3;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return;
        }
        this.writeBoolean(false);
        column.setNewAutoIncrementValue(expression);
        switch (n) {
            case 300: 
            case 301: {
                this.writeBoolean(expression.getBoolean());
                break;
            }
            case 310: 
            case 311: {
                this.writeBinary(expression.getBytes(), column.getPrecision(), n != 310);
                break;
            }
            case 321: {
                this.writeByte(expression.getInt());
                break;
            }
            case 322: {
                this.writeShort(expression.getInt());
                break;
            }
            case 323: {
                this.writeInt(expression.getInt());
                break;
            }
            case 325: {
                this.writeLong(expression.getLong());
                break;
            }
            case 336: {
                this.writeFloat(expression.getFloat());
                break;
            }
            case 337: 
            case 338: {
                this.writeDouble(expression.getDouble());
                break;
            }
            case 331: {
                this.writeLong(expression.getMoney());
                break;
            }
            case 330: {
                this.writeInt((int)expression.getMoney());
                break;
            }
            case 332: 
            case 333: {
                MutableNumeric mutableNumeric = expression.getNumeric();
                mutableNumeric.setScale(column.getScale());
                this.writeNumeric(mutableNumeric);
                break;
            }
            case 350: 
            case 352: {
                this.writeString(expression.getString(), column.getDisplaySize(), false);
                break;
            }
            case 353: 
            case 355: {
                this.writeString(expression.getString(), column.getDisplaySize(), true);
                break;
            }
            case 359: 
            case 360: 
            case 362: 
            case 363: {
                this.writeLongString(expression.getString());
                break;
            }
            case 371: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(expression.getObject());
                this.writeLongBinary(byteArrayOutputStream.toByteArray());
                break;
            }
            case 313: 
            case 316: {
                this.writeLongBinary(expression.getBytes());
                break;
            }
            case 342: {
                this.writeTimestamp(expression.getLong());
                break;
            }
            case 341: {
                this.writeTime(expression.getLong());
                break;
            }
            case 340: {
                this.writeDate(expression.getLong());
                break;
            }
            case 343: {
                this.writeSmallDateTime(expression.getLong());
                break;
            }
            case 370: {
                switch (expression.getDataType()) {
                    case 310: 
                    case 311: 
                    case 313: 
                    case 316: 
                    case 370: {
                        byte[] byArray = expression.getBytes();
                        if (byArray.length != 16) {
                            throw SmallSQLException.create("SS-0340", String.valueOf(byArray.length));
                        }
                        this.writeBytes(byArray);
                    }
                }
                this.writeBytes(Utils.unique2bytes(expression.getString()));
                break;
            }
            default: {
                throw new Error(String.valueOf(column.getDataType()));
            }
        }
    }

    boolean isNull(int n) {
        return this.page[n] != 0;
    }

    boolean getBoolean(int n, int n2) throws Exception {
        this.offset = n;
        if (this.readBoolean()) {
            return false;
        }
        switch (n2) {
            case 300: 
            case 301: {
                return this.readBoolean();
            }
            case 310: 
            case 311: {
                return Utils.bytes2int(this.readBinary()) != 0;
            }
            case 321: {
                return this.readUnsignedByte() != 0;
            }
            case 322: {
                return this.readShort() != 0;
            }
            case 323: {
                return this.readInt() != 0;
            }
            case 325: {
                return this.readLong() != 0L;
            }
            case 336: {
                return this.readFloat() != 0.0f;
            }
            case 337: 
            case 338: {
                return this.readDouble() != 0.0;
            }
            case 331: {
                return this.readLong() != 0L;
            }
            case 330: {
                return this.readInt() != 0;
            }
            case 332: 
            case 333: {
                return this.readNumeric().getSignum() != 0;
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                return Utils.string2boolean(this.readString());
            }
            case 359: 
            case 360: 
            case 362: 
            case 363: {
                return Utils.string2boolean(this.readLongString());
            }
            case 371: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readLongBinary());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return Utils.string2boolean(objectInputStream.readObject().toString());
            }
            case 313: 
            case 316: {
                return Utils.bytes2int(this.readLongBinary()) != 0;
            }
            case 342: {
                return this.readTimestamp() != 0L;
            }
            case 341: {
                return this.readTime() != 0L;
            }
            case 340: {
                return this.readDate() != 0L;
            }
            case 343: {
                return this.readSmallDateTime() != 0L;
            }
            case 370: {
                return false;
            }
        }
        throw SmallSQLException.create("SS-0313", new Object[]{SQLTokenizer.getKeyWord(n2), "BOOLEAN"});
    }

    int getInt(int n, int n2) throws Exception {
        this.offset = n;
        if (this.readBoolean()) {
            return 0;
        }
        switch (n2) {
            case 300: 
            case 301: {
                return this.readBoolean() ? 1 : 0;
            }
            case 310: 
            case 311: {
                return Utils.bytes2int(this.readBinary());
            }
            case 321: {
                return this.readUnsignedByte();
            }
            case 322: {
                return this.readShort();
            }
            case 323: {
                return this.readInt();
            }
            case 325: {
                return (int)this.readLong();
            }
            case 336: {
                return (int)this.readFloat();
            }
            case 337: 
            case 338: {
                return (int)this.readDouble();
            }
            case 331: {
                long l = this.readLong() / 10000L;
                return Utils.money2int(l);
            }
            case 330: {
                return this.readInt() / 10000;
            }
            case 332: 
            case 333: {
                return this.readNumeric().intValue();
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                return Integer.parseInt(this.readString());
            }
            case 359: 
            case 360: 
            case 362: 
            case 363: {
                return Integer.parseInt(this.readLongString());
            }
            case 371: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readLongBinary());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return ExpressionValue.getInt(objectInputStream.readObject().toString(), 353);
            }
            case 313: 
            case 316: {
                return Utils.bytes2int(this.readLongBinary());
            }
            case 342: {
                return (int)this.readTimestamp();
            }
            case 341: {
                return (int)this.readTime();
            }
            case 340: {
                return (int)this.readDate();
            }
            case 343: {
                return (int)this.readSmallDateTime();
            }
        }
        throw SmallSQLException.create("SS-0313", new Object[]{SQLTokenizer.getKeyWord(n2), "INT"});
    }

    long getLong(int n, int n2) throws Exception {
        this.offset = n;
        if (this.readBoolean()) {
            return 0L;
        }
        switch (n2) {
            case 300: 
            case 301: {
                return this.readBoolean() ? 1L : 0L;
            }
            case 310: 
            case 311: {
                return Utils.bytes2long(this.readBinary());
            }
            case 321: {
                return this.readUnsignedByte();
            }
            case 322: {
                return this.readShort();
            }
            case 323: {
                return this.readInt();
            }
            case 325: {
                return this.readLong();
            }
            case 336: {
                return (long)this.readFloat();
            }
            case 337: 
            case 338: {
                return (long)this.readDouble();
            }
            case 331: {
                return this.readLong() / 10000L;
            }
            case 330: {
                return this.readInt() / 10000;
            }
            case 332: 
            case 333: {
                return this.readNumeric().longValue();
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                return Long.parseLong(this.readString());
            }
            case 359: 
            case 360: 
            case 362: 
            case 363: {
                return Long.parseLong(this.readLongString());
            }
            case 371: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readLongBinary());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return ExpressionValue.getLong(objectInputStream.readObject().toString(), 353);
            }
            case 313: 
            case 316: {
                return Utils.bytes2long(this.readLongBinary());
            }
            case 342: {
                return this.readTimestamp();
            }
            case 341: {
                return this.readTime();
            }
            case 340: {
                return this.readDate();
            }
            case 343: {
                return this.readSmallDateTime();
            }
        }
        throw SmallSQLException.create("SS-0313", new Object[]{SQLTokenizer.getKeyWord(n2), "BIGINT"});
    }

    float getFloat(int n, int n2) throws Exception {
        this.offset = n;
        if (this.readBoolean()) {
            return 0.0f;
        }
        switch (n2) {
            case 300: 
            case 301: {
                return this.readBoolean() ? 1.0f : 0.0f;
            }
            case 310: 
            case 311: {
                return Utils.bytes2float(this.readBinary());
            }
            case 321: {
                return this.readUnsignedByte();
            }
            case 322: {
                return this.readShort();
            }
            case 323: {
                return this.readInt();
            }
            case 325: {
                return this.readLong();
            }
            case 336: {
                return this.readFloat();
            }
            case 337: 
            case 338: {
                return (float)this.readDouble();
            }
            case 331: {
                return (float)this.readLong() / 10000.0f;
            }
            case 330: {
                return (float)this.readInt() / 10000.0f;
            }
            case 332: 
            case 333: {
                return this.readNumeric().floatValue();
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                return Float.parseFloat(this.readString());
            }
            case 359: 
            case 360: 
            case 362: 
            case 363: {
                return Float.parseFloat(this.readLongString());
            }
            case 371: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readLongBinary());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return Float.parseFloat(objectInputStream.readObject().toString());
            }
            case 313: 
            case 316: {
                return Utils.bytes2float(this.readLongBinary());
            }
            case 342: {
                return this.readTimestamp();
            }
            case 341: {
                return this.readTime();
            }
            case 340: {
                return this.readDate();
            }
            case 343: {
                return this.readSmallDateTime();
            }
        }
        throw SmallSQLException.create("SS-0313", new Object[]{SQLTokenizer.getKeyWord(n2), "REAL"});
    }

    double getDouble(int n, int n2) throws Exception {
        this.offset = n;
        if (this.readBoolean()) {
            return 0.0;
        }
        switch (n2) {
            case 300: 
            case 301: {
                return this.readBoolean() ? 1.0 : 0.0;
            }
            case 310: 
            case 311: {
                return Utils.bytes2double(this.readBinary());
            }
            case 321: {
                return this.readUnsignedByte();
            }
            case 322: {
                return this.readShort();
            }
            case 323: {
                return this.readInt();
            }
            case 325: {
                return this.readLong();
            }
            case 336: {
                return this.readFloat();
            }
            case 337: 
            case 338: {
                return this.readDouble();
            }
            case 331: {
                return (double)this.readLong() / 10000.0;
            }
            case 330: {
                return (double)this.readInt() / 10000.0;
            }
            case 332: 
            case 333: {
                return this.readNumeric().doubleValue();
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                return Double.parseDouble(this.readString());
            }
            case 359: 
            case 360: 
            case 362: 
            case 363: {
                return Double.parseDouble(this.readLongString());
            }
            case 371: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readLongBinary());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return Double.parseDouble(objectInputStream.readObject().toString());
            }
            case 313: 
            case 316: {
                return Utils.bytes2double(this.readLongBinary());
            }
            case 342: {
                return this.readTimestamp();
            }
            case 341: {
                return this.readTime();
            }
            case 340: {
                return this.readDate();
            }
            case 343: {
                return this.readSmallDateTime();
            }
        }
        throw SmallSQLException.create("SS-0313", new Object[]{SQLTokenizer.getKeyWord(n2), "NUMERIC"});
    }

    long getMoney(int n, int n2) throws Exception {
        this.offset = n;
        if (this.readBoolean()) {
            return 0L;
        }
        switch (n2) {
            case 300: 
            case 301: {
                return this.readBoolean() ? 10000L : 0L;
            }
            case 310: 
            case 311: {
                return (long)(Utils.bytes2double(this.readBinary()) * 10000.0);
            }
            case 321: {
                return (long)this.readUnsignedByte() * 10000L;
            }
            case 322: {
                return (long)this.readShort() * 10000L;
            }
            case 323: {
                return (long)this.readInt() * 10000L;
            }
            case 325: {
                return this.readLong() * 10000L;
            }
            case 336: {
                return (long)(this.readFloat() * 10000.0f);
            }
            case 337: 
            case 338: {
                return (long)(this.readDouble() * 10000.0);
            }
            case 331: {
                return this.readLong();
            }
            case 330: {
                return this.readInt();
            }
            case 332: 
            case 333: {
                return (long)(this.readNumeric().doubleValue() * 10000.0);
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                return Money.parseMoney(this.readString());
            }
            case 359: 
            case 360: 
            case 362: 
            case 363: {
                return Money.parseMoney(this.readLongString());
            }
            case 371: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readLongBinary());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return Money.parseMoney(objectInputStream.readObject().toString());
            }
            case 313: 
            case 316: {
                return (long)(Utils.bytes2double(this.readLongBinary()) * 10000.0);
            }
            case 340: 
            case 341: 
            case 342: 
            case 343: {
                throw SmallSQLException.create("SS-0313", new Object[]{SQLTokenizer.getKeyWord(n2), "MONEY"});
            }
        }
        throw new Error();
    }

    MutableNumeric getNumeric(int n, int n2) throws Exception {
        this.offset = n;
        if (this.readBoolean()) {
            return null;
        }
        switch (n2) {
            case 300: 
            case 301: {
                return this.readBoolean() ? new MutableNumeric(1) : new MutableNumeric(0);
            }
            case 310: 
            case 311: {
                return new MutableNumeric(Utils.bytes2double(this.readBinary()));
            }
            case 321: {
                return new MutableNumeric(this.readUnsignedByte());
            }
            case 322: {
                return new MutableNumeric(this.readShort());
            }
            case 323: {
                return new MutableNumeric(this.readInt());
            }
            case 325: {
                return new MutableNumeric(this.readLong());
            }
            case 336: {
                return new MutableNumeric(this.readFloat());
            }
            case 337: 
            case 338: {
                return new MutableNumeric(this.readDouble());
            }
            case 331: {
                return new MutableNumeric(this.readLong(), 4);
            }
            case 330: {
                return new MutableNumeric(this.readInt(), 4);
            }
            case 332: 
            case 333: {
                return this.readNumeric();
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                return new MutableNumeric(this.readString());
            }
            case 359: 
            case 360: 
            case 362: 
            case 363: {
                return new MutableNumeric(this.readLongString());
            }
            case 371: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readLongBinary());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return new MutableNumeric(objectInputStream.readObject().toString());
            }
            case 313: 
            case 316: {
                return new MutableNumeric(Utils.bytes2double(this.readLongBinary()));
            }
            case 340: 
            case 341: 
            case 342: 
            case 343: {
                throw SmallSQLException.create("SS-0313", new Object[]{SQLTokenizer.getKeyWord(n2), "NUMERIC"});
            }
        }
        throw new Error();
    }

    Object getObject(int n, int n2) throws Exception {
        this.offset = n;
        if (this.readBoolean()) {
            return null;
        }
        switch (n2) {
            case 300: 
            case 301: {
                return this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 310: 
            case 311: {
                return this.readBinary();
            }
            case 321: {
                return Utils.getInteger(this.readUnsignedByte());
            }
            case 322: {
                return Utils.getInteger(this.readShort());
            }
            case 323: {
                return Utils.getInteger(this.readInt());
            }
            case 325: {
                return new Long(this.readLong());
            }
            case 336: {
                return new Float(this.readFloat());
            }
            case 337: 
            case 338: {
                return new Double(this.readDouble());
            }
            case 331: {
                return Money.createFromUnscaledValue(this.readLong());
            }
            case 330: {
                return Money.createFromUnscaledValue(this.readInt());
            }
            case 332: 
            case 333: {
                return this.readNumeric();
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                return this.readString();
            }
            case 359: 
            case 360: 
            case 362: 
            case 363: {
                return this.readLongString();
            }
            case 371: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readLongBinary());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return objectInputStream.readObject();
            }
            case 313: 
            case 316: {
                return this.readLongBinary();
            }
            case 342: {
                return new DateTime(this.readTimestamp(), 342);
            }
            case 341: {
                return new DateTime(this.readTime(), 341);
            }
            case 340: {
                return new DateTime(this.readDate(), 340);
            }
            case 343: {
                return new DateTime(this.readSmallDateTime(), 342);
            }
            case 370: {
                return Utils.bytes2unique(this.page, this.offset);
            }
        }
        throw new Error();
    }

    String getString(int n, int n2) throws Exception {
        this.offset = n;
        if (this.readBoolean()) {
            return null;
        }
        switch (n2) {
            case 300: {
                return this.readBoolean() ? "1" : "0";
            }
            case 301: {
                return String.valueOf(this.readBoolean());
            }
            case 310: 
            case 311: {
                return Utils.bytes2hex(this.readBinary());
            }
            case 321: {
                return String.valueOf(this.readUnsignedByte());
            }
            case 322: {
                return String.valueOf(this.readShort());
            }
            case 323: {
                return String.valueOf(this.readInt());
            }
            case 325: {
                return String.valueOf(this.readLong());
            }
            case 336: {
                return String.valueOf(this.readFloat());
            }
            case 337: 
            case 338: {
                return String.valueOf(this.readDouble());
            }
            case 331: {
                return Money.createFromUnscaledValue(this.readLong()).toString();
            }
            case 330: {
                return Money.createFromUnscaledValue(this.readInt()).toString();
            }
            case 332: 
            case 333: {
                return this.readNumeric().toString();
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                return this.readString();
            }
            case 359: 
            case 360: 
            case 362: 
            case 363: {
                return this.readLongString();
            }
            case 371: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readLongBinary());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return objectInputStream.readObject().toString();
            }
            case 313: 
            case 316: {
                return Utils.bytes2hex(this.readLongBinary());
            }
            case 342: {
                return new DateTime(this.readTimestamp(), 342).toString();
            }
            case 341: {
                return new DateTime(this.readTime(), 341).toString();
            }
            case 340: {
                return new DateTime(this.readDate(), 340).toString();
            }
            case 343: {
                return new DateTime(this.readSmallDateTime(), 342).toString();
            }
            case 370: {
                return Utils.bytes2unique(this.page, this.offset);
            }
        }
        throw new Error();
    }

    byte[] getBytes(int n, int n2) throws Exception {
        this.offset = n;
        if (this.readBoolean()) {
            return null;
        }
        switch (n2) {
            case 310: 
            case 311: {
                return this.readBinary();
            }
            case 300: 
            case 301: 
            case 321: {
                byte[] byArray = new byte[1];
                System.arraycopy(this.page, n, byArray, 0, byArray.length);
                return byArray;
            }
            case 322: {
                byte[] byArray = new byte[2];
                System.arraycopy(this.page, n, byArray, 0, byArray.length);
                return byArray;
            }
            case 323: 
            case 330: 
            case 336: 
            case 340: 
            case 341: 
            case 343: {
                byte[] byArray = new byte[4];
                System.arraycopy(this.page, n, byArray, 0, byArray.length);
                return byArray;
            }
            case 325: 
            case 331: 
            case 337: 
            case 338: 
            case 342: {
                byte[] byArray = new byte[8];
                System.arraycopy(this.page, n, byArray, 0, byArray.length);
                return byArray;
            }
            case 332: 
            case 333: {
                return this.readNumeric().toByteArray();
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                return this.readString().getBytes();
            }
            case 359: 
            case 360: 
            case 362: 
            case 363: {
                return this.readLongString().getBytes();
            }
            case 313: 
            case 316: 
            case 371: {
                return this.readLongBinary();
            }
            case 370: {
                byte[] byArray = new byte[16];
                System.arraycopy(this.page, n, byArray, 0, byArray.length);
                return byArray;
            }
        }
        throw new Error();
    }

    void scanObjectOffsets(int[] nArray, int[] nArray2) {
        this.offset = 28;
        block10: for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.offset++;
            boolean bl = this.readBoolean();
            switch (nArray2[i]) {
                case 300: 
                case 301: 
                case 321: {
                    continue block10;
                }
                case 322: {
                    this.offset += 2;
                    continue block10;
                }
                case 323: 
                case 330: 
                case 336: 
                case 340: 
                case 341: 
                case 343: {
                    this.offset += 4;
                    continue block10;
                }
                case 313: 
                case 316: 
                case 325: 
                case 331: 
                case 337: 
                case 338: 
                case 342: 
                case 359: 
                case 360: 
                case 362: 
                case 363: 
                case 371: {
                    this.offset += 8;
                    continue block10;
                }
                case 310: 
                case 311: {
                    int n = this.readShort() & 0xFFFF;
                    if (bl) continue block10;
                    this.offset += n;
                    continue block10;
                }
                case 332: 
                case 333: {
                    int n = this.readByte();
                    this.offset += 2;
                    if (bl) continue block10;
                    this.offset += n * 4;
                    continue block10;
                }
                case 350: 
                case 352: 
                case 353: 
                case 355: {
                    int n = this.readShort() & 0xFFFF;
                    if (bl) continue block10;
                    this.offset += n << 1;
                    continue block10;
                }
                case 370: {
                    this.offset += 16;
                    continue block10;
                }
                default: {
                    throw new Error(String.valueOf(nArray2[i]));
                }
            }
        }
    }

    void deleteRow(SSConnection sSConnection) throws SQLException {
        this.status = 1;
        this.type = 201;
        this.createWriteLock();
        this.writeFinsh(sSConnection);
    }

    StorePageLink getLink() {
        return ((TableStorePageInsert)this.storePage).getLink();
    }

    boolean isRollback() {
        return this.storePage.raFile == null;
    }
}

