/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import smallsql.database.DateTime;
import smallsql.database.Expression;
import smallsql.database.MutableNumeric;
import smallsql.database.SSConnection;
import smallsql.database.SSPreparedStatement;
import smallsql.database.SmallSQLException;

public class SSCallableStatement
extends SSPreparedStatement
implements CallableStatement {
    private boolean wasNull;

    SSCallableStatement(SSConnection sSConnection, String string) throws SQLException {
        super(sSConnection, string);
    }

    SSCallableStatement(SSConnection sSConnection, String string, int n, int n2) throws SQLException {
        super(sSConnection, string, n, n2);
    }

    private Expression getValue(int n) throws SQLException {
        throw new UnsupportedOperationException("Method getValue() not yet implemented.");
    }

    private int findParameter(String string) {
        throw new UnsupportedOperationException("Method findParameter() not yet implemented.");
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        throw new UnsupportedOperationException("Method registerOutParameter() not yet implemented.");
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException("Method registerOutParameter() not yet implemented.");
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getString(int n) throws SQLException {
        try {
            String string = this.getValue(n).getString();
            this.wasNull = string == null;
            return string;
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            return expression.getBoolean();
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public short getShort(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public int getInt(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            return expression.getInt();
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            return expression.getLong();
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            return expression.getFloat();
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            return expression.getLong();
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            MutableNumeric mutableNumeric = this.getValue(n).getNumeric();
            boolean bl = this.wasNull = mutableNumeric == null;
            if (this.wasNull) {
                return null;
            }
            return mutableNumeric.toBigDecimal(n2);
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            byte[] byArray = this.getValue(n).getBytes();
            this.wasNull = byArray == null;
            return byArray;
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            if (this.wasNull) {
                return null;
            }
            return DateTime.getDate(expression.getLong());
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            if (this.wasNull) {
                return null;
            }
            return DateTime.getTime(expression.getLong());
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            if (this.wasNull) {
                return null;
            }
            return DateTime.getTimestamp(expression.getLong());
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public Object getObject(int n) throws SQLException {
        try {
            Object object = this.getValue(n).getObject();
            this.wasNull = object == null;
            return object;
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            MutableNumeric mutableNumeric = this.getValue(n).getNumeric();
            boolean bl = this.wasNull = mutableNumeric == null;
            if (this.wasNull) {
                return null;
            }
            return mutableNumeric.toBigDecimal();
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw SmallSQLException.create("SS-0001", "Method getObject() not yet implemented.");
    }

    public Ref getRef(int n) throws SQLException {
        throw SmallSQLException.create("SS-0001", "Method getRef() not yet implemented.");
    }

    public Blob getBlob(int n) throws SQLException {
        throw SmallSQLException.create("SS-0001", "Method getBlob() not yet implemented.");
    }

    public Clob getClob(int n) throws SQLException {
        throw SmallSQLException.create("SS-0001", "Method getClob() not yet implemented.");
    }

    public Array getArray(int n) throws SQLException {
        throw SmallSQLException.create("SS-0001", "Method getArray() not yet implemented.");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw SmallSQLException.create("SS-0001", "Method getDate() not yet implemented.");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw SmallSQLException.create("SS-0001", "Method getTime() not yet implemented.");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw SmallSQLException.create("SS-0001", "Method getTimestamp() not yet implemented.");
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw SmallSQLException.create("SS-0001", "Method registerOutParameter() not yet implemented.");
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(this.findParameter(string), n);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.registerOutParameter(this.findParameter(string), n, n2);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.registerOutParameter(this.findParameter(string), n, string2);
    }

    public URL getURL(int n) throws SQLException {
        throw SmallSQLException.create("SS-0001", "Method getURL() not yet implemented.");
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.setURL(this.findParameter(string), uRL);
    }

    public void setNull(String string, int n) throws SQLException {
        this.setNull(this.findParameter(string), n);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.findParameter(string), bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        this.setByte(this.findParameter(string), by);
    }

    public void setShort(String string, short s) throws SQLException {
        this.setShort(this.findParameter(string), s);
    }

    public void setInt(String string, int n) throws SQLException {
        this.setInt(this.findParameter(string), n);
    }

    public void setLong(String string, long l) throws SQLException {
        this.setLong(this.findParameter(string), l);
    }

    public void setFloat(String string, float f) throws SQLException {
        this.setFloat(this.findParameter(string), f);
    }

    public void setDouble(String string, double d) throws SQLException {
        this.setDouble(this.findParameter(string), d);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.findParameter(string), bigDecimal);
    }

    public void setString(String string, String string2) throws SQLException {
        this.setString(this.findParameter(string), string2);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.findParameter(string), byArray);
    }

    public void setDate(String string, Date date) throws SQLException {
        this.setDate(this.findParameter(string), date);
    }

    public void setTime(String string, Time time) throws SQLException {
        this.setTime(this.findParameter(string), time);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.findParameter(string), timestamp);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.findParameter(string), inputStream, n);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.findParameter(string), inputStream, n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.setObject(this.findParameter(string), object, n, n2);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(this.findParameter(string), object, n);
    }

    public void setObject(String string, Object object) throws SQLException {
        this.setObject(this.findParameter(string), object);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.findParameter(string), reader, n);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.findParameter(string), date, calendar);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.findParameter(string), time, calendar);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.findParameter(string), timestamp, calendar);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.setNull(this.findParameter(string), n, string2);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findParameter(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findParameter(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findParameter(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findParameter(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findParameter(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findParameter(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findParameter(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findParameter(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findParameter(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findParameter(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findParameter(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findParameter(string));
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findParameter(string));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findParameter(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findParameter(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findParameter(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findParameter(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findParameter(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findParameter(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findParameter(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findParameter(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findParameter(string), calendar);
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findParameter(string));
    }
}

