/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import java.util.List;
import smallsql.database.Column;
import smallsql.database.Command;
import smallsql.database.CommandCreateDatabase;
import smallsql.database.CommandCreateView;
import smallsql.database.CommandDelete;
import smallsql.database.CommandDrop;
import smallsql.database.CommandInsert;
import smallsql.database.CommandSelect;
import smallsql.database.CommandSet;
import smallsql.database.CommandTable;
import smallsql.database.CommandUpdate;
import smallsql.database.DataSources;
import smallsql.database.Database;
import smallsql.database.DateTime;
import smallsql.database.Expression;
import smallsql.database.ExpressionArithmetic;
import smallsql.database.ExpressionFunctionACos;
import smallsql.database.ExpressionFunctionASin;
import smallsql.database.ExpressionFunctionATan;
import smallsql.database.ExpressionFunctionATan2;
import smallsql.database.ExpressionFunctionAbs;
import smallsql.database.ExpressionFunctionAscii;
import smallsql.database.ExpressionFunctionBitLen;
import smallsql.database.ExpressionFunctionCase;
import smallsql.database.ExpressionFunctionCeiling;
import smallsql.database.ExpressionFunctionChar;
import smallsql.database.ExpressionFunctionCharLen;
import smallsql.database.ExpressionFunctionConvert;
import smallsql.database.ExpressionFunctionCos;
import smallsql.database.ExpressionFunctionCot;
import smallsql.database.ExpressionFunctionDayOfMonth;
import smallsql.database.ExpressionFunctionDayOfWeek;
import smallsql.database.ExpressionFunctionDayOfYear;
import smallsql.database.ExpressionFunctionDegrees;
import smallsql.database.ExpressionFunctionDifference;
import smallsql.database.ExpressionFunctionExp;
import smallsql.database.ExpressionFunctionFloor;
import smallsql.database.ExpressionFunctionHour;
import smallsql.database.ExpressionFunctionIIF;
import smallsql.database.ExpressionFunctionInsert;
import smallsql.database.ExpressionFunctionLCase;
import smallsql.database.ExpressionFunctionLTrim;
import smallsql.database.ExpressionFunctionLeft;
import smallsql.database.ExpressionFunctionLength;
import smallsql.database.ExpressionFunctionLocate;
import smallsql.database.ExpressionFunctionLog;
import smallsql.database.ExpressionFunctionLog10;
import smallsql.database.ExpressionFunctionMinute;
import smallsql.database.ExpressionFunctionMod;
import smallsql.database.ExpressionFunctionMonth;
import smallsql.database.ExpressionFunctionOctetLen;
import smallsql.database.ExpressionFunctionPI;
import smallsql.database.ExpressionFunctionPower;
import smallsql.database.ExpressionFunctionRTrim;
import smallsql.database.ExpressionFunctionRadians;
import smallsql.database.ExpressionFunctionRand;
import smallsql.database.ExpressionFunctionRepeat;
import smallsql.database.ExpressionFunctionReplace;
import smallsql.database.ExpressionFunctionRight;
import smallsql.database.ExpressionFunctionRound;
import smallsql.database.ExpressionFunctionSign;
import smallsql.database.ExpressionFunctionSin;
import smallsql.database.ExpressionFunctionSoundex;
import smallsql.database.ExpressionFunctionSpace;
import smallsql.database.ExpressionFunctionSqrt;
import smallsql.database.ExpressionFunctionSubstring;
import smallsql.database.ExpressionFunctionTan;
import smallsql.database.ExpressionFunctionTimestampAdd;
import smallsql.database.ExpressionFunctionTimestampDiff;
import smallsql.database.ExpressionFunctionTruncate;
import smallsql.database.ExpressionFunctionUCase;
import smallsql.database.ExpressionFunctionYear;
import smallsql.database.ExpressionInSelect;
import smallsql.database.ExpressionName;
import smallsql.database.ExpressionValue;
import smallsql.database.Expressions;
import smallsql.database.ForeignKey;
import smallsql.database.IndexDescription;
import smallsql.database.Join;
import smallsql.database.Money;
import smallsql.database.RowSource;
import smallsql.database.SQLToken;
import smallsql.database.SQLTokenizer;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;
import smallsql.database.Strings;
import smallsql.database.TableView;
import smallsql.database.TableViewResult;
import smallsql.database.UnionAll;
import smallsql.database.Utils;
import smallsql.database.ViewResult;

final class SQLParser {
    SSConnection con;
    private char[] sql;
    private List tokens;
    private int tokenIdx;
    private static final int[] COMMANDS = new int[]{200, 201, 1107, 204, 205, 206, 207, 208, 228, 209, 1023};
    private static final int[] COMMANDS_ESCAPE = new int[]{400, 401, 402, 403, 404};
    private static final int[] COMMANDS_ALTER = new int[]{235, 236, 237, 239};
    private static final int[] COMMANDS_CREATE = new int[]{235, 236, 237, 238, 239, 254, 255, 256};
    private static final int[] COMMANDS_DROP = new int[]{235, 236, 237, 238, 239};
    private static final int[] COMMANDS_SET = new int[]{240};
    private static final int[] COMMANDS_CREATE_UNIQUE = new int[]{238, 255, 256};
    private static final int[] MISSING_TABLE = new int[]{236};
    private static final int[] ESCAPE_MISSING_CLOSE = new int[]{125};
    private static final int[] MISSING_EXPRESSION = new int[]{0};
    private static final int[] MISSING_IDENTIFIER = new int[]{4};
    private static final int[] MISSING_BY = new int[]{213};
    private static final int[] MISSING_PARENTHESIS_L = new int[]{40};
    private static final int[] MISSING_PARENTHESIS_R = new int[]{41};
    private static final int[] MISSING_DATATYPE = new int[]{300, 301, 310, 311, 312, 313, 316, 321, 322, 323, 324, 325, 330, 331, 332, 333, 336, 337, 338, 340, 341, 342, 343, 350, 352, 353, 355, 361, 360, 359, 362, 363, 370, 371, 357};
    private static final int[] MISSING_SQL_DATATYPE = new int[]{1350, 1351, 1352, 1353, 1354, 1355, 1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367};
    private static final int[] MISSING_INTO = new int[]{203};
    private static final int[] MISSING_BETWEEN_IN = new int[]{507, 509};
    private static final int[] MISSING_NOT_NULL = new int[]{503, 504};
    private static final int[] MISSING_NULL = new int[]{504};
    private static final int[] MISSING_COMMA = new int[]{44};
    private static final int[] MISSING_COMMA_PARENTHESIS = new int[]{44, 41};
    private static final int[] MISSING_PARENTHESIS_VALUES_SELECT = new int[]{40, 218, 200};
    private static final int[] MISSING_TOKEN_LIST = new int[]{44, 210, 212, 214, 215};
    private static final int[] MISSING_FROM = new int[]{210};
    private static final int[] MISSING_SET = new int[]{208};
    private static final int[] MISSING_EQUALS = new int[]{61};
    private static final int[] MISSING_WHERE = new int[]{211};
    private static final int[] MISSING_WHERE_COMMA = new int[]{211, 44};
    private static final int[] MISSING_ISOLATION = new int[]{241};
    private static final int[] MISSING_LEVEL = new int[]{242};
    private static final int[] COMMANDS_TRANS_LEVEL = new int[]{243, 246, 247};
    private static final int[] MISSING_READ = new int[]{243};
    private static final int[] MISSING_COMM_UNCOMM = new int[]{244, 245};
    private static final int[] MISSING_OPTIONS_DATATYPE = new int[]{220, 221, 503, 504, 251, 254, 44, 41};
    private static final int[] MISSING_NUMBERVALUE = new int[]{5};
    private static final int[] MISSING_AND = new int[]{501};
    private static final int[] MISSING_JOIN = new int[]{223};
    private static final int[] MISSING_OUTER_JOIN = new int[]{225, 223};
    private static final int[] MISSING_OJ = new int[]{405};
    private static final int[] MISSING_ON = new int[]{224};
    private static final int[] MISSING_KEYTYPE = new int[]{251, 254, 252};
    private static final int[] MISSING_KEY = new int[]{253};
    private static final int[] MISSING_REFERENCES = new int[]{257};
    private static final int[] MISSING_AS = new int[]{219};
    private static final int[] MISSING_SELECT = new int[]{200};
    private static final int[] MISSING_INTERVALS = new int[]{1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258, 1209, 1215, 1210, 1208, 1207, 1218, 1211, 1214, 1219, 400};
    private static final int[] MISSING_ALL = new int[]{261};
    private static final int[] MISSING_THEN = new int[]{265};
    private static final int[] MISSING_WHEN_ELSE_END = new int[]{264, 266, 267};
    private static final int[] MISSING_ADD_ALTER_DROP = new int[]{230, 207, 206};

    SQLParser() {
    }

    Command parse(SSConnection sSConnection, String string) throws SQLException {
        this.con = sSConnection;
        Command command = this.parse(string.toCharArray());
        SQLToken sQLToken = this.nextToken();
        if (sQLToken != null) {
            throw this.createSyntaxError(sQLToken, "SS-0612");
        }
        return command;
    }

    private final Command parse(char[] cArray) throws SQLException {
        this.sql = cArray;
        this.tokens = SQLTokenizer.parseSQL(cArray);
        this.tokenIdx = 0;
        SQLToken sQLToken = this.nextToken(COMMANDS);
        switch (sQLToken.value) {
            case 200: {
                return this.select();
            }
            case 201: {
                return this.delete();
            }
            case 1107: {
                return this.insert();
            }
            case 204: {
                return this.update();
            }
            case 205: {
                return this.create();
            }
            case 206: {
                return this.drop();
            }
            case 207: {
                return this.alter();
            }
            case 208: {
                return this.set();
            }
            case 228: {
                sQLToken = this.nextToken(MISSING_EXPRESSION);
                String string = sQLToken.getName(cArray);
                this.checkValidIdentifier(string, sQLToken);
                CommandSet commandSet = new CommandSet(this.con.log, 228);
                commandSet.name = string;
                return commandSet;
            }
            case 209: {
                return this.execute();
            }
            case 1023: {
                return this.truncate();
            }
        }
        throw new Error();
    }

    Expression parseExpression(String string) throws SQLException {
        this.sql = string.toCharArray();
        this.tokens = SQLTokenizer.parseSQL(this.sql);
        this.tokenIdx = 0;
        return this.expression(null, 0);
    }

    private SQLException createSyntaxError(SQLToken sQLToken, String string) {
        String string2 = this.getErrorString(sQLToken, string, null);
        return SmallSQLException.create("SS-0000", string2);
    }

    private SQLException createSyntaxError(SQLToken sQLToken, String string, Object object) {
        String string2 = this.getErrorString(sQLToken, string, object);
        return SmallSQLException.create("SS-0000", string2);
    }

    private SQLException createSyntaxError(SQLToken sQLToken, int[] nArray) {
        String string = SmallSQLException.translateMsg("SS-0621", new Object[0]);
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < nArray.length; ++i) {
            String string2 = SQLTokenizer.getKeyWord(nArray[i]);
            if (string2 == null) {
                string2 = String.valueOf((char)nArray[i]);
            }
            stringBuffer.append(string2);
            if (i < nArray.length - 2) {
                stringBuffer.append(", ");
                continue;
            }
            if (i != nArray.length - 2) continue;
            stringBuffer.append(" or ");
        }
        String string3 = this.getErrorString(sQLToken, "SS-0000", stringBuffer);
        return SmallSQLException.create("SS-0000", string3);
    }

    private String getErrorString(SQLToken sQLToken, String string, Object object) {
        int n;
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (sQLToken != null) {
            objectArray = new Object[]{String.valueOf(sQLToken.offset), String.valueOf(this.sql, sQLToken.offset, sQLToken.length)};
            String string2 = SmallSQLException.translateMsg("SS-0610", objectArray);
            stringBuffer.append(string2);
        } else {
            objectArray = SmallSQLException.translateMsg("SS-0611", new Object[0]);
            stringBuffer.append((String)objectArray);
        }
        objectArray = SmallSQLException.translateMsg(string, new Object[]{object});
        stringBuffer.append((String)objectArray);
        int n2 = sQLToken != null ? sQLToken.offset : this.sql.length;
        int n3 = Math.min(n2 + 20, this.sql.length);
        String string3 = System.getProperty("line.separator");
        stringBuffer.append(string3);
        stringBuffer.append(this.sql, n, n3 - n);
        stringBuffer.append(string3);
        for (n = Math.max(0, n2 - 40); n < n2; ++n) {
            stringBuffer.append(' ');
        }
        stringBuffer.append('^');
        return stringBuffer.toString();
    }

    private void checkValidIdentifier(String string, SQLToken sQLToken) throws SQLException {
        if (sQLToken.value == 42) {
            return;
        }
        if (sQLToken.value != 0 && sQLToken.value != 4 && sQLToken.value < 200) {
            throw this.createSyntaxError(sQLToken, "SS-0613");
        }
        if (string.length() == 0) {
            throw this.createSyntaxError(sQLToken, "SS-0614", string);
        }
        char c = string.charAt(0);
        if (c != '#' && c < '@') {
            throw this.createSyntaxError(sQLToken, "SS-0615", string);
        }
    }

    private String getIdentifier(SQLToken sQLToken) throws SQLException {
        String string = sQLToken.getName(this.sql);
        this.checkValidIdentifier(string, sQLToken);
        return string;
    }

    private String nextIdentifier() throws SQLException {
        return this.getIdentifier(this.nextToken(MISSING_IDENTIFIER));
    }

    private String nextIdentiferPart(String string) throws SQLException {
        SQLToken sQLToken = this.nextToken();
        if (sQLToken != null && sQLToken.value == 46) {
            return this.nextIdentifier();
        }
        this.previousToken();
        return string;
    }

    private final boolean isKeyword(SQLToken sQLToken) {
        if (sQLToken == null) {
            return false;
        }
        switch (sQLToken.value) {
            case 44: 
            case 200: 
            case 204: 
            case 208: 
            case 210: 
            case 211: 
            case 212: 
            case 214: 
            case 215: 
            case 223: 
            case 231: 
            case 260: 
            case 1107: {
                return true;
            }
        }
        return false;
    }

    private SQLToken lastToken() {
        if (this.tokenIdx > this.tokens.size()) {
            return null;
        }
        return (SQLToken)this.tokens.get(this.tokenIdx - 1);
    }

    private void previousToken() {
        --this.tokenIdx;
    }

    private SQLToken nextToken() {
        if (this.tokenIdx >= this.tokens.size()) {
            ++this.tokenIdx;
            return null;
        }
        return (SQLToken)this.tokens.get(this.tokenIdx++);
    }

    private SQLToken nextToken(int[] nArray) throws SQLException {
        SQLToken sQLToken = this.nextToken();
        if (sQLToken == null) {
            throw this.createSyntaxError(sQLToken, nArray);
        }
        if (nArray == MISSING_EXPRESSION) {
            return sQLToken;
        }
        if (nArray == MISSING_IDENTIFIER) {
            switch (sQLToken.value) {
                case 40: 
                case 41: 
                case 44: {
                    throw this.createSyntaxError(sQLToken, nArray);
                }
            }
            return sQLToken;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (sQLToken.value != nArray[i]) continue;
            return sQLToken;
        }
        throw this.createSyntaxError(sQLToken, nArray);
    }

    private CommandSelect singleSelect() throws SQLException {
        SQLToken sQLToken;
        CommandSelect commandSelect = new CommandSelect(this.con.log);
        block11: while (true) {
            sQLToken = this.nextToken(MISSING_EXPRESSION);
            switch (sQLToken.value) {
                case 229: {
                    sQLToken = this.nextToken(MISSING_EXPRESSION);
                    try {
                        int n = Integer.parseInt(sQLToken.getName(this.sql));
                        commandSelect.setMaxRows(n);
                        continue block11;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.createSyntaxError(sQLToken, "SS-0622", sQLToken.getName(this.sql));
                    }
                }
                case 261: {
                    commandSelect.setDistinct(false);
                    continue block11;
                }
                case 262: {
                    commandSelect.setDistinct(true);
                    continue block11;
                }
            }
            break;
        }
        this.previousToken();
        block12: while (true) {
            Expression expression = this.expression(commandSelect, 0);
            commandSelect.addColumnExpression(expression);
            sQLToken = this.nextToken();
            if (sQLToken == null) {
                return commandSelect;
            }
            boolean bl = false;
            if (sQLToken.value == 219) {
                sQLToken = this.nextToken(MISSING_EXPRESSION);
                bl = true;
            }
            if (bl || !this.isKeyword(sQLToken)) {
                String string = this.getIdentifier(sQLToken);
                expression.setAlias(string);
                sQLToken = this.nextToken();
                if (sQLToken == null) {
                    return commandSelect;
                }
            }
            switch (sQLToken.value) {
                case 44: {
                    if (expression == null) {
                        throw this.createSyntaxError(sQLToken, MISSING_EXPRESSION);
                    }
                    expression = null;
                    continue block12;
                }
                case 210: {
                    if (expression == null) {
                        throw this.createSyntaxError(sQLToken, MISSING_EXPRESSION);
                    }
                    expression = null;
                    this.from(commandSelect);
                    return commandSelect;
                }
            }
            break;
        }
        if (!this.isKeyword(sQLToken)) {
            throw this.createSyntaxError(sQLToken, new int[]{44, 210});
        }
        this.previousToken();
        return commandSelect;
    }

    private final CommandSelect select() throws SQLException {
        CommandSelect commandSelect = this.singleSelect();
        SQLToken sQLToken = this.nextToken();
        UnionAll unionAll = null;
        while (sQLToken != null && sQLToken.value == 260) {
            if (unionAll == null) {
                unionAll = new UnionAll();
                unionAll.addDataSource(new ViewResult(this.con, commandSelect));
                commandSelect = new CommandSelect(this.con.log);
                commandSelect.setSource(unionAll);
                DataSources dataSources = new DataSources();
                dataSources.add(unionAll);
                commandSelect.setTables(dataSources);
                commandSelect.addColumnExpression(new ExpressionName("*"));
            }
            this.nextToken(MISSING_ALL);
            this.nextToken(MISSING_SELECT);
            unionAll.addDataSource(new ViewResult(this.con, this.singleSelect()));
            sQLToken = this.nextToken();
        }
        if (sQLToken != null && sQLToken.value == 215) {
            this.order(commandSelect);
            sQLToken = this.nextToken();
        }
        if (sQLToken != null && sQLToken.value == 231) {
            this.limit(commandSelect);
            sQLToken = this.nextToken();
        }
        this.previousToken();
        return commandSelect;
    }

    private Command delete() throws SQLException {
        CommandDelete commandDelete = new CommandDelete(this.con.log);
        this.nextToken(MISSING_FROM);
        this.from(commandDelete);
        SQLToken sQLToken = this.nextToken();
        if (sQLToken != null) {
            if (sQLToken.value != 211) {
                throw this.createSyntaxError(sQLToken, MISSING_WHERE);
            }
            this.where(commandDelete);
        }
        return commandDelete;
    }

    private Command truncate() throws SQLException {
        CommandDelete commandDelete = new CommandDelete(this.con.log);
        this.nextToken(MISSING_TABLE);
        this.from(commandDelete);
        return commandDelete;
    }

    private Command insert() throws SQLException {
        SQLToken sQLToken = this.nextToken(MISSING_INTO);
        CommandInsert commandInsert = new CommandInsert(this.con.log, this.nextIdentifier());
        int n = 0;
        sQLToken = this.nextToken(MISSING_PARENTHESIS_VALUES_SELECT);
        if (sQLToken.value == 40) {
            sQLToken = this.nextToken(MISSING_EXPRESSION);
            if (sQLToken.value == 200) {
                ++n;
                commandInsert.noColumns = true;
            } else {
                this.previousToken();
                Expressions expressions = this.expressionParenthesisList(commandInsert);
                for (int i = 0; i < expressions.size(); ++i) {
                    commandInsert.addColumnExpression(expressions.get(i));
                }
                sQLToken = this.nextToken(MISSING_PARENTHESIS_VALUES_SELECT);
            }
        } else {
            commandInsert.noColumns = true;
        }
        block6: while (true) {
            switch (sQLToken.value) {
                case 218: {
                    sQLToken = this.nextToken(MISSING_PARENTHESIS_L);
                    commandInsert.addValues(this.expressionParenthesisList(commandInsert));
                    return commandInsert;
                }
                case 200: {
                    commandInsert.addValues(this.select());
                    while (n-- > 0) {
                        this.nextToken(MISSING_PARENTHESIS_R);
                    }
                    return commandInsert;
                }
                case 40: {
                    sQLToken = this.nextToken(MISSING_PARENTHESIS_VALUES_SELECT);
                    ++n;
                    continue block6;
                }
            }
            break;
        }
        throw new Error();
    }

    private Command update() throws SQLException {
        CommandUpdate commandUpdate;
        block6: {
            commandUpdate = new CommandUpdate(this.con.log);
            DataSources dataSources = new DataSources();
            commandUpdate.setTables(dataSources);
            commandUpdate.setSource(this.rowSource(commandUpdate, dataSources, 0));
            SQLToken sQLToken = this.nextToken(MISSING_SET);
            block4: while (true) {
                Expression expression;
                if ((expression = this.expressionSingle(commandUpdate, sQLToken = this.nextToken())).getType() != 2) {
                    throw this.createSyntaxError(sQLToken, MISSING_IDENTIFIER);
                }
                this.nextToken(MISSING_EQUALS);
                Expression expression2 = this.expression(commandUpdate, 0);
                commandUpdate.addSetting(expression, expression2);
                sQLToken = this.nextToken();
                if (sQLToken == null) break block6;
                switch (sQLToken.value) {
                    case 211: {
                        this.where(commandUpdate);
                        return commandUpdate;
                    }
                    case 44: {
                        continue block4;
                    }
                }
                break;
            }
            throw this.createSyntaxError(sQLToken, MISSING_WHERE_COMMA);
        }
        return commandUpdate;
    }

    private Command create() throws SQLException {
        SQLToken sQLToken;
        block9: while (true) {
            sQLToken = this.nextToken(COMMANDS_CREATE);
            switch (sQLToken.value) {
                case 235: {
                    return this.createDatabase();
                }
                case 236: {
                    return this.createTable();
                }
                case 237: {
                    return this.createView();
                }
                case 238: {
                    return this.createIndex(false);
                }
                case 239: {
                    return this.createProcedure();
                }
                case 254: {
                    do {
                        sQLToken = this.nextToken(COMMANDS_CREATE_UNIQUE);
                    } while (sQLToken.value == 238);
                    return this.createIndex(true);
                }
                case 255: 
                case 256: {
                    continue block9;
                }
            }
            break;
        }
        throw this.createSyntaxError(sQLToken, COMMANDS_CREATE);
    }

    private CommandCreateDatabase createDatabase() throws SQLException {
        SQLToken sQLToken = this.nextToken();
        if (sQLToken == null) {
            throw this.createSyntaxError(sQLToken, MISSING_EXPRESSION);
        }
        return new CommandCreateDatabase(this.con.log, sQLToken.getName(this.sql));
    }

    private CommandTable createTable() throws SQLException {
        String string;
        String string2 = string = this.nextIdentifier();
        if ((string2 = this.nextIdentiferPart(string2)) == string) {
            string = null;
        }
        CommandTable commandTable = new CommandTable(this.con.log, string, string2, 205);
        SQLToken sQLToken = this.nextToken(MISSING_PARENTHESIS_L);
        block11: while (true) {
            String string3;
            sQLToken = this.nextToken(MISSING_EXPRESSION);
            if (sQLToken.value == 250) {
                string3 = this.nextIdentifier();
                sQLToken = this.nextToken(MISSING_KEYTYPE);
            } else {
                string3 = null;
            }
            switch (sQLToken.value) {
                case 251: 
                case 252: 
                case 254: {
                    IndexDescription indexDescription = this.index(commandTable, sQLToken.value, string2, string3, null);
                    if (sQLToken.value == 252) {
                        this.nextToken(MISSING_REFERENCES);
                        String string4 = this.nextIdentifier();
                        Expressions expressions = new Expressions();
                        Strings strings = new Strings();
                        this.expressionDefList(commandTable, expressions, strings);
                        IndexDescription indexDescription2 = new IndexDescription(null, string4, 254, expressions, strings);
                        ForeignKey foreignKey = new ForeignKey(string4, indexDescription2, string2, indexDescription);
                        commandTable.addForeingnKey(foreignKey);
                    } else {
                        commandTable.addIndex(indexDescription);
                    }
                    sQLToken = this.nextToken(MISSING_COMMA_PARENTHESIS);
                    switch (sQLToken.value) {
                        case 41: {
                            return commandTable;
                        }
                        case 44: {
                            continue block11;
                        }
                    }
                }
            }
            sQLToken = this.addColumn(sQLToken, commandTable);
            if (sQLToken == null) {
                throw this.createSyntaxError(sQLToken, MISSING_COMMA_PARENTHESIS);
            }
            switch (sQLToken.value) {
                case 41: {
                    return commandTable;
                }
                case 44: {
                    continue block11;
                }
            }
            break;
        }
        throw this.createSyntaxError(sQLToken, MISSING_COMMA_PARENTHESIS);
    }

    private SQLToken addColumn(SQLToken sQLToken, CommandTable commandTable) throws SQLException {
        String string = this.getIdentifier(sQLToken);
        Column column = this.datatype(false);
        column.setName(string);
        sQLToken = this.nextToken();
        boolean bl = false;
        boolean bl2 = column.isAutoIncrement();
        while (true) {
            if (sQLToken == null) {
                commandTable.addColumn(column);
                return null;
            }
            switch (sQLToken.value) {
                case 41: 
                case 44: {
                    commandTable.addColumn(column);
                    return sQLToken;
                }
                case 220: {
                    if (bl2) {
                        throw this.createSyntaxError(sQLToken, MISSING_COMMA_PARENTHESIS);
                    }
                    int n = sQLToken.offset + sQLToken.length;
                    sQLToken = this.nextToken();
                    if (sQLToken != null) {
                        n = sQLToken.offset;
                    }
                    this.previousToken();
                    Expression expression = this.expression(commandTable, 0);
                    SQLToken sQLToken2 = this.lastToken();
                    int n2 = sQLToken2.offset + sQLToken2.length - n;
                    String string2 = new String(this.sql, n, n2);
                    column.setDefaultValue(expression, string2);
                    bl2 = true;
                    break;
                }
                case 221: {
                    if (bl2) {
                        throw this.createSyntaxError(sQLToken, MISSING_COMMA_PARENTHESIS);
                    }
                    column.setAutoIncrement(true);
                    bl2 = true;
                    break;
                }
                case 504: {
                    if (bl) {
                        throw this.createSyntaxError(sQLToken, MISSING_COMMA_PARENTHESIS);
                    }
                    bl = true;
                    break;
                }
                case 503: {
                    if (bl) {
                        throw this.createSyntaxError(sQLToken, MISSING_COMMA_PARENTHESIS);
                    }
                    sQLToken = this.nextToken(MISSING_NULL);
                    column.setNullable(false);
                    bl = true;
                    break;
                }
                case 251: 
                case 254: {
                    IndexDescription indexDescription = this.index(commandTable, sQLToken.value, commandTable.name, null, string);
                    commandTable.addIndex(indexDescription);
                    break;
                }
                default: {
                    throw this.createSyntaxError(sQLToken, MISSING_OPTIONS_DATATYPE);
                }
            }
            sQLToken = this.nextToken();
        }
    }

    private IndexDescription index(Command command, int n, String string, String string2, String string3) throws SQLException {
        SQLToken sQLToken;
        if (n != 254) {
            this.nextToken(MISSING_KEY);
        }
        if ((sQLToken = this.nextToken()) != null) {
            switch (sQLToken.value) {
                case 255: 
                case 256: {
                    break;
                }
                default: {
                    this.previousToken();
                    break;
                }
            }
        } else {
            this.previousToken();
        }
        Strings strings = new Strings();
        Expressions expressions = new Expressions();
        if (string3 != null) {
            strings.add(string3);
            expressions.add(new ExpressionName(string3));
        } else {
            this.expressionDefList(command, expressions, strings);
        }
        return new IndexDescription(string2, string, n, expressions, strings);
    }

    private Column datatype(boolean bl) throws SQLException {
        int n;
        SQLToken sQLToken;
        block40: {
            block39: {
                if (!bl) break block39;
                sQLToken = this.nextToken(MISSING_SQL_DATATYPE);
                switch (sQLToken.value) {
                    case 1350: {
                        n = 325;
                        break block40;
                    }
                    case 1351: {
                        n = 310;
                        break block40;
                    }
                    case 1352: {
                        n = 300;
                        break block40;
                    }
                    case 1353: {
                        n = 350;
                        break block40;
                    }
                    case 1354: {
                        n = 340;
                        break block40;
                    }
                    case 1355: {
                        n = 332;
                        break block40;
                    }
                    case 1356: {
                        n = 338;
                        break block40;
                    }
                    case 1357: {
                        n = 337;
                        break block40;
                    }
                    case 1358: {
                        n = 323;
                        break block40;
                    }
                    case 1359: {
                        n = 313;
                        break block40;
                    }
                    case 1360: {
                        n = 359;
                        break block40;
                    }
                    case 1361: {
                        n = 336;
                        break block40;
                    }
                    case 1362: {
                        n = 322;
                        break block40;
                    }
                    case 1363: {
                        n = 341;
                        break block40;
                    }
                    case 1364: {
                        n = 342;
                        break block40;
                    }
                    case 1365: {
                        n = 321;
                        break block40;
                    }
                    case 1366: {
                        n = 311;
                        break block40;
                    }
                    case 1367: {
                        n = 353;
                        break block40;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            sQLToken = this.nextToken(MISSING_DATATYPE);
            n = sQLToken.value;
        }
        Column column = new Column();
        if (n == 361) {
            sQLToken = this.nextToken();
            if (sQLToken != null && sQLToken.value == 312) {
                n = 313;
            } else {
                n = 359;
                this.previousToken();
            }
        }
        switch (n) {
            case 312: {
                n = 311;
            }
            case 310: 
            case 311: 
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                int n2;
                sQLToken = this.nextToken();
                if (sQLToken == null || sQLToken.value != 40) {
                    n2 = 30;
                    this.previousToken();
                } else {
                    sQLToken = this.nextToken(MISSING_EXPRESSION);
                    try {
                        n2 = Integer.parseInt(sQLToken.getName(this.sql));
                    }
                    catch (Exception exception) {
                        throw this.createSyntaxError(sQLToken, MISSING_NUMBERVALUE);
                    }
                    this.nextToken(MISSING_PARENTHESIS_R);
                }
                column.setPrecision(n2);
                break;
            }
            case 357: {
                column.setPrecision(255);
                n = 353;
                break;
            }
            case 324: {
                column.setAutoIncrement(true);
                n = 323;
                break;
            }
            case 332: 
            case 333: {
                sQLToken = this.nextToken();
                if (sQLToken != null && sQLToken.value == 40) {
                    int n3;
                    sQLToken = this.nextToken(MISSING_EXPRESSION);
                    try {
                        n3 = Integer.parseInt(sQLToken.getName(this.sql));
                    }
                    catch (Exception exception) {
                        throw this.createSyntaxError(sQLToken, MISSING_NUMBERVALUE);
                    }
                    column.setPrecision(n3);
                    sQLToken = this.nextToken(MISSING_COMMA_PARENTHESIS);
                    if (sQLToken.value != 44) break;
                    sQLToken = this.nextToken(MISSING_EXPRESSION);
                    try {
                        n3 = Integer.parseInt(sQLToken.getName(this.sql));
                    }
                    catch (Exception exception) {
                        throw this.createSyntaxError(sQLToken, MISSING_NUMBERVALUE);
                    }
                    column.setScale(n3);
                    this.nextToken(MISSING_PARENTHESIS_R);
                    break;
                }
                column.setPrecision(18);
                this.previousToken();
            }
        }
        column.setDataType(n);
        return column;
    }

    private CommandCreateView createView() throws SQLException {
        String string = this.nextIdentifier();
        this.nextToken(MISSING_AS);
        SQLToken sQLToken = this.nextToken(MISSING_SELECT);
        CommandCreateView commandCreateView = new CommandCreateView(this.con.log, string);
        commandCreateView.sql = new String(this.sql, sQLToken.offset, this.sql.length - sQLToken.offset);
        this.select();
        return commandCreateView;
    }

    private CommandTable createIndex(boolean bl) throws SQLException {
        String string;
        String string2 = this.nextIdentifier();
        this.nextToken(MISSING_ON);
        String string3 = string = this.nextIdentifier();
        string3 = this.nextIdentiferPart(string3);
        if (string3 == string) {
            string = null;
        }
        CommandTable commandTable = new CommandTable(this.con.log, string, string3, 238);
        Expressions expressions = new Expressions();
        Strings strings = new Strings();
        this.expressionDefList(commandTable, expressions, strings);
        IndexDescription indexDescription = new IndexDescription(string2, string3, bl ? 254 : 238, expressions, strings);
        Object[] objectArray = new Object[]{"Create Index"};
        throw SmallSQLException.create("SS-0001", objectArray);
    }

    private CommandCreateDatabase createProcedure() throws SQLException {
        Object[] objectArray = new Object[]{"Create Procedure"};
        throw SmallSQLException.create("SS-0001", objectArray);
    }

    private Command drop() throws SQLException {
        String string;
        SQLToken sQLToken = this.nextToken(COMMANDS_DROP);
        String string2 = string = this.nextIdentifier();
        if ((string2 = this.nextIdentiferPart(string2)) == string) {
            string = null;
        }
        switch (sQLToken.value) {
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                return new CommandDrop(this.con.log, string, string2, sQLToken.value);
            }
        }
        throw this.createSyntaxError(sQLToken, COMMANDS_DROP);
    }

    private Command alter() throws SQLException {
        String string;
        SQLToken sQLToken = this.nextToken(COMMANDS_ALTER);
        String string2 = string = this.nextIdentifier();
        switch (sQLToken.value) {
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                string2 = this.nextIdentiferPart(string2);
                if (string2 != string) break;
                string = null;
            }
        }
        switch (sQLToken.value) {
            case 236: {
                return this.alterTable(string, string2);
            }
        }
        Object[] objectArray = new Object[]{"ALTER " + sQLToken.getName(this.sql)};
        throw SmallSQLException.create("SS-0001", objectArray);
    }

    Command alterTable(String string, String string2) throws SQLException {
        SQLToken sQLToken = this.nextToken(MISSING_ADD_ALTER_DROP);
        CommandTable commandTable = new CommandTable(this.con.log, string, string2, sQLToken.value);
        switch (sQLToken.value) {
            case 230: {
                SQLToken sQLToken2;
                do {
                    sQLToken2 = this.nextToken(MISSING_IDENTIFIER);
                } while ((sQLToken2 = this.addColumn(sQLToken2, commandTable)) != null && sQLToken2.value == 44);
                return commandTable;
            }
        }
        Object[] objectArray = new Object[]{"ALTER TABLE " + sQLToken.getName(this.sql)};
        throw SmallSQLException.create("SS-0001", objectArray);
    }

    private CommandSet set() throws SQLException {
        SQLToken sQLToken = this.nextToken(COMMANDS_SET);
        switch (sQLToken.value) {
            case 240: {
                return this.setTransaction();
            }
        }
        throw new Error();
    }

    private CommandSet setTransaction() throws SQLException {
        SQLToken sQLToken = this.nextToken(MISSING_ISOLATION);
        sQLToken = this.nextToken(MISSING_LEVEL);
        sQLToken = this.nextToken(COMMANDS_TRANS_LEVEL);
        CommandSet commandSet = new CommandSet(this.con.log, 242);
        switch (sQLToken.value) {
            case 243: {
                sQLToken = this.nextToken(MISSING_COMM_UNCOMM);
                switch (sQLToken.value) {
                    case 244: {
                        commandSet.isolationLevel = 2;
                        break;
                    }
                    case 245: {
                        commandSet.isolationLevel = 1;
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
                return commandSet;
            }
            case 246: {
                sQLToken = this.nextToken(MISSING_READ);
                commandSet.isolationLevel = 4;
                return commandSet;
            }
            case 247: {
                commandSet.isolationLevel = 8;
                return commandSet;
            }
        }
        throw new Error();
    }

    private Command execute() throws SQLException {
        throw SmallSQLException.create("SS-0001", "Execute");
    }

    private Expressions expressionParenthesisList(Command command) throws SQLException {
        Expressions expressions = new Expressions();
        SQLToken sQLToken = this.nextToken();
        if (sQLToken != null && sQLToken.value == 41) {
            return expressions;
        }
        this.previousToken();
        block4: while (true) {
            expressions.add(this.expression(command, 0));
            sQLToken = this.nextToken(MISSING_COMMA_PARENTHESIS);
            switch (sQLToken.value) {
                case 41: {
                    return expressions;
                }
                case 44: {
                    continue block4;
                }
            }
            break;
        }
        throw new Error();
    }

    private Expressions expressionTokenList(Command command, int n) throws SQLException {
        SQLToken sQLToken;
        Expressions expressions = new Expressions();
        block7: while (true) {
            Expression expression = this.expression(command, 0);
            expressions.add(expression);
            sQLToken = this.nextToken();
            if (n == 215 && sQLToken != null) {
                switch (sQLToken.value) {
                    case 217: {
                        expression.setAlias("DESC");
                    }
                    case 216: {
                        sQLToken = this.nextToken();
                    }
                }
            }
            if (sQLToken == null) {
                this.previousToken();
                return expressions;
            }
            switch (sQLToken.value) {
                case 44: {
                    continue block7;
                }
            }
            break;
        }
        if (this.isKeyword(sQLToken)) {
            this.previousToken();
            return expressions;
        }
        throw this.createSyntaxError(sQLToken, MISSING_TOKEN_LIST);
    }

    private void expressionDefList(Command command, Expressions expressions, Strings strings) throws SQLException {
        SQLToken sQLToken = this.nextToken();
        if (sQLToken.value != 40) {
            throw this.createSyntaxError(sQLToken, MISSING_PARENTHESIS_L);
        }
        block4: while (true) {
            int n = sQLToken.offset + sQLToken.length;
            sQLToken = this.nextToken();
            if (sQLToken != null) {
                n = sQLToken.offset;
            }
            this.previousToken();
            expressions.add(this.expression(command, 0));
            SQLToken sQLToken2 = this.lastToken();
            int n2 = sQLToken2.offset + sQLToken2.length - n;
            strings.add(new String(this.sql, n, n2));
            sQLToken = this.nextToken(MISSING_COMMA_PARENTHESIS);
            switch (sQLToken.value) {
                case 41: {
                    break block4;
                }
                case 44: {
                    continue block4;
                }
                default: {
                    throw new Error();
                }
            }
            break;
        }
    }

    private Expression expression(Command command, int n) throws SQLException {
        Expression expression;
        SQLToken sQLToken = this.nextToken(MISSING_EXPRESSION);
        switch (sQLToken.value) {
            case 503: {
                expression = new ExpressionArithmetic(this.expression(command, 3), 31);
                break;
            }
            case 45: {
                expression = new ExpressionArithmetic(this.expression(command, 10), 101);
                break;
            }
            case 126: {
                expression = new ExpressionArithmetic(this.expression(command, 9), 91);
                break;
            }
            case 40: {
                expression = this.expression(command, 0);
                sQLToken = this.nextToken(MISSING_PARENTHESIS_R);
                break;
            }
            default: {
                expression = this.expressionSingle(command, sQLToken);
            }
        }
        boolean bl = false;
        block13: while ((sQLToken = this.nextToken()) != null) {
            int n2 = ExpressionArithmetic.getOperationFromToken(sQLToken.value);
            int n3 = n2 / 10;
            if (n >= n3) {
                this.previousToken();
                return expression;
            }
            switch (sQLToken.value) {
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 45: 
                case 47: 
                case 60: 
                case 61: 
                case 62: 
                case 94: 
                case 124: 
                case 160: 
                case 161: 
                case 162: 
                case 500: 
                case 501: 
                case 508: {
                    Expression expression2 = this.expression(command, n3);
                    expression = new ExpressionArithmetic(expression, expression2, n2);
                    break;
                }
                case 507: {
                    Expression expression2 = this.expression(command, 21);
                    this.nextToken(MISSING_AND);
                    Expression expression3 = this.expression(command, n3);
                    expression = new ExpressionArithmetic(expression, expression2, expression3, n2);
                    break;
                }
                case 509: {
                    Object object;
                    this.nextToken(MISSING_PARENTHESIS_L);
                    sQLToken = this.nextToken(MISSING_EXPRESSION);
                    if (sQLToken.value == 200) {
                        object = this.select();
                        expression = new ExpressionInSelect(this.con, expression, (CommandSelect)object, n2);
                        this.nextToken(MISSING_PARENTHESIS_R);
                        break;
                    }
                    this.previousToken();
                    object = this.expressionParenthesisList(command);
                    expression = new ExpressionArithmetic(expression, (Expressions)object, n2);
                    break;
                }
                case 502: {
                    sQLToken = this.nextToken(MISSING_NOT_NULL);
                    if (sQLToken.value == 503) {
                        this.nextToken(MISSING_NULL);
                        ++n2;
                    }
                    expression = new ExpressionArithmetic(expression, n2);
                    break;
                }
                case 503: {
                    sQLToken = this.nextToken(MISSING_BETWEEN_IN);
                    this.previousToken();
                    bl = true;
                    continue block13;
                }
                default: {
                    this.previousToken();
                    return expression;
                }
            }
            if (!bl) continue;
            bl = false;
            expression = new ExpressionArithmetic(expression, 31);
        }
        this.previousToken();
        return expression;
    }

    private Expression expressionSingle(Command command, SQLToken sQLToken) throws SQLException {
        boolean bl = false;
        if (sQLToken != null) {
            switch (sQLToken.value) {
                case 504: {
                    return new ExpressionValue(null, 504);
                }
                case 3: {
                    return new ExpressionValue(sQLToken.getName(null), 353);
                }
                case 4: {
                    String string = this.getIdentifier(sQLToken);
                    ExpressionName expressionName = new ExpressionName(string);
                    SQLToken sQLToken2 = this.nextToken();
                    if (sQLToken2 != null && sQLToken2.value == 46) {
                        expressionName.setNameAfterTableAlias(this.nextIdentifier());
                    } else {
                        this.previousToken();
                    }
                    return expressionName;
                }
                case 505: {
                    return new ExpressionValue(Boolean.TRUE, 301);
                }
                case 506: {
                    return new ExpressionValue(Boolean.FALSE, 301);
                }
                case 123: {
                    Expression expression;
                    sQLToken = this.nextToken(COMMANDS_ESCAPE);
                    SQLToken sQLToken3 = this.nextToken(MISSING_EXPRESSION);
                    switch (sQLToken.value) {
                        case 400: {
                            expression = new ExpressionValue(DateTime.valueOf(sQLToken3.getName(this.sql), 340), 340);
                            break;
                        }
                        case 401: {
                            expression = new ExpressionValue(DateTime.valueOf(sQLToken3.getName(this.sql), 341), 341);
                            break;
                        }
                        case 402: {
                            expression = new ExpressionValue(DateTime.valueOf(sQLToken3.getName(this.sql), 342), 342);
                            break;
                        }
                        case 403: {
                            this.nextToken(MISSING_PARENTHESIS_L);
                            expression = this.function(command, sQLToken3, true);
                            break;
                        }
                        case 404: {
                            throw new UnsupportedOperationException("call escape sequence");
                        }
                        default: {
                            throw new Error();
                        }
                    }
                    sQLToken = this.nextToken(ESCAPE_MISSING_CLOSE);
                    return expression;
                }
                case 63: {
                    ExpressionValue expressionValue = new ExpressionValue();
                    command.addParameter(expressionValue);
                    return expressionValue;
                }
                case 263: {
                    return this.caseExpr(command);
                }
                case 43: 
                case 45: {
                    do {
                        if (sQLToken.value == 45) {
                            boolean bl2 = bl = !bl;
                        }
                        if ((sQLToken = this.nextToken()) != null) continue;
                        throw this.createSyntaxError(sQLToken, MISSING_EXPRESSION);
                    } while (sQLToken.value == 45 || sQLToken.value == 43);
                }
            }
            SQLToken sQLToken4 = this.nextToken();
            if (sQLToken4 != null && sQLToken4.value == 40) {
                if (bl) {
                    return new ExpressionArithmetic(this.function(command, sQLToken, false), 101);
                }
                return this.function(command, sQLToken, false);
            }
            char c = this.sql[sQLToken.offset];
            if (c == '$') {
                this.previousToken();
                String string = new String(this.sql, sQLToken.offset + 1, sQLToken.length - 1);
                if (bl) {
                    string = "-" + string;
                }
                return new ExpressionValue(new Money(Double.parseDouble(string)), 331);
            }
            String string = new String(this.sql, sQLToken.offset, sQLToken.length);
            if (c >= '0' && '9' >= c || c == '.') {
                this.previousToken();
                if (sQLToken.length > 1 && (this.sql[sQLToken.offset + 1] | 0x20) == 120) {
                    if (bl) {
                        throw this.createSyntaxError(sQLToken, "SS-0616");
                    }
                    return new ExpressionValue(Utils.hex2bytes(this.sql, sQLToken.offset + 2, sQLToken.length - 2), 311);
                }
                if (bl) {
                    string = "-" + string;
                }
                if (Utils.indexOf('.', this.sql, sQLToken.offset, sQLToken.length) >= 0 || Utils.indexOf('e', this.sql, sQLToken.offset, sQLToken.length) >= 0) {
                    return new ExpressionValue(new Double(string), 338);
                }
                try {
                    return new ExpressionValue(new Integer(string), 323);
                }
                catch (NumberFormatException numberFormatException) {
                    return new ExpressionValue(new Long(string), 325);
                }
            }
            this.checkValidIdentifier(string, sQLToken);
            ExpressionName expressionName = new ExpressionName(string);
            if (sQLToken4 != null && sQLToken4.value == 46) {
                expressionName.setNameAfterTableAlias(this.nextIdentifier());
            } else {
                this.previousToken();
            }
            if (bl) {
                return new ExpressionArithmetic(expressionName, 101);
            }
            return expressionName;
        }
        return null;
    }

    ExpressionFunctionCase caseExpr(Command command) throws SQLException {
        ExpressionFunctionCase expressionFunctionCase = new ExpressionFunctionCase();
        SQLToken sQLToken = this.nextToken(MISSING_EXPRESSION);
        Expression expression = null;
        if (sQLToken.value != 264) {
            this.previousToken();
            expression = this.expression(command, 0);
            sQLToken = this.nextToken(MISSING_WHEN_ELSE_END);
        }
        while (true) {
            switch (sQLToken.value) {
                case 264: {
                    Expression expression2 = this.expression(command, 0);
                    if (expression != null) {
                        expression2 = new ExpressionArithmetic(expression, expression2, 51);
                    }
                    this.nextToken(MISSING_THEN);
                    Expression expression3 = this.expression(command, 0);
                    expressionFunctionCase.addCase(expression2, expression3);
                    break;
                }
                case 266: {
                    expressionFunctionCase.setElseResult(this.expression(command, 0));
                    break;
                }
                case 267: {
                    expressionFunctionCase.setEnd();
                    return expressionFunctionCase;
                }
                default: {
                    throw new Error();
                }
            }
            sQLToken = this.nextToken(MISSING_WHEN_ELSE_END);
        }
    }

    private Expression function(Command command, SQLToken sQLToken, boolean bl) throws SQLException {
        Expression expression;
        boolean bl2;
        switch (sQLToken.value) {
            case 1303: {
                Column column;
                Expression expression2;
                Expression expression3 = null;
                if (bl) {
                    expression2 = this.expression(command, 0);
                    this.nextToken(MISSING_COMMA);
                    column = this.datatype(bl);
                } else {
                    column = this.datatype(bl);
                    this.nextToken(MISSING_COMMA);
                    expression2 = this.expression(command, 0);
                    sQLToken = this.nextToken(MISSING_COMMA_PARENTHESIS);
                    if (sQLToken.value == 44) {
                        expression3 = this.expression(command, 0);
                    } else {
                        this.previousToken();
                    }
                }
                this.nextToken(MISSING_PARENTHESIS_R);
                return new ExpressionFunctionConvert(column, expression2, expression3);
            }
            case 1304: {
                Expression expression4 = this.expression(command, 0);
                this.nextToken(MISSING_AS);
                Column column = this.datatype(false);
                this.nextToken(MISSING_PARENTHESIS_R);
                return new ExpressionFunctionConvert(column, expression4, null);
            }
            case 1217: {
                sQLToken = this.nextToken(MISSING_INTERVALS);
                this.nextToken(MISSING_COMMA);
                Expression expression5 = this.expression(command, 0);
                this.nextToken(MISSING_COMMA);
                expression5 = new ExpressionFunctionTimestampDiff(sQLToken.value, expression5, this.expression(command, 0));
                this.nextToken(MISSING_PARENTHESIS_R);
                return expression5;
            }
            case 1216: {
                sQLToken = this.nextToken(MISSING_INTERVALS);
                this.nextToken(MISSING_COMMA);
                Expression expression6 = this.expression(command, 0);
                this.nextToken(MISSING_COMMA);
                expression6 = new ExpressionFunctionTimestampAdd(sQLToken.value, expression6, this.expression(command, 0));
                this.nextToken(MISSING_PARENTHESIS_R);
                return expression6;
            }
        }
        Expressions expressions = this.expressionParenthesisList(command);
        int n = expressions.size();
        Expression[] expressionArray = expressions.toArray();
        block6 : switch (sQLToken.value) {
            case 1000: {
                bl2 = n != 1;
                expression = new ExpressionFunctionAbs();
                break;
            }
            case 1001: {
                bl2 = n != 1;
                expression = new ExpressionFunctionACos();
                break;
            }
            case 1002: {
                bl2 = n != 1;
                expression = new ExpressionFunctionASin();
                break;
            }
            case 1003: {
                bl2 = n != 1;
                expression = new ExpressionFunctionATan();
                break;
            }
            case 1004: {
                bl2 = n != 2;
                expression = new ExpressionFunctionATan2();
                break;
            }
            case 1005: {
                bl2 = n != 1;
                expression = new ExpressionFunctionCeiling();
                break;
            }
            case 1006: {
                bl2 = n != 1;
                expression = new ExpressionFunctionCos();
                break;
            }
            case 1007: {
                bl2 = n != 1;
                expression = new ExpressionFunctionCot();
                break;
            }
            case 1008: {
                bl2 = n != 1;
                expression = new ExpressionFunctionDegrees();
                break;
            }
            case 1009: {
                bl2 = n != 1;
                expression = new ExpressionFunctionExp();
                break;
            }
            case 1010: {
                bl2 = n != 1;
                expression = new ExpressionFunctionFloor();
                break;
            }
            case 1011: {
                bl2 = n != 1;
                expression = new ExpressionFunctionLog();
                break;
            }
            case 1012: {
                bl2 = n != 1;
                expression = new ExpressionFunctionLog10();
                break;
            }
            case 1013: {
                bl2 = n != 2;
                expression = new ExpressionFunctionMod();
                break;
            }
            case 1014: {
                bl2 = n != 0;
                expression = new ExpressionFunctionPI();
                break;
            }
            case 1015: {
                bl2 = n != 2;
                expression = new ExpressionFunctionPower();
                break;
            }
            case 1016: {
                bl2 = n != 1;
                expression = new ExpressionFunctionRadians();
                break;
            }
            case 1017: {
                bl2 = n != 0 && n != 1;
                expression = new ExpressionFunctionRand();
                break;
            }
            case 1018: {
                bl2 = n != 2;
                expression = new ExpressionFunctionRound();
                break;
            }
            case 1020: {
                bl2 = n != 1;
                expression = new ExpressionFunctionSin();
                break;
            }
            case 1019: {
                bl2 = n != 1;
                expression = new ExpressionFunctionSign();
                break;
            }
            case 1021: {
                bl2 = n != 1;
                expression = new ExpressionFunctionSqrt();
                break;
            }
            case 1022: {
                bl2 = n != 1;
                expression = new ExpressionFunctionTan();
                break;
            }
            case 1023: {
                bl2 = n != 2;
                expression = new ExpressionFunctionTruncate();
                break;
            }
            case 1100: {
                bl2 = n != 1;
                expression = new ExpressionFunctionAscii();
                break;
            }
            case 1101: {
                bl2 = n != 1;
                expression = new ExpressionFunctionBitLen();
                break;
            }
            case 1102: 
            case 1103: {
                bl2 = n != 1;
                expression = new ExpressionFunctionCharLen();
                break;
            }
            case 350: {
                bl2 = n != 1;
                expression = new ExpressionFunctionChar();
                break;
            }
            case 1105: {
                if (n != 2) {
                    bl2 = true;
                    expression = null;
                    break;
                }
                bl2 = false;
                expression = new ExpressionArithmetic(expressionArray[0], expressionArray[1], 71);
                break;
            }
            case 1106: {
                bl2 = n != 2;
                expression = new ExpressionFunctionDifference();
                break;
            }
            case 1107: {
                bl2 = n != 4;
                expression = new ExpressionFunctionInsert();
                break;
            }
            case 1108: {
                bl2 = n != 1;
                expression = new ExpressionFunctionLCase();
                break;
            }
            case 1109: {
                bl2 = n != 2;
                expression = new ExpressionFunctionLeft();
                break;
            }
            case 1110: {
                bl2 = n != 1;
                expression = new ExpressionFunctionLength();
                break;
            }
            case 1111: {
                bl2 = n != 2 && n != 3;
                expression = new ExpressionFunctionLocate();
                break;
            }
            case 1112: {
                bl2 = n != 1;
                expression = new ExpressionFunctionLTrim();
                break;
            }
            case 1113: {
                bl2 = n != 1;
                expression = new ExpressionFunctionOctetLen();
                break;
            }
            case 1114: {
                bl2 = n != 2;
                expression = new ExpressionFunctionRepeat();
                break;
            }
            case 1115: {
                bl2 = n != 3;
                expression = new ExpressionFunctionReplace();
                break;
            }
            case 1116: {
                bl2 = n != 2;
                expression = new ExpressionFunctionRight();
                break;
            }
            case 1117: {
                bl2 = n != 1;
                expression = new ExpressionFunctionRTrim();
                break;
            }
            case 1119: {
                bl2 = n != 1;
                expression = new ExpressionFunctionSpace();
                break;
            }
            case 1118: {
                bl2 = n != 1;
                expression = new ExpressionFunctionSoundex();
                break;
            }
            case 1120: {
                bl2 = n != 3;
                expression = new ExpressionFunctionSubstring();
                break;
            }
            case 1122: {
                bl2 = n != 1;
                expression = new ExpressionFunctionUCase();
                break;
            }
            case 1200: 
            case 1201: {
                bl2 = n != 0;
                expression = new ExpressionValue(new DateTime(DateTime.now(), 340), 340);
                break;
            }
            case 1202: {
                bl2 = n != 0;
                expression = new ExpressionValue(new DateTime(DateTime.now(), 341), 341);
                break;
            }
            case 1204: {
                bl2 = n != 1;
                expression = new ExpressionFunctionDayOfMonth();
                break;
            }
            case 1205: {
                bl2 = n != 1;
                expression = new ExpressionFunctionDayOfWeek();
                break;
            }
            case 1206: {
                bl2 = n != 1;
                expression = new ExpressionFunctionDayOfYear();
                break;
            }
            case 1208: {
                bl2 = n != 1;
                expression = new ExpressionFunctionHour();
                break;
            }
            case 1210: {
                bl2 = n != 1;
                expression = new ExpressionFunctionMinute();
                break;
            }
            case 1211: {
                bl2 = n != 1;
                expression = new ExpressionFunctionMonth();
                break;
            }
            case 1213: {
                bl2 = n != 0;
                expression = new ExpressionValue(new DateTime(DateTime.now(), 342), 342);
                break;
            }
            case 1219: {
                bl2 = n != 1;
                expression = new ExpressionFunctionYear();
                break;
            }
            case 1305: {
                bl2 = n != 3;
                expression = new ExpressionFunctionIIF();
                break;
            }
            case 268: {
                bl2 = n % 2 != 0;
                ExpressionFunctionCase expressionFunctionCase = new ExpressionFunctionCase();
                for (int i = 0; i < n - 1; i += 2) {
                    expressionFunctionCase.addCase(expressionArray[i], expressionArray[i + 1]);
                }
                expressionFunctionCase.setEnd();
                expression = expressionFunctionCase;
                break;
            }
            case 1301: {
                switch (n) {
                    case 1: {
                        return new ExpressionArithmetic(expressionArray[0], 64);
                    }
                    case 2: {
                        bl2 = false;
                        expression = new ExpressionFunctionIIF();
                        Expression[] expressionArray2 = new Expression[]{new ExpressionArithmetic(expressionArray[0], 64), expressionArray[1], expressionArray[0]};
                        expressionArray = expressionArray2;
                        n = 3;
                        break block6;
                    }
                }
                bl2 = true;
                expression = null;
                break;
            }
            case 1400: {
                ExpressionName expressionName;
                boolean bl3 = bl2 = n != 1;
                if (expressionArray[0].getType() == 2 && "*".equals((expressionName = (ExpressionName)expressionArray[0]).getName()) && expressionName.getTableAlias() == null) {
                    expressionArray[0] = new ExpressionValue("*", 353);
                }
                expression = new ExpressionName(12);
                break;
            }
            case 1403: {
                bl2 = n != 1;
                expression = new ExpressionName(13);
                break;
            }
            case 1402: {
                bl2 = n != 1;
                expression = new ExpressionName(17);
                break;
            }
            case 1401: {
                bl2 = n != 1;
                expression = new ExpressionName(16);
                break;
            }
            case 1404: {
                bl2 = n != 1;
                expression = new ExpressionName(14);
                break;
            }
            case 1405: {
                bl2 = n != 1;
                expression = new ExpressionName(15);
                break;
            }
            case 1406: {
                if (n != 1) {
                    bl2 = true;
                    expression = null;
                    break;
                }
                Expression expression7 = new ExpressionName(13);
                expression7.setParams(expressionArray);
                ExpressionName expressionName = new ExpressionName(12);
                expressionName.setParams(expressionArray);
                expression7 = new ExpressionArithmetic(expression7, expressionName, 82);
                return expression7;
            }
            default: {
                throw this.createSyntaxError(sQLToken, "SS-0617");
            }
        }
        if (bl2) {
            throw this.createSyntaxError(sQLToken, "SS-0618");
        }
        ((Expression)expression).setParams(expressionArray);
        return expression;
    }

    private RowSource tableSource(Command command, DataSources dataSources) throws SQLException {
        SQLToken sQLToken = this.nextToken(MISSING_EXPRESSION);
        switch (sQLToken.value) {
            case 40: {
                return this.rowSource(command, dataSources, 41);
            }
            case 123: {
                sQLToken = this.nextToken(MISSING_OJ);
                return this.rowSource(command, dataSources, 125);
            }
            case 200: {
                ViewResult viewResult = new ViewResult(this.con, this.select());
                dataSources.add(viewResult);
                return viewResult;
            }
        }
        String string = null;
        String string2 = this.getIdentifier(sQLToken);
        sQLToken = this.nextToken();
        if (sQLToken != null && sQLToken.value == 46) {
            string = string2;
            string2 = this.nextIdentifier();
            sQLToken = this.nextToken();
        }
        TableView tableView = Database.getTableView(this.con, string, string2);
        TableViewResult tableViewResult = TableViewResult.createResult(tableView);
        dataSources.add(tableViewResult);
        if (sQLToken != null && sQLToken.value == 219) {
            sQLToken = this.nextToken(MISSING_EXPRESSION);
            tableViewResult.setAlias(sQLToken.getName(this.sql));
        } else {
            this.previousToken();
        }
        return tableViewResult;
    }

    private Join join(Command command, DataSources dataSources, RowSource rowSource, int n) throws SQLException {
        RowSource rowSource2 = this.rowSource(command, dataSources, 0);
        SQLToken sQLToken = this.nextToken();
        while (true) {
            if (sQLToken == null) {
                throw this.createSyntaxError(sQLToken, "SS-0619");
            }
            switch (sQLToken.value) {
                case 224: {
                    if (n == 5) {
                        return new Join(3, rowSource2, rowSource, this.expression(command, 0));
                    }
                    return new Join(n, rowSource, rowSource2, this.expression(command, 0));
                }
            }
            if (rowSource2.hasAlias()) break;
            rowSource2.setAlias(sQLToken.getName(this.sql));
            sQLToken = this.nextToken();
        }
        throw this.createSyntaxError(sQLToken, MISSING_ON);
    }

    private RowSource rowSource(Command command, DataSources dataSources, int n) throws SQLException {
        SQLToken sQLToken;
        RowSource rowSource = null;
        rowSource = this.tableSource(command, dataSources);
        block11: while (true) {
            if ((sQLToken = this.nextToken()) == null) {
                return rowSource;
            }
            switch (sQLToken.value) {
                case 224: {
                    this.previousToken();
                    return rowSource;
                }
                case 227: {
                    this.nextToken(MISSING_JOIN);
                }
                case 44: {
                    rowSource = new Join(1, rowSource, this.rowSource(command, dataSources, 0), null);
                    continue block11;
                }
                case 222: {
                    this.nextToken(MISSING_JOIN);
                }
                case 223: {
                    rowSource = this.join(command, dataSources, rowSource, 2);
                    continue block11;
                }
                case 1109: {
                    sQLToken = this.nextToken(MISSING_OUTER_JOIN);
                    if (sQLToken.value == 225) {
                        sQLToken = this.nextToken(MISSING_JOIN);
                    }
                    rowSource = this.join(command, dataSources, rowSource, 3);
                    continue block11;
                }
                case 1116: {
                    sQLToken = this.nextToken(MISSING_OUTER_JOIN);
                    if (sQLToken.value == 225) {
                        sQLToken = this.nextToken(MISSING_JOIN);
                    }
                    rowSource = this.join(command, dataSources, rowSource, 5);
                    continue block11;
                }
                case 226: {
                    sQLToken = this.nextToken(MISSING_OUTER_JOIN);
                    if (sQLToken.value == 225) {
                        sQLToken = this.nextToken(MISSING_JOIN);
                    }
                    rowSource = this.join(command, dataSources, rowSource, 4);
                    continue block11;
                }
                case 41: 
                case 125: {
                    if (n == sQLToken.value) {
                        return rowSource;
                    }
                    if (n == 0) {
                        this.previousToken();
                        return rowSource;
                    }
                    throw this.createSyntaxError(sQLToken, "SS-0620");
                }
            }
            if (this.isKeyword(sQLToken)) {
                this.previousToken();
                return rowSource;
            }
            if (rowSource.hasAlias()) break;
            rowSource.setAlias(sQLToken.getName(this.sql));
        }
        throw this.createSyntaxError(sQLToken, new int[]{44, 212, 215, 214});
    }

    private void from(CommandSelect commandSelect) throws SQLException {
        SQLToken sQLToken;
        DataSources dataSources = new DataSources();
        commandSelect.setTables(dataSources);
        commandSelect.setSource(this.rowSource(commandSelect, dataSources, 0));
        block5: while (null != (sQLToken = this.nextToken())) {
            switch (sQLToken.value) {
                case 211: {
                    this.where(commandSelect);
                    continue block5;
                }
                case 212: {
                    this.group(commandSelect);
                    continue block5;
                }
                case 214: {
                    this.having(commandSelect);
                    continue block5;
                }
            }
            this.previousToken();
            return;
        }
    }

    private void order(CommandSelect commandSelect) throws SQLException {
        this.nextToken(MISSING_BY);
        commandSelect.setOrder(this.expressionTokenList(commandSelect, 215));
    }

    private void limit(CommandSelect commandSelect) throws SQLException {
        SQLToken sQLToken = this.nextToken(MISSING_EXPRESSION);
        try {
            int n = Integer.parseInt(sQLToken.getName(this.sql));
            commandSelect.setMaxRows(n);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.createSyntaxError(sQLToken, "SS-0622", sQLToken.getName(this.sql));
        }
    }

    private void group(CommandSelect commandSelect) throws SQLException {
        this.nextToken(MISSING_BY);
        commandSelect.setGroup(this.expressionTokenList(commandSelect, 212));
    }

    private void where(CommandSelect commandSelect) throws SQLException {
        commandSelect.setWhere(this.expression(commandSelect, 0));
    }

    private void having(CommandSelect commandSelect) throws SQLException {
        commandSelect.setHaving(this.expression(commandSelect, 0));
    }
}

