/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import smallsql.database.Mutable;
import smallsql.database.Utils;

class MutableNumeric
extends Number
implements Mutable {
    private static final long serialVersionUID = -750525164208565056L;
    private int[] value;
    private int scale;
    private int signum;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final double[] scaleDoubleFactor = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7};
    private static final float[] scaleFloatFactor = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f};

    MutableNumeric(byte[] byArray) {
        this.setValue(byArray);
    }

    private void setValue(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        if (n2 == 0) {
            this.value = EMPTY_INTS;
            this.signum = 0;
            return;
        }
        this.value = new int[(n2 + 3) / 4];
        if (byArray[0] < 0) {
            this.negate(byArray);
            this.signum = -1;
        } else {
            this.signum = 0;
            for (n = 0; n < byArray.length; ++n) {
                if (byArray[n] == 0) continue;
                this.signum = 1;
                break;
            }
        }
        for (n = this.value.length - 1; n >= 0; --n) {
            int n3 = 0;
            for (int i = 0; i < 4 && 0 < n2; ++i) {
                n3 |= (byArray[--n2] & 0xFF) << i * 8;
            }
            this.value[n] = n3;
        }
    }

    MutableNumeric(int n) {
        if (n == 0) {
            this.signum = 0;
            this.value = EMPTY_INTS;
        } else {
            this.value = new int[1];
            if (n < 0) {
                this.value[0] = -n;
                this.signum = -1;
            } else {
                this.value[0] = n;
                this.signum = 1;
            }
        }
    }

    MutableNumeric(int n, int n2) {
        this(n);
        this.scale = n2;
    }

    MutableNumeric(long l) {
        if (l == 0L) {
            this.signum = 0;
            this.value = EMPTY_INTS;
        } else {
            this.value = new int[2];
            if (l < 0L) {
                this.value[0] = (int)(l >> 32 ^ 0xFFFFFFFFFFFFFFFFL);
                this.value[1] = (int)(-l);
                this.signum = -1;
            } else {
                this.value[0] = (int)(l >> 32);
                this.value[1] = (int)l;
                this.signum = 1;
            }
        }
    }

    MutableNumeric(long l, int n) {
        this(l);
        this.scale = n;
    }

    MutableNumeric(double d) {
        this(new BigDecimal(String.valueOf(d)));
    }

    MutableNumeric(float f) {
        this(new BigDecimal(String.valueOf(f)));
    }

    MutableNumeric(String string) {
        this(new BigDecimal(string));
    }

    MutableNumeric(BigDecimal bigDecimal) {
        this(bigDecimal.unscaledValue().toByteArray());
        this.scale = bigDecimal.scale();
    }

    MutableNumeric(int n, int[] nArray, int n2) {
        this.signum = n;
        this.value = nArray;
        this.scale = n2;
    }

    MutableNumeric(MutableNumeric mutableNumeric) {
        this.signum = mutableNumeric.signum;
        this.value = new int[mutableNumeric.value.length];
        System.arraycopy(mutableNumeric.value, 0, this.value, 0, this.value.length);
        this.scale = mutableNumeric.scale;
    }

    int[] getInternalValue() {
        return this.value;
    }

    void add(MutableNumeric mutableNumeric) {
        if (mutableNumeric.scale < this.scale) {
            mutableNumeric.setScale(this.scale);
        } else if (mutableNumeric.scale > this.scale) {
            this.setScale(mutableNumeric.scale);
        }
        this.add(mutableNumeric.signum, mutableNumeric.value);
    }

    private void add(int n, int[] nArray) {
        if (nArray.length > this.value.length) {
            int[] nArray2 = nArray;
            nArray = this.value;
            this.value = nArray2;
            int n2 = this.signum;
            this.signum = n;
            n = n2;
        }
        if (this.signum != n) {
            this.sub(nArray);
        } else {
            this.add(nArray);
        }
    }

    private void add(int[] nArray) {
        long l = 0L;
        int n = this.value.length;
        int n2 = nArray.length;
        while (n2 > 0) {
            l = ((long)this.value[--n] & 0xFFFFFFFFL) + ((long)nArray[--n2] & 0xFFFFFFFFL) + (l >>> 32);
            this.value[n] = (int)l;
        }
        int n3 = n2 = l >>> 32 != 0L ? 1 : 0;
        while (n > 0 && n2 != 0) {
            this.value[--n] = this.value[n] + 1;
            n2 = this.value[--n] == 0 ? 1 : 0;
        }
        if (n2 != 0) {
            this.resizeValue(1);
        }
    }

    private void resizeValue(int n) {
        int[] nArray = new int[this.value.length + 1];
        nArray[0] = n;
        System.arraycopy(this.value, 0, nArray, 1, this.value.length);
        this.value = nArray;
    }

    void sub(MutableNumeric mutableNumeric) {
        if (mutableNumeric.scale < this.scale) {
            mutableNumeric.setScale(this.scale);
        } else if (mutableNumeric.scale > this.scale) {
            this.setScale(mutableNumeric.scale);
        }
        this.add(-mutableNumeric.signum, mutableNumeric.value);
    }

    private void sub(int[] nArray) {
        long l = 0L;
        int n = this.value.length;
        int n2 = nArray.length;
        while (n2 > 0) {
            l >>>= 32;
            l = ((long)this.value[--n] & 0xFFFFFFFFL) - ((long)nArray[--n2] & 0xFFFFFFFFL) + l;
            this.value[n] = (int)l;
        }
        int n3 = n2 = l >>> 32 != 0L ? 1 : 0;
        while (n > 0 && n2 != 0) {
            this.value[--n] = this.value[n] - 1;
            n2 = this.value[--n] == -1 ? 1 : 0;
        }
        if (n2 != 0) {
            this.signum = -this.signum;
            int n4 = this.value.length - 1;
            for (int i = 0; i <= n4; ++i) {
                this.value[i] = i == n4 ? -this.value[i] : ~this.value[i];
            }
        }
    }

    void mul(MutableNumeric mutableNumeric) {
        BigDecimal bigDecimal = this.toBigDecimal().multiply(mutableNumeric.toBigDecimal());
        this.setValue(bigDecimal.unscaledValue().toByteArray());
        this.scale = bigDecimal.scale();
        this.signum = bigDecimal.signum();
    }

    final void mul(int n) {
        if (n < 0) {
            n = -n;
            this.signum = -this.signum;
        }
        long l = 0L;
        for (int i = this.value.length - 1; i >= 0; --i) {
            long l2 = ((long)this.value[i] & 0xFFFFFFFFL) * (long)n + l;
            this.value[i] = (int)l2;
            l = l2 >> 32;
        }
        if (l > 0L) {
            this.resizeValue((int)l);
        }
    }

    void div(MutableNumeric mutableNumeric) {
        int n = Math.max(this.scale + 5, mutableNumeric.scale + 4);
        BigDecimal bigDecimal = this.toBigDecimal().divide(mutableNumeric.toBigDecimal(), n, 6);
        this.setValue(bigDecimal.unscaledValue().toByteArray());
        this.scale = bigDecimal.scale();
        this.signum = bigDecimal.signum();
    }

    final void div(int n) {
        this.mul(100000);
        this.scale += 5;
        this.divImpl(n);
    }

    private final void divImpl(int n) {
        int n2;
        if (n == 1) {
            return;
        }
        if (n < 0) {
            n = -n;
            this.signum = -this.signum;
        }
        int n3 = this.value.length;
        long l = 0L;
        for (n2 = 0; n2 < n3; ++n2) {
            long l2 = ((long)this.value[n2] & 0xFFFFFFFFL) + l;
            this.value[n2] = (int)(l2 / (long)n);
            l = l2 % (long)n << 32;
        }
        if ((l /= (long)n) > 0x80000000L || l == 0x80000000L && this.value[n3 - 1] % 2 == 1) {
            n2 = n3 - 1;
            boolean bl = true;
            while (n2 >= 0 && bl) {
                int n4 = n2--;
                int n5 = this.value[n4] + 1;
                this.value[n4] = n5;
                bl = n5 == 0;
            }
        }
        if (n3 > 1 && this.value[0] == 0) {
            int[] nArray = new int[n3 - 1];
            System.arraycopy(this.value, 1, nArray, 0, n3 - 1);
            this.value = nArray;
        }
    }

    void mod(MutableNumeric mutableNumeric) {
        mutableNumeric = new MutableNumeric(this.doubleValue() % mutableNumeric.doubleValue());
        this.value = mutableNumeric.value;
        this.scale = mutableNumeric.scale;
        this.signum = mutableNumeric.signum;
    }

    int getScale() {
        return this.scale;
    }

    void setScale(int n) {
        if (n == this.scale) {
            return;
        }
        int n2 = 1;
        if (n > this.scale) {
            while (n > this.scale) {
                if ((n2 *= 10) == 1000000000) {
                    this.mul(n2);
                    n2 = 1;
                }
                ++this.scale;
            }
            this.mul(n2);
        } else {
            while (n < this.scale) {
                if ((n2 *= 10) == 1000000000) {
                    this.divImpl(n2);
                    n2 = 1;
                }
                --this.scale;
            }
            this.divImpl(n2);
        }
    }

    int getSignum() {
        return this.signum;
    }

    void setSignum(int n) {
        this.signum = n;
    }

    void floor() {
        int n = this.scale;
        this.setScale(0);
        this.setScale(n);
    }

    private void negate(byte[] byArray) {
        int n = byArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            byArray[i] = (byte)(i == n ? -byArray[i] : ~byArray[i]);
        }
        while (byArray[n] == 0) {
            int n2 = --n;
            byArray[n2] = (byte)(byArray[n2] + 1);
        }
    }

    byte[] toByteArray() {
        int n;
        byte[] byArray;
        int n2;
        if (this.signum == 0) {
            return EMPTY_BYTES;
        }
        for (n2 = 0; n2 < this.value.length && this.value[n2] == 0; ++n2) {
        }
        if (n2 == this.value.length) {
            return EMPTY_BYTES;
        }
        if (this.value[n2] < 0) {
            byArray = new byte[(this.value.length - n2) * 4 + 4];
            if (this.signum < 0) {
                byArray[3] = -1;
                byArray[2] = -1;
                byArray[1] = -1;
                byArray[0] = -1;
            }
            n = 4;
        } else {
            byArray = new byte[(this.value.length - n2) * 4];
            n = 0;
        }
        int n3 = this.value.length - 1;
        while (n2 <= n3) {
            int n4 = this.signum > 0 ? this.value[n2] : (n2 == n3 ? -this.value[n2] : ~this.value[n2]);
            byArray[n++] = (byte)(n4 >> 24);
            byArray[n++] = (byte)(n4 >> 16);
            byArray[n++] = (byte)(n4 >> 8);
            byArray[n++] = (byte)n4;
            ++n2;
        }
        return byArray;
    }

    public int intValue() {
        return Utils.long2int(this.longValue());
    }

    public long longValue() {
        if (this.value.length == 0 || this.signum == 0) {
            return 0L;
        }
        if (this.value.length == 1 && this.value[0] > 0) {
            return Utils.double2long((double)this.value[0] / scaleDoubleFactor[this.scale] * (double)this.signum);
        }
        if (this.value.length == 1) {
            long l = (long)this.value[0] & 0xFFFFFFFFL;
            return Utils.double2long((double)l / scaleDoubleFactor[this.scale] * (double)this.signum);
        }
        if (this.value.length == 2 && this.value[0] > 0) {
            long l = (long)this.value[0] << 32 | (long)this.value[1] & 0xFFFFFFFFL;
            return Utils.double2long((double)l / scaleDoubleFactor[this.scale] * (double)this.signum);
        }
        if (this.scale != 0) {
            MutableNumeric mutableNumeric = new MutableNumeric(this);
            mutableNumeric.setScale(0);
            return mutableNumeric.longValue();
        }
        return this.signum > 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
    }

    public float floatValue() {
        if (this.value.length == 0 || this.signum == 0) {
            return 0.0f;
        }
        if (this.value.length == 1 && this.value[0] > 0) {
            return (float)this.value[0] / scaleFloatFactor[this.scale] * (float)this.signum;
        }
        if (this.value.length == 1) {
            long l = (long)this.value[0] & 0xFFFFFFFFL;
            return (float)l / scaleFloatFactor[this.scale] * (float)this.signum;
        }
        if (this.value.length == 2 && this.value[0] > 0) {
            long l = (long)this.value[0] << 32 | (long)this.value[1] & 0xFFFFFFFFL;
            return (float)l / scaleFloatFactor[this.scale] * (float)this.signum;
        }
        return new BigDecimal(new BigInteger(this.toByteArray()), this.scale).floatValue();
    }

    public double doubleValue() {
        if (this.value.length == 0 || this.signum == 0) {
            return 0.0;
        }
        if (this.value.length == 1 && this.value[0] > 0) {
            return (double)this.value[0] / scaleDoubleFactor[this.scale] * (double)this.signum;
        }
        if (this.value.length == 1) {
            long l = (long)this.value[0] & 0xFFFFFFFFL;
            return (double)l / scaleDoubleFactor[this.scale] * (double)this.signum;
        }
        if (this.value.length == 2 && this.value[0] > 0) {
            long l = (long)this.value[0] << 32 | (long)this.value[1] & 0xFFFFFFFFL;
            return (double)l / scaleDoubleFactor[this.scale] * (double)this.signum;
        }
        return new BigDecimal(new BigInteger(this.toByteArray()), this.scale).doubleValue();
    }

    public String toString() {
        long l;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.value.length == 0 || this.signum == 0) {
            stringBuffer.append('0');
        } else if (this.value.length == 1 && this.value[0] > 0) {
            stringBuffer.append(Integer.toString(this.value[0]));
        } else if (this.value.length == 1) {
            l = (long)this.value[0] & 0xFFFFFFFFL;
            stringBuffer.append(Long.toString(l));
        } else if (this.value.length == 2 && this.value[0] > 0) {
            l = (long)this.value[0] << 32 | (long)this.value[1] & 0xFFFFFFFFL;
            stringBuffer.append(Long.toString(l));
        } else {
            return new BigDecimal(new BigInteger(this.toByteArray()), this.scale).toString();
        }
        if (this.scale > 0) {
            while (stringBuffer.length() <= this.scale) {
                stringBuffer.insert(0, '0');
            }
            stringBuffer.insert(stringBuffer.length() - this.scale, '.');
        }
        if (this.signum < 0) {
            stringBuffer.insert(0, '-');
        }
        return stringBuffer.toString();
    }

    public int compareTo(MutableNumeric mutableNumeric) {
        return this.toBigDecimal().compareTo(mutableNumeric.toBigDecimal());
    }

    public boolean equals(Object object) {
        if (!(object instanceof MutableNumeric)) {
            return false;
        }
        return this.compareTo((MutableNumeric)object) == 0;
    }

    public BigDecimal toBigDecimal() {
        if (this.signum == 0) {
            return new BigDecimal(BigInteger.ZERO, this.scale);
        }
        return new BigDecimal(new BigInteger(this.toByteArray()), this.scale);
    }

    public BigDecimal toBigDecimal(int n) {
        if (n == this.scale) {
            return this.toBigDecimal();
        }
        return this.toBigDecimal().setScale(n, 6);
    }

    public Object getImmutableObject() {
        return this.toBigDecimal();
    }
}

