/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

class LongList {
    private int size;
    private long[] data;

    LongList() {
        this(16);
    }

    LongList(int n) {
        this.data = new long[n];
    }

    final int size() {
        return this.size;
    }

    final long get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.data[n];
    }

    final void add(long l) {
        if (this.size >= this.data.length) {
            this.resize(this.size << 1);
        }
        this.data[this.size++] = l;
    }

    final void clear() {
        this.size = 0;
    }

    private final void resize(int n) {
        long[] lArray = new long[n];
        System.arraycopy(this.data, 0, lArray, 0, this.size);
        this.data = lArray;
    }
}

