/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.Column;
import smallsql.database.ColumnExpression;
import smallsql.database.CommandSelect;
import smallsql.database.DataSource;
import smallsql.database.Expression;
import smallsql.database.ExpressionArithmetic;
import smallsql.database.ExpressionName;
import smallsql.database.ExpressionValue;
import smallsql.database.Expressions;
import smallsql.database.MemoryResult;
import smallsql.database.RowSource;
import smallsql.database.SmallSQLException;

class GroupResult
extends MemoryResult {
    private Expression currentGroup;
    private RowSource from;
    private Expressions groupBy;
    private Expressions expressions = new Expressions();
    private Expressions internalExpressions = new Expressions();

    GroupResult(CommandSelect commandSelect, RowSource rowSource, Expressions expressions, Expression expression, Expressions expressions2) throws SQLException {
        int n;
        this.from = rowSource;
        this.groupBy = expressions;
        if (expressions != null) {
            for (n = 0; n < expressions.size(); ++n) {
                Expression expression2 = expressions.get(n);
                int n2 = this.addInternalExpressionFromGroupBy(expression2);
                ExpressionName expressionName = new ExpressionName(null);
                expressionName.setFrom((DataSource)this, n2, new ColumnExpression(expression2));
                ExpressionArithmetic expressionArithmetic = new ExpressionArithmetic(expression2, expressionName, 52);
                this.currentGroup = this.currentGroup == null ? expressionArithmetic : new ExpressionArithmetic(this.currentGroup, expressionArithmetic, 21);
            }
        }
        this.expressions = this.internalExpressions;
        for (n = 0; n < this.expressions.size(); ++n) {
            this.addColumn(new ColumnExpression(this.expressions.get(n)));
        }
        this.patchExpressions(commandSelect.columnExpressions);
        if (expression != null) {
            expression = this.patchExpression(expression);
        }
        this.patchExpressions(expressions2);
    }

    private final int addInternalExpressionFromGroupBy(Expression expression) throws SQLException {
        int n = expression.getType();
        if (n >= 11) {
            throw SmallSQLException.create("SS-0430", expression);
        }
        int n2 = this.internalExpressions.indexOf(expression);
        if (n2 >= 0) {
            return n2;
        }
        this.internalExpressions.add(expression);
        return this.internalExpressions.size() - 1;
    }

    private final int addInternalExpressionFromSelect(Expression expression) throws SQLException {
        int n = expression.getType();
        if (n == 2) {
            int n2 = this.internalExpressions.indexOf(expression);
            if (n2 >= 0) {
                return n2;
            }
            throw SmallSQLException.create("SS-0431", expression);
        }
        if (n >= 11) {
            int n3 = this.internalExpressions.indexOf(expression);
            if (n3 >= 0) {
                return n3;
            }
            this.internalExpressions.add(expression);
            return this.internalExpressions.size() - 1;
        }
        int n4 = this.internalExpressions.indexOf(expression);
        if (n4 >= 0) {
            return n4;
        }
        Expression[] expressionArray = expression.getParams();
        if (expressionArray != null) {
            for (int i = 0; i < expressionArray.length; ++i) {
                this.addInternalExpressionFromSelect(expressionArray[i]);
            }
        }
        return -1;
    }

    private final void patchExpressions(Expressions expressions) throws SQLException {
        if (expressions == null) {
            return;
        }
        for (int i = 0; i < expressions.size(); ++i) {
            expressions.set(i, this.patchExpression(expressions.get(i)));
        }
    }

    private final void patchExpressions(Expression expression) throws SQLException {
        Expression[] expressionArray = expression.getParams();
        if (expressionArray == null) {
            return;
        }
        for (int i = 0; i < expressionArray.length; ++i) {
            expression.setParamAt(this.patchExpression(expressionArray[i]), i);
        }
    }

    private final Expression patchExpression(Expression expression) throws SQLException {
        int n = this.addInternalExpressionFromSelect(expression);
        if (n >= 0) {
            ExpressionName expressionName;
            Expression expression2 = expression;
            if (expression instanceof ExpressionName) {
                expressionName = (ExpressionName)expression;
            } else {
                expressionName = new ExpressionName(expression.getAlias());
                expression = expressionName;
            }
            Column column = expressionName.getColumn();
            if (column == null) {
                column = new Column();
                expressionName.setFrom((DataSource)this, n, column);
                switch (expressionName.getType()) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        Expression expression3 = expressionName.getParams()[0];
                        column.setPrecision(expression3.getPrecision());
                        column.setScale(expression3.getScale());
                        break;
                    }
                    default: {
                        column.setPrecision(expression2.getPrecision());
                        column.setScale(expression2.getScale());
                    }
                }
                column.setDataType(expressionName.getDataType());
            } else {
                expressionName.setFrom((DataSource)this, n, column);
            }
        } else {
            this.patchExpressions(expression);
        }
        return expression;
    }

    final void execute() throws Exception {
        super.execute();
        this.from.execute();
        block0: while (this.from.next()) {
            this.beforeFirst();
            while (this.next()) {
                if (this.currentGroup != null && !this.currentGroup.getBoolean()) continue;
                this.accumulateRow();
                continue block0;
            }
            this.addGroupRow();
            this.accumulateRow();
        }
        if (this.getRowCount() == 0 && this.groupBy == null) {
            this.addGroupRow();
        }
        this.beforeFirst();
    }

    private final void addGroupRow() {
        this.currentRow = new ExpressionValue[this.expressions.size()];
        ExpressionValue[] expressionValueArray = this.currentRow;
        for (int i = 0; i < expressionValueArray.length; ++i) {
            Expression expression = this.expressions.get(i);
            int n = expression.getType();
            if (n < 11) {
                n = 11;
            }
            expressionValueArray[i] = new ExpressionValue(n);
        }
        this.addRow(expressionValueArray);
    }

    private final void accumulateRow() throws Exception {
        for (int i = 0; i < this.currentRow.length; ++i) {
            Expression expression = this.expressions.get(i);
            this.currentRow[i].accumulate(expression);
        }
    }
}

