/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.DateTime;
import smallsql.database.Expression;
import smallsql.database.ExpressionFunction;
import smallsql.database.ExpressionFunctionTimestampDiff;
import smallsql.database.MutableNumeric;

public class ExpressionFunctionTimestampAdd
extends ExpressionFunction {
    private final int interval;

    ExpressionFunctionTimestampAdd(int n, Expression expression, Expression expression2) {
        this.interval = ExpressionFunctionTimestampDiff.mapIntervalType(n);
        this.setParams(new Expression[]{expression, expression2});
    }

    int getFunction() {
        return 1216;
    }

    boolean isNull() throws Exception {
        return this.param1.isNull() || this.param2.isNull();
    }

    boolean getBoolean() throws Exception {
        return this.getLong() != 0L;
    }

    int getInt() throws Exception {
        return (int)this.getLong();
    }

    long getLong() throws Exception {
        if (this.isNull()) {
            return 0L;
        }
        switch (this.interval) {
            case 1250: {
                return this.param2.getLong() + this.param1.getLong();
            }
            case 1251: {
                return this.param2.getLong() + this.param1.getLong() * 1000L;
            }
            case 1252: {
                return this.param2.getLong() + this.param1.getLong() * 60000L;
            }
            case 1253: {
                return this.param2.getLong() + this.param1.getLong() * 3600000L;
            }
            case 1254: {
                return this.param2.getLong() + this.param1.getLong() * 86400000L;
            }
            case 1255: {
                return this.param2.getLong() + this.param1.getLong() * 604800000L;
            }
            case 1256: {
                DateTime.Details details = new DateTime.Details(this.param2.getLong());
                details.month = (int)((long)details.month + this.param1.getLong());
                return DateTime.calcMillis(details);
            }
            case 1257: {
                DateTime.Details details = new DateTime.Details(this.param2.getLong());
                details.month = (int)((long)details.month + this.param1.getLong() * 3L);
                return DateTime.calcMillis(details);
            }
            case 1258: {
                DateTime.Details details = new DateTime.Details(this.param2.getLong());
                details.year = (int)((long)details.year + this.param1.getLong());
                return DateTime.calcMillis(details);
            }
        }
        throw new Error();
    }

    float getFloat() throws Exception {
        return this.getLong();
    }

    double getDouble() throws Exception {
        return this.getLong();
    }

    long getMoney() throws Exception {
        return this.getLong() * 10000L;
    }

    MutableNumeric getNumeric() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return new MutableNumeric(this.getLong());
    }

    Object getObject() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return new DateTime(this.getLong(), 342);
    }

    String getString() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return new DateTime(this.getLong(), 342).toString();
    }

    int getDataType() {
        return 342;
    }
}

