/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.ExpressionFunction;
import smallsql.database.MutableNumeric;
import smallsql.database.Utils;

abstract class ExpressionFunctionReturnFloat
extends ExpressionFunction {
    ExpressionFunctionReturnFloat() {
    }

    boolean isNull() throws Exception {
        return this.param1.isNull();
    }

    final boolean getBoolean() throws Exception {
        return this.getDouble() != 0.0;
    }

    final int getInt() throws Exception {
        return (int)this.getDouble();
    }

    final long getLong() throws Exception {
        return (long)this.getDouble();
    }

    final float getFloat() throws Exception {
        return (float)this.getDouble();
    }

    long getMoney() throws Exception {
        return Utils.doubleToMoney(this.getDouble());
    }

    final MutableNumeric getNumeric() throws Exception {
        if (this.isNull()) {
            return null;
        }
        double d = this.getDouble();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return null;
        }
        return new MutableNumeric(d);
    }

    final Object getObject() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.getDouble());
    }

    final String getString() throws Exception {
        Object object = this.getObject();
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    final int getDataType() {
        return 337;
    }
}

