/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.File;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.WeakHashMap;
import smallsql.database.Column;
import smallsql.database.Columns;
import smallsql.database.CommandCreateDatabase;
import smallsql.database.ForeignKey;
import smallsql.database.ForeignKeys;
import smallsql.database.IndexDescription;
import smallsql.database.IndexDescriptions;
import smallsql.database.SQLTokenizer;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;
import smallsql.database.Strings;
import smallsql.database.Table;
import smallsql.database.TableView;
import smallsql.database.TableViewMap;
import smallsql.database.Utils;
import smallsql.database.View;

final class Database {
    private static HashMap databases = new HashMap();
    private final TableViewMap tableViews = new TableViewMap();
    private final String name;
    private final boolean readonly;
    private final File directory;
    private final FileChannel master;
    private final WeakHashMap connections = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Database getDatabase(String string, SSConnection sSConnection, boolean bl) throws SQLException {
        File file;
        if (string == null) {
            return null;
        }
        if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        try {
            file = new File(string).getCanonicalFile();
        }
        catch (Throwable throwable) {
            throw SmallSQLException.createFromException(throwable);
        }
        String string2 = file.getName() + ";readonly=" + sSConnection.isReadOnly();
        HashMap hashMap = databases;
        synchronized (hashMap) {
            Database database = (Database)databases.get(string2);
            if (database == null) {
                if (bl && !file.isDirectory()) {
                    CommandCreateDatabase commandCreateDatabase = new CommandCreateDatabase(sSConnection.log, string);
                    commandCreateDatabase.execute(sSConnection, null);
                }
                database = new Database(string, file, sSConnection.isReadOnly());
                databases.put(string2, database);
            }
            database.connections.put(sSConnection, null);
            return database;
        }
    }

    private static Database getDatabase(SSConnection sSConnection, String string) throws SQLException {
        return string == null ? sSConnection.getDatabase(false) : Database.getDatabase(string, sSConnection, false);
    }

    private Database(String string, File file, boolean bl) throws SQLException {
        try {
            this.name = string;
            this.readonly = bl;
            this.directory = file;
            if (!this.directory.isDirectory()) {
                throw SmallSQLException.create("SS-0031", string);
            }
            File file2 = new File(this.directory, "smallsql.master");
            if (!file2.exists()) {
                throw SmallSQLException.create("SS-0032", string);
            }
            this.master = Utils.openRaFile(file2, bl);
        }
        catch (Exception exception) {
            throw SmallSQLException.createFromException(exception);
        }
    }

    String getName() {
        return this.name;
    }

    boolean isReadOnly() {
        return this.readonly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void closeConnection(SSConnection sSConnection) throws SQLException {
        HashMap hashMap = databases;
        synchronized (hashMap) {
            Iterator iterator = databases.values().iterator();
            while (iterator.hasNext()) {
                Database database = (Database)iterator.next();
                WeakHashMap weakHashMap = database.connections;
                weakHashMap.remove(sSConnection);
                if (weakHashMap.size() != 0) continue;
                try {
                    iterator.remove();
                    database.close();
                }
                catch (Exception exception) {
                    throw SmallSQLException.createFromException(exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void close() throws Exception {
        TableViewMap tableViewMap = this.tableViews;
        synchronized (tableViewMap) {
            Iterator iterator = this.tableViews.values().iterator();
            while (iterator.hasNext()) {
                TableView tableView = (TableView)iterator.next();
                tableView.close();
                iterator.remove();
            }
        }
        this.master.close();
    }

    static TableView getTableView(SSConnection sSConnection, String string, String string2) throws SQLException {
        return Database.getDatabase(sSConnection, string).getTableView(sSConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableView getTableView(SSConnection sSConnection, String string) throws SQLException {
        TableViewMap tableViewMap = this.tableViews;
        synchronized (tableViewMap) {
            TableView tableView = this.tableViews.get(string);
            if (tableView == null) {
                tableView = TableView.load(sSConnection, this, string);
                this.tableViews.put(string, tableView);
            }
            return tableView;
        }
    }

    static void dropTable(SSConnection sSConnection, String string, String string2) throws Exception {
        Database.getDatabase(sSConnection, string).dropTable(sSConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropTable(SSConnection sSConnection, String string) throws Exception {
        TableViewMap tableViewMap = this.tableViews;
        synchronized (tableViewMap) {
            Table table = (Table)this.tableViews.get(string);
            if (table != null) {
                this.tableViews.remove(string);
                table.drop(sSConnection);
            } else {
                Table.drop(this, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTableView(String string) {
        TableViewMap tableViewMap = this.tableViews;
        synchronized (tableViewMap) {
            this.tableViews.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceTable(Table table, Table table2) throws Exception {
        TableViewMap tableViewMap = this.tableViews;
        synchronized (tableViewMap) {
            this.tableViews.remove(table.name);
            this.tableViews.remove(table2.name);
            table.close();
            table2.close();
            File file = table.getFile(this);
            File file2 = table2.getFile(this);
            File file3 = new File(Utils.createTableViewFileName(this, "#" + System.currentTimeMillis() + this.hashCode()));
            if (!file.renameTo(file3)) {
                throw SmallSQLException.create("SS-0190", table.name);
            }
            if (!file2.renameTo(file)) {
                file3.renameTo(file);
                throw SmallSQLException.create("SS-0190", table.name);
            }
            file3.delete();
        }
    }

    static void dropView(SSConnection sSConnection, String string, String string2) throws Exception {
        Database.getDatabase(sSConnection, string).dropView(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropView(String string) throws Exception {
        TableViewMap tableViewMap = this.tableViews;
        synchronized (tableViewMap) {
            TableView tableView = this.tableViews.remove(string);
            if (tableView != null && !(tableView instanceof View)) {
                throw SmallSQLException.create("SS-0101", string);
            }
            View.drop(this, string);
        }
    }

    private void checkForeignKeys(SSConnection sSConnection, ForeignKeys foreignKeys) throws SQLException {
        for (int i = 0; i < foreignKeys.size(); ++i) {
            ForeignKey foreignKey = foreignKeys.get(i);
            TableView tableView = this.getTableView(sSConnection, foreignKey.pkTable);
            if (tableView instanceof Table) continue;
            throw SmallSQLException.create("SS-0220", foreignKey.pkTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTable(SSConnection sSConnection, String string, Columns columns, IndexDescriptions indexDescriptions, ForeignKeys foreignKeys) throws Exception {
        this.checkForeignKeys(sSConnection, foreignKeys);
        Table table = new Table(this, sSConnection, string, columns, indexDescriptions, foreignKeys);
        TableViewMap tableViewMap = this.tableViews;
        synchronized (tableViewMap) {
            this.tableViews.put(string, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Table createTable(SSConnection sSConnection, String string, Columns columns, IndexDescriptions indexDescriptions, IndexDescriptions indexDescriptions2, ForeignKeys foreignKeys) throws Exception {
        this.checkForeignKeys(sSConnection, foreignKeys);
        Table table = new Table(this, sSConnection, string, columns, indexDescriptions, indexDescriptions2, foreignKeys);
        TableViewMap tableViewMap = this.tableViews;
        synchronized (tableViewMap) {
            this.tableViews.put(string, table);
        }
        return table;
    }

    void createView(SSConnection sSConnection, String string, String string2) throws Exception {
        new View(this, sSConnection, string, string2);
    }

    static Object[][] getCatalogs(Database database) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        File file = database != null ? database.directory.getParentFile() : new File(".");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory() || !new File(fileArray[i], "smallsql.master").exists()) continue;
                Object[] objectArray = new Object[]{fileArray[i].getPath()};
                arrayList.add(objectArray);
            }
        }
        Object[][] objectArray = new Object[arrayList.size()][];
        arrayList.toArray((T[])objectArray);
        return objectArray;
    }

    Strings getTables(String string) {
        Strings strings = new Strings();
        File[] fileArray = this.directory.listFiles();
        if (fileArray != null && string == null) {
            string = "%";
        }
        string = string + ".sdb";
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getName();
            if (!Utils.like(string2, string)) continue;
            strings.add(string2.substring(0, string2.length() - ".sdb".length()));
        }
        return strings;
    }

    Object[][] getColumns(SSConnection sSConnection, String string, String string2) throws Exception {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Strings strings = this.getTables(string);
        for (int i = 0; i < strings.size(); ++i) {
            String string3 = strings.get(i);
            try {
                TableView tableView = this.getTableView(sSConnection, string3);
                Columns columns = tableView.columns;
                for (int j = 0; j < columns.size(); ++j) {
                    Column column = columns.get(j);
                    Object[] objectArray = new Object[18];
                    objectArray[0] = this.getName();
                    objectArray[2] = string3;
                    objectArray[3] = column.getName();
                    objectArray[4] = Utils.getShort(SQLTokenizer.getSQLDataType(column.getDataType()));
                    objectArray[5] = SQLTokenizer.getKeyWord(column.getDataType());
                    objectArray[6] = Utils.getInteger(column.getColumnSize());
                    objectArray[8] = Utils.getInteger(column.getScale());
                    objectArray[9] = Utils.getInteger(10);
                    objectArray[10] = Utils.getInteger(column.isNullable() ? 1 : 0);
                    objectArray[12] = column.getDefaultDefinition();
                    objectArray[15] = objectArray[6];
                    objectArray[16] = Utils.getInteger(i);
                    objectArray[17] = column.isNullable() ? "YES" : "NO";
                    arrayList.add(objectArray);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object[][] objectArray = new Object[arrayList.size()][];
        arrayList.toArray((T[])objectArray);
        return objectArray;
    }

    Object[][] getReferenceKeys(SSConnection sSConnection, String string, String string2) throws SQLException {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Strings strings = string != null ? this.getTables(string) : this.getTables(string2);
        for (int i = 0; i < strings.size(); ++i) {
            String string3 = strings.get(i);
            TableView tableView = this.getTableView(sSConnection, string3);
            if (!(tableView instanceof Table)) continue;
            ForeignKeys foreignKeys = ((Table)tableView).references;
            for (int j = 0; j < foreignKeys.size(); ++j) {
                ForeignKey foreignKey = foreignKeys.get(j);
                IndexDescription indexDescription = foreignKey.pk;
                IndexDescription indexDescription2 = foreignKey.fk;
                if (string != null && !string.equals(foreignKey.pkTable) || string2 != null && !string2.equals(foreignKey.fkTable)) continue;
                Strings strings2 = indexDescription.getColumns();
                Strings strings3 = indexDescription2.getColumns();
                for (int k = 0; k < strings2.size(); ++k) {
                    Object[] objectArray = new Object[14];
                    objectArray[0] = this.getName();
                    objectArray[2] = foreignKey.pkTable;
                    objectArray[3] = strings2.get(k);
                    objectArray[4] = this.getName();
                    objectArray[6] = foreignKey.fkTable;
                    objectArray[7] = strings3.get(k);
                    objectArray[8] = Utils.getShort(k + 1);
                    foreignKey.getClass();
                    objectArray[9] = Utils.getShort(3);
                    foreignKey.getClass();
                    objectArray[10] = Utils.getShort(3);
                    objectArray[11] = indexDescription2.getName();
                    objectArray[12] = indexDescription.getName();
                    objectArray[13] = Utils.getShort(7);
                    arrayList.add(objectArray);
                }
            }
        }
        Object[][] objectArray = new Object[arrayList.size()][];
        arrayList.toArray((T[])objectArray);
        return objectArray;
    }

    Object[][] getBestRowIdentifier(SSConnection sSConnection, String string) throws SQLException {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Strings strings = this.getTables(string);
        for (int i = 0; i < strings.size(); ++i) {
            String string2 = strings.get(i);
            TableView tableView = this.getTableView(sSConnection, string2);
            if (!(tableView instanceof Table)) continue;
            IndexDescriptions indexDescriptions = ((Table)tableView).indexes;
            for (int j = 0; j < indexDescriptions.size(); ++j) {
                IndexDescription indexDescription = indexDescriptions.get(j);
                if (!indexDescription.isUnique()) continue;
                Strings strings2 = indexDescription.getColumns();
                for (int k = 0; k < strings2.size(); ++k) {
                    String string3 = strings2.get(k);
                    Column column = tableView.findColumn(string3);
                    Object[] objectArray = new Object[8];
                    objectArray[0] = Utils.getShort(2);
                    objectArray[1] = string3;
                    int n = column.getDataType();
                    objectArray[2] = Utils.getInteger(n);
                    objectArray[3] = SQLTokenizer.getKeyWord(n);
                    objectArray[4] = Utils.getInteger(column.getPrecision());
                    objectArray[6] = Utils.getShort(column.getScale());
                    objectArray[7] = Utils.getShort(1);
                    arrayList.add(objectArray);
                }
            }
        }
        Object[][] objectArray = new Object[arrayList.size()][];
        arrayList.toArray((T[])objectArray);
        return objectArray;
    }

    Object[][] getPrimaryKeys(SSConnection sSConnection, String string) throws SQLException {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Strings strings = this.getTables(string);
        for (int i = 0; i < strings.size(); ++i) {
            String string2 = strings.get(i);
            TableView tableView = this.getTableView(sSConnection, string2);
            if (!(tableView instanceof Table)) continue;
            IndexDescriptions indexDescriptions = ((Table)tableView).indexes;
            for (int j = 0; j < indexDescriptions.size(); ++j) {
                IndexDescription indexDescription = indexDescriptions.get(j);
                if (!indexDescription.isPrimary()) continue;
                Strings strings2 = indexDescription.getColumns();
                for (int k = 0; k < strings2.size(); ++k) {
                    Object[] objectArray = new Object[6];
                    objectArray[0] = this.getName();
                    objectArray[2] = string2;
                    objectArray[3] = strings2.get(k);
                    objectArray[4] = Utils.getShort(k + 1);
                    objectArray[5] = indexDescription.getName();
                    arrayList.add(objectArray);
                }
            }
        }
        Object[][] objectArray = new Object[arrayList.size()][];
        arrayList.toArray((T[])objectArray);
        return objectArray;
    }

    Object[][] getIndexInfo(SSConnection sSConnection, String string, boolean bl) throws SQLException {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Strings strings = this.getTables(string);
        Short s = Utils.getShort(3);
        for (int i = 0; i < strings.size(); ++i) {
            String string2 = strings.get(i);
            TableView tableView = this.getTableView(sSConnection, string2);
            if (!(tableView instanceof Table)) continue;
            IndexDescriptions indexDescriptions = ((Table)tableView).indexes;
            for (int j = 0; j < indexDescriptions.size(); ++j) {
                IndexDescription indexDescription = indexDescriptions.get(j);
                Strings strings2 = indexDescription.getColumns();
                for (int k = 0; k < strings2.size(); ++k) {
                    Object[] objectArray = new Object[13];
                    objectArray[0] = this.getName();
                    objectArray[2] = string2;
                    objectArray[3] = !indexDescription.isUnique();
                    objectArray[5] = indexDescription.getName();
                    objectArray[6] = s;
                    objectArray[7] = Utils.getShort(k + 1);
                    objectArray[8] = strings2.get(k);
                    arrayList.add(objectArray);
                }
            }
        }
        Object[][] objectArray = new Object[arrayList.size()][];
        arrayList.toArray((T[])objectArray);
        return objectArray;
    }
}

