/*
 * Decompiled with CFR 0.152.
 */
package com.inet.designer.sampledatabase.adhoc;

import com.inet.designer.sampledatabase.adhoc.c;
import com.inet.error.ErrorCode;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.PersistenceTemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.dataview.SimpleDataView;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class b
extends c {
    public b(Map<String, List<TemplateDataViewDefaults.Column>> map) {
        super(map);
    }

    @Nonnull
    public String getExtensionName() {
        return "Customer Purchase Frequency";
    }

    @Nullable
    public String getDescription() {
        return "A Customer Sample View";
    }

    @Nonnull
    public DataView createDataView(@Nonnull Engine engine, @Nullable DataFilter filter) {
        try {
            DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((String)"Sample Database");
            if (dataSourceConfiguration == null) {
                throw new IllegalStateException();
            }
            DatabaseTables databaseTables = engine.getDatabaseTables();
            Datasource datasource = databaseTables.getDatasource(0);
            datasource.setDataSourceConfiguration(dataSourceConfiguration);
            for (Map.Entry entry : this.c.entrySet()) {
                String string = (String)entry.getKey();
                List list = (List)entry.getValue();
                TableSource tableSource = datasource.createTableSource(string);
                for (TemplateDataViewDefaults.Column column2 : list) {
                    String string2 = column2.getKey();
                    if (string2.startsWith(string + ".")) {
                        string2 = string2.substring(string.length() + 1);
                    }
                    tableSource.addColumn(string2, column2.getDataType());
                }
            }
            this.a(databaseTables, List.of(new PersistenceTemplateDataViewDefaults.Join("Customers", "CustomerID", "Orders", "CustomerID")));
            this.setSelectionFormula(engine, filter);
            List list = this.getAvailableColumns().stream().map(column -> column).collect(Collectors.toList());
            return new SimpleDataView(list, engine);
        }
        catch (ReportException reportException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)reportException);
        }
    }

    private void a(@Nonnull DatabaseTables databaseTables, @Nonnull List<PersistenceTemplateDataViewDefaults.Join> list) throws ReportException {
        if (list != null) {
            for (PersistenceTemplateDataViewDefaults.Join join : list) {
                TableSource tableSource;
                DatabaseField databaseField;
                TableSource tableSource2 = databaseTables.getTablesource(join.getFromTableAlias());
                DatabaseField databaseField2 = tableSource2.getDatabaseField(join.getFromColumn());
                if (databaseField2 == null) {
                    tableSource2.addColumn(join.getFromColumn(), 11);
                    databaseField2 = tableSource2.getDatabaseField(join.getFromColumn());
                }
                if ((databaseField = (tableSource = databaseTables.getTablesource(join.getToTableAlias())).getDatabaseField(join.getToColumn())) == null) {
                    tableSource.addColumn(join.getToColumn(), 11);
                    databaseField = tableSource.getDatabaseField(join.getToColumn());
                }
                databaseTables.addJoin(tableSource2, databaseField2, tableSource, databaseField, join.getJoinType(), join.getLinkType());
            }
        }
    }

    @Override
    @Nullable
    public <T> T get(@Nonnull RendererPropertyKey<T> key) {
        if (key == TABLE_COLUMNS) {
            return (T)key.cast(this.getAvailableColumns().stream().filter(column -> !column.getKey().startsWith("@")).map(column -> new TableColumnData(column.getKey())).toArray(TableColumnData[]::new));
        }
        return super.get(key);
    }
}

