/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.LongTreeListEnum;
import smallsql.database.SmallSQLException;
import smallsql.database.StoreImpl;

final class LongTreeList {
    private byte[] data;
    private int size;
    private int offset;
    private static final int pointerSize = 3;

    LongTreeList() {
        this.data = new byte[25];
    }

    LongTreeList(long l) throws SQLException {
        this();
        this.add(l);
    }

    LongTreeList(StoreImpl storeImpl) {
        int n = storeImpl.readInt();
        this.data = storeImpl.readBytes(n);
    }

    final void save(StoreImpl storeImpl) {
        storeImpl.writeInt(this.size);
        storeImpl.writeBytes(this.data, 0, this.size);
    }

    final void add(long l) throws SQLException {
        boolean bl;
        this.offset = 0;
        if (this.size == 0) {
            this.writeShort((int)(l >> 48));
            this.writePointer(this.offset + 3 + 2);
            this.writeShort(0);
            this.writeShort((int)(l >> 32));
            this.writePointer(this.offset + 3 + 2);
            this.writeShort(0);
            this.writeShort((int)(l >> 16));
            this.writePointer(this.offset + 3 + 2);
            this.writeShort(0);
            this.writeShort((int)l);
            this.writeShort(0);
            this.size = this.offset;
            return;
        }
        boolean bl2 = bl = this.size > 2;
        for (int i = 48; i >= 0; i -= 16) {
            int n = (int)(l >> i) & 0xFFFF;
            while (true) {
                int n2;
                if ((n2 = this.getUnsignedShort()) == n) {
                    if (i == 0) {
                        return;
                    }
                    break;
                }
                if (n2 == 0 && !bl || n2 > n) {
                    this.offset -= 2;
                    while (true) {
                        if (i == 0) {
                            this.insertNodeLastLevel(n);
                            return;
                        }
                        this.offset = this.insertNode(n);
                        n = (int)(l >> (i -= 16)) & 0xFFFF;
                    }
                }
                bl = false;
                if (i == 0) continue;
                this.offset += 3;
            }
            this.offset = this.getPointer();
            bl = true;
        }
    }

    final void remove(long l) throws SQLException {
        if (this.size == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.offset = 0;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        for (int i = 48; i >= 0; i -= 16) {
            int n4 = (int)(l >> i) & 0xFFFF;
            while (true) {
                int n5;
                if ((n5 = this.getUnsignedShort()) == n4) {
                    if (i == 0) {
                        this.offset -= 2;
                        this.removeNodeLastLevel();
                        while (bl && this.getUnsignedShort() == 0) {
                            this.offset -= 2;
                            this.removeNodeLastLevel();
                            if (i >= 3) break;
                            this.offset = n;
                            n = n2;
                            n2 = n3;
                            bl = bl2;
                            bl2 = bl3;
                            bl3 = bl4;
                            this.removeNode();
                            ++i;
                        }
                        return;
                    }
                    break;
                }
                if (n5 == 0 && !bl || n5 > n4) {
                    return;
                }
                bl = false;
                if (i == 0) continue;
                this.offset += 3;
            }
            n3 = n2;
            n2 = n;
            n = this.offset - 2;
            this.offset = this.getPointer();
            bl4 = bl3;
            bl3 = bl2;
            bl2 = bl;
            bl = true;
        }
    }

    final long getNext(LongTreeListEnum longTreeListEnum) {
        boolean bl;
        int n = 3 - longTreeListEnum.stack << 4;
        if (n >= 64) {
            return -1L;
        }
        this.offset = longTreeListEnum.offsetStack[longTreeListEnum.stack];
        long l = longTreeListEnum.resultStack[longTreeListEnum.stack];
        boolean bl2 = bl = this.offset == 0;
        while (true) {
            int n2;
            if ((n2 = this.getUnsignedShort()) != 0 || bl) {
                l |= (long)n2 << n;
                if (longTreeListEnum.stack >= 3) {
                    longTreeListEnum.offsetStack[longTreeListEnum.stack] = this.offset;
                    return l;
                }
                longTreeListEnum.offsetStack[longTreeListEnum.stack] = this.offset + 3;
                this.offset = this.getPointer();
                n -= 16;
                ++longTreeListEnum.stack;
                longTreeListEnum.resultStack[longTreeListEnum.stack] = l;
                bl = true;
                continue;
            }
            n += 16;
            --longTreeListEnum.stack;
            if (longTreeListEnum.stack < 0) {
                return -1L;
            }
            l = longTreeListEnum.resultStack[longTreeListEnum.stack];
            this.offset = longTreeListEnum.offsetStack[longTreeListEnum.stack];
            bl = false;
        }
    }

    final long getPrevious(LongTreeListEnum longTreeListEnum) {
        int n = 3 - longTreeListEnum.stack << 4;
        if (n >= 64) {
            n = 48;
            this.offset = 0;
            longTreeListEnum.stack = 0;
            longTreeListEnum.offsetStack[0] = 5;
            this.loopToEndOfNode(longTreeListEnum);
        } else {
            this.setPreviousOffset(longTreeListEnum);
        }
        long l = longTreeListEnum.resultStack[longTreeListEnum.stack];
        while (true) {
            int n2;
            int n3 = n2 = this.offset < 0 ? -1 : this.getUnsignedShort();
            if (n2 >= 0) {
                l |= (long)n2 << n;
                if (longTreeListEnum.stack >= 3) {
                    longTreeListEnum.offsetStack[longTreeListEnum.stack] = this.offset;
                    return l;
                }
                longTreeListEnum.offsetStack[longTreeListEnum.stack] = this.offset + 3;
                this.offset = this.getPointer();
                n -= 16;
                ++longTreeListEnum.stack;
                longTreeListEnum.resultStack[longTreeListEnum.stack] = l;
                this.loopToEndOfNode(longTreeListEnum);
                continue;
            }
            n += 16;
            --longTreeListEnum.stack;
            if (longTreeListEnum.stack < 0) {
                return -1L;
            }
            l = longTreeListEnum.resultStack[longTreeListEnum.stack];
            this.setPreviousOffset(longTreeListEnum);
        }
    }

    private final void setPreviousOffset(LongTreeListEnum longTreeListEnum) {
        int n = longTreeListEnum.offsetStack[longTreeListEnum.stack] - 2 * (2 + (longTreeListEnum.stack >= 3 ? 0 : 3));
        if (longTreeListEnum.stack == 0) {
            this.offset = n;
            return;
        }
        this.offset = longTreeListEnum.offsetStack[longTreeListEnum.stack - 1] - 3;
        int n2 = this.getPointer();
        if (n2 <= n) {
            this.offset = n;
            return;
        }
        this.offset = -1;
    }

    private final void loopToEndOfNode(LongTreeListEnum longTreeListEnum) {
        int n;
        int n2;
        int n3 = this.offset;
        this.offset += 2;
        if (longTreeListEnum.stack < 3) {
            this.offset += 3;
        }
        do {
            n = n3;
            n3 = this.offset;
            n2 = this.getUnsignedShort();
            if (longTreeListEnum.stack >= 3) continue;
            this.offset += 3;
        } while (n2 != 0);
        this.offset = n;
    }

    private final int insertNode(int n) throws SQLException {
        int n2 = this.offset;
        if (this.data.length < this.size + 4 + 3) {
            this.resize();
        }
        System.arraycopy(this.data, n2, this.data, n2 + 2 + 3, this.size - n2);
        this.size += 5;
        this.writeShort(n);
        this.writePointer(this.size);
        this.correctPointers(0, n2, 5, 0);
        this.data[this.size++] = 0;
        this.data[this.size++] = 0;
        return this.size - 2;
    }

    private final void insertNodeLastLevel(int n) throws SQLException {
        int n2 = this.offset;
        if (this.data.length < this.size + 2) {
            this.resize();
        }
        System.arraycopy(this.data, this.offset, this.data, this.offset + 2, this.size - this.offset);
        this.size += 2;
        this.writeShort(n);
        this.correctPointers(0, n2, 2, 0);
    }

    private final void removeNode() throws SQLException {
        int n = this.offset;
        this.correctPointers(0, n, -5, 0);
        this.size -= 5;
        System.arraycopy(this.data, n + 2 + 3, this.data, n, this.size - n);
        this.offset = n;
    }

    private final void removeNodeLastLevel() throws SQLException {
        int n = this.offset;
        this.correctPointers(0, n, -2, 0);
        this.size -= 2;
        System.arraycopy(this.data, n + 2, this.data, n, this.size - n);
        this.offset = n;
    }

    private final void correctPointers(int n, int n2, int n3, int n4) {
        this.offset = n;
        boolean bl = true;
        while (this.offset < this.size) {
            int n5;
            if (this.offset == n2) {
                n5 = Math.abs(n3);
                if (n5 == 2) {
                    return;
                }
                this.offset += n5;
                bl = false;
                continue;
            }
            n5 = this.getUnsignedShort();
            if (n5 != 0 || bl) {
                int n6 = this.getPointer();
                if (n6 > n2) {
                    this.offset -= 3;
                    this.writePointer(n6 + n3);
                    if (n3 > 0) {
                        n6 += n3;
                    }
                }
                if (n4 < 2) {
                    n = this.offset;
                    this.correctPointers(n6, n2, n3, n4 + 1);
                    this.offset = n;
                }
                bl = false;
                continue;
            }
            return;
        }
    }

    private final int getPointer() {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            n <<= 8;
            n += this.data[this.offset++] & 0xFF;
        }
        return n;
    }

    private final void writePointer(int n) {
        for (int i = 2; i >= 0; --i) {
            this.data[this.offset++] = (byte)(n >> i * 8);
        }
    }

    private final int getUnsignedShort() {
        return (this.data[this.offset++] & 0xFF) << 8 | this.data[this.offset++] & 0xFF;
    }

    private final void writeShort(int n) {
        this.data[this.offset++] = (byte)(n >> 8);
        this.data[this.offset++] = (byte)n;
    }

    private final void resize() throws SQLException {
        int n = this.data.length << 1;
        if (n > 0xFFFFFF && (n = 0xFFFFFF) == this.data.length) {
            throw SmallSQLException.create("SS-0464");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        this.data = byArray;
    }

    final int getSize() {
        return this.size;
    }
}

