/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Expressions;
import smallsql.database.Index;
import smallsql.database.JoinScroll;
import smallsql.database.LongTreeList;
import smallsql.database.LongTreeListEnum;
import smallsql.database.RowSource;

class JoinScrollIndex
extends JoinScroll {
    private final int compare;
    Expressions leftEx;
    Expressions rightEx;
    private Index index;
    private LongTreeList rowList;
    private final LongTreeListEnum longListEnum = new LongTreeListEnum();

    JoinScrollIndex(int n, RowSource rowSource, RowSource rowSource2, Expressions expressions, Expressions expressions2, int n2) throws Exception {
        super(n, rowSource, rowSource2, null);
        this.leftEx = expressions;
        this.rightEx = expressions2;
        this.compare = n2;
        this.createIndex(expressions2);
    }

    private void createIndex(Expressions expressions) throws Exception {
        this.index = new Index(false);
        this.right.beforeFirst();
        while (this.right.next()) {
            this.index.addValues(this.right.getRowPosition(), expressions);
        }
    }

    boolean next() throws Exception {
        switch (this.compare) {
            case 51: {
                return this.nextEquals();
            }
        }
        throw new Error("Compare operation not supported:" + this.compare);
    }

    private boolean nextEquals() throws Exception {
        Object object;
        if (this.rowList != null) {
            long l = this.rowList.getNext(this.longListEnum);
            if (l != -1L) {
                this.right.setRowPosition(l);
                return true;
            }
            this.rowList = null;
        }
        do {
            if (this.left.next()) continue;
            return false;
        } while ((object = this.index.findRows(this.leftEx, false, null)) == null);
        if (object instanceof Long) {
            this.right.setRowPosition((Long)object);
        } else {
            this.rowList = (LongTreeList)object;
            this.longListEnum.reset();
            this.right.setRowPosition(this.rowList.getNext(this.longListEnum));
        }
        return true;
    }
}

