/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.Database;
import smallsql.database.IndexDescription;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;
import smallsql.database.Strings;
import smallsql.database.TableView;

class IndexDescriptions {
    private int size;
    private IndexDescription[] data = new IndexDescription[4];
    private boolean hasPrimary;

    IndexDescriptions() {
    }

    final int size() {
        return this.size;
    }

    final IndexDescription get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Column index: " + n + ", Size: " + this.size);
        }
        return this.data[n];
    }

    final void add(IndexDescription indexDescription) throws SQLException {
        if (this.size >= this.data.length) {
            this.resize(this.size << 1);
        }
        if (this.hasPrimary && indexDescription.isPrimary()) {
            throw SmallSQLException.create("SS-0221");
        }
        this.hasPrimary = indexDescription.isPrimary();
        this.data[this.size++] = indexDescription;
    }

    private final void resize(int n) {
        IndexDescription[] indexDescriptionArray = new IndexDescription[n];
        System.arraycopy(this.data, 0, indexDescriptionArray, 0, this.size);
        this.data = indexDescriptionArray;
    }

    final IndexDescription findBestMatch(Strings strings) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (int i = 0; i < this.size; ++i) {
            int n3 = this.data[i].matchFactor(strings);
            if (n3 == 0) {
                return this.data[i];
            }
            if (n3 >= n) continue;
            n = n3;
            n2 = i;
        }
        if (n == Integer.MAX_VALUE) {
            return null;
        }
        return this.data[n2];
    }

    void create(SSConnection sSConnection, Database database, TableView tableView) throws Exception {
        for (int i = 0; i < this.size; ++i) {
            this.data[i].create(sSConnection, database, tableView);
        }
    }

    void drop(Database database) throws Exception {
        for (int i = 0; i < this.size; ++i) {
            this.data[i].drop(database);
        }
    }

    void close() throws Exception {
        for (int i = 0; i < this.size; ++i) {
            this.data[i].close();
        }
    }

    void add(IndexDescriptions indexDescriptions) throws SQLException {
        for (int i = 0; i < indexDescriptions.size; ++i) {
            this.add(indexDescriptions.data[i]);
        }
    }
}

