/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import java.util.ArrayList;
import smallsql.database.Column;
import smallsql.database.Command;
import smallsql.database.CommandSelect;
import smallsql.database.Expression;
import smallsql.database.Expressions;
import smallsql.database.IndexDescriptions;
import smallsql.database.Logger;
import smallsql.database.SSConnection;
import smallsql.database.SSResultSet;
import smallsql.database.SSStatement;
import smallsql.database.SmallSQLException;
import smallsql.database.StoreImpl;
import smallsql.database.Strings;
import smallsql.database.Table;
import smallsql.database.TableView;
import smallsql.database.Utils;

public class CommandInsert
extends Command {
    boolean noColumns;
    private CommandSelect cmdSel;
    private Table table;
    private long tableTimestamp;
    private int[] matrix;

    CommandInsert(Logger logger, String string) {
        super(logger);
        this.name = string;
    }

    void addColumnExpression(Expression expression) throws SQLException {
        if (this.columnExpressions.indexOf(expression) >= 0) {
            throw SmallSQLException.create("SS-0400", expression);
        }
        super.addColumnExpression(expression);
    }

    void addValues(Expressions expressions) {
        this.cmdSel = new CommandSelect(this.log, expressions);
    }

    void addValues(CommandSelect commandSelect) {
        this.cmdSel = commandSelect;
    }

    private void compile(SSConnection sSConnection) throws Exception {
        TableView tableView = sSConnection.getDatabase(false).getTableView(sSConnection, this.name);
        if (!(tableView instanceof Table)) {
            throw SmallSQLException.create("SS-0100");
        }
        this.table = (Table)tableView;
        this.tableTimestamp = this.table.getTimestamp();
        this.cmdSel.compile(sSConnection);
        int n = this.table.columns.size();
        this.matrix = new int[n];
        if (this.noColumns) {
            this.columnExpressions.clear();
            for (int i = 0; i < n; ++i) {
                this.matrix[i] = i;
            }
            if (n != this.cmdSel.columnExpressions.size()) {
                throw SmallSQLException.create("SS-0402");
            }
        } else {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.matrix[n2] = -1;
            }
            n2 = 0;
            while (n2 < this.columnExpressions.size()) {
                Expression expression = this.columnExpressions.get(n2);
                String string = expression.getName();
                int n3 = this.table.findColumnIdx(string);
                if (n3 < 0) {
                    throw SmallSQLException.create("SS-0401", string);
                }
                this.matrix[n3] = n2++;
            }
            if (this.columnExpressions.size() != this.cmdSel.columnExpressions.size()) {
                throw SmallSQLException.create("SS-0402");
            }
        }
    }

    void executeImpl(SSConnection sSConnection, SSStatement sSStatement) throws Exception {
        if (this.table == null || this.tableTimestamp != this.table.getTimestamp()) {
            this.compile(sSConnection);
        }
        IndexDescriptions indexDescriptions = this.table.indexes;
        this.updateCount = 0;
        this.cmdSel.from.execute();
        this.cmdSel.beforeFirst();
        Strings strings = null;
        ArrayList<Object> arrayList = null;
        boolean bl = sSStatement.needGeneratedKeys();
        int n = 0;
        while (this.cmdSel.next()) {
            int n2;
            if (bl) {
                strings = new Strings();
                arrayList = new ArrayList<Object>();
                if (sSStatement.getGeneratedKeyNames() != null) {
                    n = 1;
                }
                if (sSStatement.getGeneratedKeyIndexes() != null) {
                    n = 2;
                }
            }
            StoreImpl storeImpl = this.table.getStoreInsert(sSConnection);
            for (n2 = 0; n2 < this.matrix.length; ++n2) {
                int n3;
                Object[] objectArray;
                Expression expression;
                Column column = this.table.columns.get(n2);
                int n4 = this.matrix[n2];
                if (n4 >= 0) {
                    expression = this.cmdSel.columnExpressions.get(n4);
                } else {
                    expression = column.getDefaultValue(sSConnection);
                    if (bl && n == 0 && expression != Expression.NULL) {
                        strings.add(column.getName());
                        arrayList.add(expression.getObject());
                    }
                }
                if (bl && n == 1) {
                    objectArray = sSStatement.getGeneratedKeyNames();
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        if (!column.getName().equalsIgnoreCase(objectArray[n3])) continue;
                        strings.add(column.getName());
                        arrayList.add(expression.getObject());
                        break;
                    }
                }
                if (bl && n == 2) {
                    objectArray = sSStatement.getGeneratedKeyIndexes();
                    for (n3 = 0; n3 < objectArray.length; ++n3) {
                        if (n2 + 1 != objectArray[n3]) continue;
                        strings.add(column.getName());
                        arrayList.add(expression.getObject());
                        break;
                    }
                }
                storeImpl.writeExpression(expression, column);
                for (int i = 0; i < indexDescriptions.size(); ++i) {
                    indexDescriptions.get(i).writeExpression(n2, expression);
                }
            }
            storeImpl.writeFinsh(sSConnection);
            for (n2 = 0; n2 < indexDescriptions.size(); ++n2) {
                indexDescriptions.get(n2).writeFinish(sSConnection);
            }
            ++this.updateCount;
            if (!bl) continue;
            Object[][] objectArray = new Object[1][arrayList.size()];
            arrayList.toArray(objectArray[0]);
            sSStatement.setGeneratedKeys(new SSResultSet(sSStatement, Utils.createMemoryCommandSelect(sSConnection, strings.toArray(), objectArray)));
        }
    }
}

