/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

final class LongLongList {
    private int size;
    private long[] data;

    LongLongList() {
        this(16);
    }

    LongLongList(int n) {
        this.data = new long[n * 2];
    }

    final int size() {
        return this.size;
    }

    final long get1(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.data[n << 1];
    }

    final long get2(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.data[(n << 1) + 1];
    }

    final void add(long l, long l2) {
        int n = this.size << 1;
        if (n >= this.data.length) {
            this.resize(n);
        }
        this.data[n] = l;
        this.data[n + 1] = l2;
        ++this.size;
    }

    final void clear() {
        this.size = 0;
    }

    private final void resize(int n) {
        long[] lArray = new long[n << 1];
        System.arraycopy(this.data, 0, lArray, 0, this.size << 1);
        this.data = lArray;
    }
}

