/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import smallsql.database.Expressions;
import smallsql.database.FileIndexNode;
import smallsql.database.Index;
import smallsql.database.IndexScrollStatus;

class FileIndex
extends Index {
    private final FileChannel raFile;

    static void print(Index index, Expressions expressions) {
        long l;
        IndexScrollStatus indexScrollStatus = index.createScrollStatus(expressions);
        while ((l = indexScrollStatus.getRowOffset(true)) >= 0L) {
            System.out.println(l);
        }
        System.out.println("============================");
    }

    FileIndex(boolean bl, FileChannel fileChannel) {
        this(new FileIndexNode(bl, '\uffff', fileChannel), fileChannel);
    }

    FileIndex(FileIndexNode fileIndexNode, FileChannel fileChannel) {
        super(fileIndexNode);
        this.raFile = fileChannel;
    }

    static FileIndex load(FileChannel fileChannel) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        fileChannel.read(byteBuffer);
        byteBuffer.position(0);
        boolean bl = byteBuffer.get() != 0;
        FileIndexNode fileIndexNode = FileIndexNode.loadRootNode(bl, fileChannel, fileChannel.position());
        return new FileIndex(fileIndexNode, fileChannel);
    }

    void save() throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        byteBuffer.put(this.rootPage.getUnique() ? (byte)1 : 0);
        byteBuffer.position(0);
        this.raFile.write(byteBuffer);
        ((FileIndexNode)this.rootPage).save();
    }

    void close() throws IOException {
        this.raFile.close();
    }
}

