/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.DriverManager;
import java.sql.SQLException;
import smallsql.database.CreateFile;
import smallsql.database.Database;
import smallsql.database.Expression;
import smallsql.database.Expressions;
import smallsql.database.Index;
import smallsql.database.SQLParser;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;
import smallsql.database.StoreImpl;
import smallsql.database.Strings;
import smallsql.database.TableView;
import smallsql.database.Utils;

final class IndexDescription {
    static final int MAGIC_INDEX = 1397836873;
    static final int INDEX_VERSION = 1;
    private final String name;
    private final int constraintType;
    private final Strings columns;
    private int[] matrix;
    private final Expressions expressions;
    private Index index;
    private FileChannel raFile;

    IndexDescription(String string, String string2, int n, Expressions expressions, Strings strings) {
        this.constraintType = n;
        this.expressions = expressions;
        this.columns = strings;
        this.name = IndexDescription.createName(string, string2);
    }

    private static String createName(String string, String string2) {
        if (string == null) {
            string = string2 + "_" + Long.toHexString(System.currentTimeMillis()) + Integer.toHexString(new Object().hashCode());
        }
        return string;
    }

    final String getName() {
        return this.name;
    }

    final boolean isPrimary() {
        return this.constraintType == 251;
    }

    final boolean isUnique() {
        return this.constraintType == 251 || this.constraintType == 254;
    }

    final Strings getColumns() {
        return this.columns;
    }

    final int matchFactor(Strings strings) {
        if (strings.size() < this.columns.size()) {
            return Integer.MAX_VALUE;
        }
        block0: for (int i = 0; i < this.columns.size(); ++i) {
            String string = this.columns.get(i);
            for (int j = 0; j < strings.size(); ++j) {
                if (string.equalsIgnoreCase(strings.get(j))) continue block0;
            }
            return Integer.MAX_VALUE;
        }
        return strings.size() - this.columns.size();
    }

    final void init(Database database, TableView tableView) {
        int n;
        int n2 = tableView.columns.size();
        this.matrix = new int[n2];
        for (n = 0; n < this.matrix.length; ++n) {
            this.matrix[n] = -1;
        }
        for (n = 0; n < this.columns.size(); ++n) {
            this.matrix[tableView.findColumnIdx((String)this.columns.get((int)n))] = n;
        }
    }

    final void create(SSConnection sSConnection, Database database, TableView tableView) throws Exception {
        this.init(database, tableView);
        this.raFile = this.createFile(sSConnection, database);
    }

    static File getFile(Database database, String string) throws Exception {
        return new File(Utils.createIdxFileName(database, string));
    }

    private FileChannel createFile(SSConnection sSConnection, Database database) throws Exception {
        if (database.isReadOnly()) {
            throw SmallSQLException.create("SS-0034");
        }
        File file = IndexDescription.getFile(database, this.name);
        boolean bl = file.createNewFile();
        if (!bl) {
            throw SmallSQLException.create("SS-0460", this.name);
        }
        FileChannel fileChannel = Utils.openRaFile(file, database.isReadOnly());
        sSConnection.add(new CreateFile(file, fileChannel, sSConnection, database));
        this.writeMagic(fileChannel);
        return fileChannel;
    }

    private void load(Database database) throws SQLException {
        try {
            File file = IndexDescription.getFile(database, this.name);
            if (!file.exists()) {
                throw SmallSQLException.create("SS-0461", this.name);
            }
            this.raFile = Utils.openRaFile(file, database.isReadOnly());
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            this.raFile.read(byteBuffer);
            byteBuffer.position(0);
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            if (n != 1397836873) {
                throw SmallSQLException.create("SS-0462", file.getName());
            }
            if (n2 > 1) {
                Object[] objectArray = new Object[]{new Integer(n2), file.getName()};
                throw SmallSQLException.create("SS-0490", objectArray);
            }
        }
        catch (Throwable throwable) {
            if (this.raFile != null) {
                try {
                    this.raFile.close();
                }
                catch (Exception exception) {
                    DriverManager.println(exception.toString());
                }
            }
            throw SmallSQLException.createFromException(throwable);
        }
    }

    void drop(Database database) throws Exception {
        this.close();
        boolean bl = IndexDescription.getFile(database, this.name).delete();
        if (!bl) {
            throw SmallSQLException.create("SS-0191", this.name);
        }
    }

    void close() throws Exception {
        if (this.raFile != null) {
            this.raFile.close();
            this.raFile = null;
        }
    }

    private final void writeMagic(FileChannel fileChannel) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putInt(1397836873);
        byteBuffer.putInt(1);
        byteBuffer.position(0);
        fileChannel.write(byteBuffer);
    }

    final void writeExpression(int n, Expression expression) {
        int n2 = this.matrix[n];
        if (n2 >= 0) {
            this.expressions.set(n2, expression);
        }
    }

    final void writeFinish(SSConnection sSConnection) {
    }

    final void save(StoreImpl storeImpl) throws SQLException {
        storeImpl.writeInt(this.constraintType);
        storeImpl.writeInt(this.columns.size());
        for (int i = 0; i < this.columns.size(); ++i) {
            storeImpl.writeString(this.columns.get(i));
        }
        storeImpl.writeString(this.name);
    }

    static final IndexDescription load(Database database, TableView tableView, StoreImpl storeImpl) throws SQLException {
        int n = storeImpl.readInt();
        int n2 = storeImpl.readInt();
        Strings strings = new Strings();
        Expressions expressions = new Expressions();
        SQLParser sQLParser = new SQLParser();
        for (int i = 0; i < n2; ++i) {
            String string = storeImpl.readString();
            strings.add(string);
            expressions.add(sQLParser.parseExpression(string));
        }
        IndexDescription indexDescription = new IndexDescription(storeImpl.readString(), tableView.name, n, expressions, strings);
        indexDescription.init(database, tableView);
        indexDescription.load(database);
        return indexDescription;
    }
}

