/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.ExpressionArithmetic;
import smallsql.database.ExpressionFunctionReturnP1;
import smallsql.database.MutableNumeric;
import smallsql.database.Utils;

abstract class ExpressionFunctionReturnP1Number
extends ExpressionFunctionReturnP1 {
    ExpressionFunctionReturnP1Number() {
    }

    final boolean getBoolean() throws Exception {
        return this.getDouble() != 0.0;
    }

    final int getInt() throws Exception {
        return Utils.long2int(this.getLong());
    }

    final long getLong() throws Exception {
        return Utils.double2long(this.getDouble());
    }

    final float getFloat() throws Exception {
        return (float)this.getDouble();
    }

    MutableNumeric getNumeric() throws Exception {
        if (this.param1.isNull()) {
            return null;
        }
        switch (this.getDataType()) {
            case 323: {
                return new MutableNumeric(this.getInt());
            }
            case 325: {
                return new MutableNumeric(this.getLong());
            }
            case 331: {
                return new MutableNumeric(this.getMoney(), 4);
            }
            case 332: {
                MutableNumeric mutableNumeric = this.param1.getNumeric();
                mutableNumeric.floor();
                return mutableNumeric;
            }
            case 338: {
                return new MutableNumeric(this.getDouble());
            }
        }
        throw new Error();
    }

    long getMoney() throws Exception {
        return Utils.doubleToMoney(this.getDouble());
    }

    String getString() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return this.getObject().toString();
    }

    final int getDataType() {
        return ExpressionArithmetic.getBestNumberDataType(this.param1.getDataType());
    }
}

