/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.Expression;
import smallsql.database.ExpressionValue;
import smallsql.database.SQLTokenizer;
import smallsql.database.SmallSQLException;

abstract class ExpressionFunction
extends Expression {
    Expression param1;
    Expression param2;
    Expression param3;
    Expression param4;

    ExpressionFunction() {
        super(3);
    }

    abstract int getFunction();

    byte[] getBytes() throws Exception {
        return ExpressionValue.getBytes(this.getObject(), this.getDataType());
    }

    void setParams(Expression[] expressionArray) {
        super.setParams(expressionArray);
        if (expressionArray.length > 0) {
            this.param1 = expressionArray[0];
        }
        if (expressionArray.length > 1) {
            this.param2 = expressionArray[1];
        }
        if (expressionArray.length > 2) {
            this.param3 = expressionArray[2];
        }
        if (expressionArray.length > 3) {
            this.param4 = expressionArray[3];
        }
    }

    final void setParamAt(Expression expression, int n) {
        switch (n) {
            case 0: {
                this.param1 = expression;
                break;
            }
            case 1: {
                this.param2 = expression;
                break;
            }
            case 2: {
                this.param3 = expression;
                break;
            }
            case 3: {
                this.param4 = expression;
            }
        }
        super.setParamAt(expression, n);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof ExpressionFunction)) {
            return false;
        }
        return ((ExpressionFunction)object).getFunction() == this.getFunction();
    }

    SQLException createUnspportedDataType(int n) {
        Object[] objectArray = new Object[]{SQLTokenizer.getKeyWord(n), SQLTokenizer.getKeyWord(this.getFunction())};
        return SmallSQLException.create("SS-0282", objectArray);
    }

    SQLException createUnspportedConversion(int n) {
        Object[] objectArray = new Object[]{SQLTokenizer.getKeyWord(n), SQLTokenizer.getKeyWord(this.getFunction())};
        return SmallSQLException.create("SS-0283", objectArray);
    }
}

