/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Column;

final class Columns {
    private int size;
    private Column[] data = new Column[16];

    Columns() {
    }

    final int size() {
        return this.size;
    }

    final Column get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Column index: " + n + ", Size: " + this.size);
        }
        return this.data[n];
    }

    final Column get(String string) {
        for (int i = 0; i < this.size; ++i) {
            Column column = this.data[i];
            if (!string.equalsIgnoreCase(column.getName())) continue;
            return column;
        }
        return null;
    }

    final void add(Column column) {
        if (column == null) {
            throw new NullPointerException("Column is null.");
        }
        if (this.size >= this.data.length) {
            this.resize(this.size << 1);
        }
        this.data[this.size++] = column;
    }

    Columns copy() {
        Columns columns = new Columns();
        columns.data = (Column[])this.data.clone();
        Column[] columnArray = columns.data;
        for (int i = 0; i < this.size; ++i) {
            columnArray[i] = columnArray[i].copy();
        }
        columns.size = this.size;
        return columns;
    }

    private final void resize(int n) {
        Column[] columnArray = new Column[n];
        System.arraycopy(this.data, 0, columnArray, 0, this.size);
        this.data = columnArray;
    }
}

