/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Expressions;
import smallsql.database.Index;
import smallsql.database.IndexScrollStatus;
import smallsql.database.LongList;
import smallsql.database.RowSource;
import smallsql.database.SmallSQLException;

final class SortedResult
extends RowSource {
    private final Expressions orderBy;
    private final RowSource rowSource;
    private IndexScrollStatus scrollStatus;
    private int row;
    private final LongList insertedRows = new LongList();
    private boolean useSetRowPosition;
    private int sortedRowCount;
    private long lastRowOffset;

    SortedResult(RowSource rowSource, Expressions expressions) {
        this.rowSource = rowSource;
        this.orderBy = expressions;
    }

    final boolean isScrollable() {
        return true;
    }

    final void execute() throws Exception {
        this.rowSource.execute();
        Index index = new Index(false);
        this.lastRowOffset = -1L;
        while (this.rowSource.next()) {
            this.lastRowOffset = this.rowSource.getRowPosition();
            index.addValues(this.lastRowOffset, this.orderBy);
            ++this.sortedRowCount;
        }
        this.scrollStatus = index.createScrollStatus(this.orderBy);
        this.useSetRowPosition = false;
    }

    final boolean isBeforeFirst() {
        return this.row == 0;
    }

    final boolean isFirst() {
        return this.row == 1;
    }

    void beforeFirst() throws Exception {
        this.scrollStatus.reset();
        this.row = 0;
        this.useSetRowPosition = false;
    }

    boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    boolean previous() throws Exception {
        if (this.useSetRowPosition) {
            throw SmallSQLException.create("SS-0432");
        }
        if (this.currentInsertedRow() == 0) {
            this.scrollStatus.afterLast();
        }
        --this.row;
        if (this.currentInsertedRow() >= 0) {
            this.rowSource.setRowPosition(this.insertedRows.get(this.currentInsertedRow()));
            return true;
        }
        long l = this.scrollStatus.getRowOffset(false);
        if (l >= 0L) {
            this.rowSource.setRowPosition(l);
            return true;
        }
        this.rowSource.noRow();
        this.row = 0;
        return false;
    }

    boolean next() throws Exception {
        long l;
        if (this.useSetRowPosition) {
            throw SmallSQLException.create("SS-0432");
        }
        if (this.currentInsertedRow() < 0 && (l = this.scrollStatus.getRowOffset(true)) >= 0L) {
            ++this.row;
            this.rowSource.setRowPosition(l);
            return true;
        }
        if (this.currentInsertedRow() < this.insertedRows.size() - 1) {
            ++this.row;
            this.rowSource.setRowPosition(this.insertedRows.get(this.currentInsertedRow()));
            return true;
        }
        if (this.lastRowOffset >= 0L) {
            this.rowSource.setRowPosition(this.lastRowOffset);
        } else {
            this.rowSource.beforeFirst();
        }
        if (this.rowSource.next()) {
            ++this.row;
            this.lastRowOffset = this.rowSource.getRowPosition();
            this.insertedRows.add(this.lastRowOffset);
            return true;
        }
        this.rowSource.noRow();
        this.row = this.getRowCount() > 0 ? this.getRowCount() + 1 : 0;
        return false;
    }

    boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    final boolean isLast() throws Exception {
        if (this.row == 0) {
            return false;
        }
        if (this.row > this.getRowCount()) {
            return false;
        }
        boolean bl = this.next();
        this.previous();
        return !bl;
    }

    final boolean isAfterLast() {
        int n = this.getRowCount();
        return this.row > n || n == 0;
    }

    void afterLast() throws Exception {
        this.useSetRowPosition = false;
        if (this.sortedRowCount > 0) {
            this.scrollStatus.afterLast();
            this.scrollStatus.getRowOffset(false);
        } else {
            this.rowSource.beforeFirst();
        }
        this.row = this.sortedRowCount;
        while (this.next()) {
        }
    }

    boolean absolute(int n) throws Exception {
        if (n == 0) {
            throw SmallSQLException.create("SS-0520");
        }
        if (n > 0) {
            this.beforeFirst();
            while (n-- > 0) {
                if (this.next()) continue;
                return false;
            }
        } else {
            this.afterLast();
            while (n++ < 0) {
                if (this.previous()) continue;
                return false;
            }
        }
        return true;
    }

    boolean relative(int n) throws Exception {
        if (n == 0) {
            return this.row != 0;
        }
        if (n > 0) {
            while (n-- > 0) {
                if (this.next()) continue;
                return false;
            }
        } else {
            while (n++ < 0) {
                if (this.previous()) continue;
                return false;
            }
        }
        return true;
    }

    int getRow() {
        return this.row > this.getRowCount() ? 0 : this.row;
    }

    final long getRowPosition() {
        return this.rowSource.getRowPosition();
    }

    final void setRowPosition(long l) throws Exception {
        this.rowSource.setRowPosition(l);
        this.useSetRowPosition = true;
    }

    final boolean rowInserted() {
        return this.rowSource.rowInserted();
    }

    final boolean rowDeleted() {
        return this.rowSource.rowDeleted();
    }

    void nullRow() {
        this.rowSource.nullRow();
        this.row = 0;
    }

    void noRow() {
        this.rowSource.noRow();
        this.row = 0;
    }

    boolean isExpressionsFromThisRowSource(Expressions expressions) {
        return this.rowSource.isExpressionsFromThisRowSource(expressions);
    }

    private final int getRowCount() {
        return this.sortedRowCount + this.insertedRows.size();
    }

    private final int currentInsertedRow() {
        return this.row - this.sortedRowCount - 1;
    }
}

