/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.util.Stack;
import smallsql.database.Expressions;
import smallsql.database.IndexNode;
import smallsql.database.IndexNodeScrollStatus;
import smallsql.database.LongTreeList;
import smallsql.database.LongTreeListEnum;

class IndexScrollStatus {
    private final IndexNode rootPage;
    private final Expressions expressions;
    private final Stack nodeStack = new Stack();
    private LongTreeList longList;
    private LongTreeListEnum longListEnum = new LongTreeListEnum();

    IndexScrollStatus(IndexNode indexNode, Expressions expressions) {
        this.rootPage = indexNode;
        this.expressions = expressions;
        this.reset();
    }

    final void reset() {
        this.nodeStack.clear();
        boolean bl = this.expressions.get(0).getAlias() != "DESC";
        this.nodeStack.push(new IndexNodeScrollStatus(this.rootPage, bl, true, 0));
    }

    final long getRowOffset(boolean bl) {
        if (this.longList != null) {
            long l;
            long l2 = l = bl ? this.longList.getNext(this.longListEnum) : this.longList.getPrevious(this.longListEnum);
            if (l < 0L) {
                this.longList = null;
            } else {
                return l;
            }
        }
        while (true) {
            IndexNode indexNode;
            int n;
            IndexNodeScrollStatus indexNodeScrollStatus = (IndexNodeScrollStatus)this.nodeStack.peek();
            int n2 = indexNodeScrollStatus.level;
            if (!indexNodeScrollStatus.asc ^ bl) {
                if ((n = ++indexNodeScrollStatus.idx) == -1) {
                    if (indexNodeScrollStatus.nodeValue != null) {
                        if (indexNodeScrollStatus.nodeValue instanceof IndexNode) {
                            this.nodeStack.push(new IndexNodeScrollStatus((IndexNode)indexNodeScrollStatus.nodeValue, this.expressions.get(++n2).getAlias() != "DESC", bl, n2));
                            continue;
                        }
                        return this.getReturnValue(indexNodeScrollStatus.nodeValue);
                    }
                    n = ++indexNodeScrollStatus.idx;
                }
                if (n >= indexNodeScrollStatus.nodes.length) {
                    if (this.nodeStack.size() > 1) {
                        this.nodeStack.pop();
                        continue;
                    }
                    indexNodeScrollStatus.idx = indexNodeScrollStatus.nodes.length;
                    return -1L;
                }
                indexNode = indexNodeScrollStatus.nodes[n];
                this.nodeStack.push(new IndexNodeScrollStatus(indexNode, indexNodeScrollStatus.asc, bl, n2));
                continue;
            }
            if ((n = --indexNodeScrollStatus.idx) == -1 && indexNodeScrollStatus.nodeValue != null) {
                if (indexNodeScrollStatus.nodeValue instanceof IndexNode) {
                    this.nodeStack.push(new IndexNodeScrollStatus((IndexNode)indexNodeScrollStatus.nodeValue, this.expressions.get(++n2).getAlias() != "DESC", bl, n2));
                    continue;
                }
                return this.getReturnValue(indexNodeScrollStatus.nodeValue);
            }
            if (n < 0) {
                if (this.nodeStack.size() > 1) {
                    this.nodeStack.pop();
                    continue;
                }
                return -1L;
            }
            indexNode = indexNodeScrollStatus.nodes[n];
            this.nodeStack.push(new IndexNodeScrollStatus(indexNode, indexNodeScrollStatus.asc, bl, n2));
        }
    }

    final void afterLast() {
        this.longList = null;
        this.nodeStack.setSize(1);
        ((IndexNodeScrollStatus)this.nodeStack.peek()).afterLast();
    }

    private final long getReturnValue(Object object) {
        if (this.rootPage.getUnique()) {
            return (Long)object;
        }
        this.longList = (LongTreeList)object;
        this.longListEnum.reset();
        return this.longList.getNext(this.longListEnum);
    }
}

