/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Expression;
import smallsql.database.ExpressionArithmetic;
import smallsql.database.Expressions;
import smallsql.database.JoinScroll;
import smallsql.database.JoinScrollIndex;
import smallsql.database.LongLongList;
import smallsql.database.RowSource;
import smallsql.database.Utils;

final class Join
extends RowSource {
    Expression condition;
    private int type;
    RowSource left;
    RowSource right;
    private boolean isAfterLast;
    private LongLongList rowPositions;
    private int row;
    JoinScroll scroll;
    static final int CROSS_JOIN = 1;
    static final int INNER_JOIN = 2;
    static final int LEFT_JOIN = 3;
    static final int FULL_JOIN = 4;
    static final int RIGHT_JOIN = 5;

    Join(int n, RowSource rowSource, RowSource rowSource2, Expression expression) {
        this.type = n;
        this.condition = expression;
        this.left = rowSource;
        this.right = rowSource2;
    }

    final boolean isScrollable() {
        return false;
    }

    void beforeFirst() throws Exception {
        this.scroll.beforeFirst();
        this.isAfterLast = false;
        this.row = 0;
    }

    boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    boolean next() throws Exception {
        if (this.isAfterLast) {
            return false;
        }
        ++this.row;
        boolean bl = this.scroll.next();
        if (!bl) {
            this.noRow();
        }
        return bl;
    }

    void afterLast() {
        this.isAfterLast = true;
        this.noRow();
    }

    int getRow() {
        return this.row;
    }

    final long getRowPosition() {
        if (this.rowPositions == null) {
            this.rowPositions = new LongLongList();
        }
        this.rowPositions.add(this.left.getRowPosition(), this.right.getRowPosition());
        return this.rowPositions.size() - 1;
    }

    final void setRowPosition(long l) throws Exception {
        this.left.setRowPosition(this.rowPositions.get1((int)l));
        this.right.setRowPosition(this.rowPositions.get2((int)l));
    }

    final boolean rowInserted() {
        return this.left.rowInserted() || this.right.rowInserted();
    }

    final boolean rowDeleted() {
        return this.left.rowDeleted() || this.right.rowDeleted();
    }

    void nullRow() {
        this.left.nullRow();
        this.right.nullRow();
        this.row = 0;
    }

    void noRow() {
        this.isAfterLast = true;
        this.left.noRow();
        this.right.noRow();
        this.row = 0;
    }

    void execute() throws Exception {
        this.left.execute();
        this.right.execute();
        if (!this.createJoinScrollIndex()) {
            this.scroll = new JoinScroll(this.type, this.left, this.right, this.condition);
        }
    }

    boolean isExpressionsFromThisRowSource(Expressions expressions) {
        if (this.left.isExpressionsFromThisRowSource(expressions) || this.right.isExpressionsFromThisRowSource(expressions)) {
            return true;
        }
        if (expressions.size() == 1) {
            return false;
        }
        Expressions expressions2 = new Expressions();
        for (int i = 0; i < expressions.size(); ++i) {
            expressions2.clear();
            expressions2.add(expressions.get(i));
            if (this.left.isExpressionsFromThisRowSource(expressions) || this.right.isExpressionsFromThisRowSource(expressions)) continue;
            return false;
        }
        return true;
    }

    private boolean createJoinScrollIndex() throws Exception {
        Expressions expressions;
        Expressions expressions2;
        ExpressionArithmetic expressionArithmetic;
        int n;
        if (this.type == 1) {
            return false;
        }
        if (this.type != 2) {
            return false;
        }
        if (this.condition instanceof ExpressionArithmetic && (n = this.createJoinScrollIndex(expressionArithmetic = (ExpressionArithmetic)this.condition, expressions2 = new Expressions(), expressions = new Expressions(), 0)) != 0) {
            this.scroll = new JoinScrollIndex(this.type, this.left, this.right, expressions2, expressions, n);
            return true;
        }
        return false;
    }

    private int createJoinScrollIndex(ExpressionArithmetic expressionArithmetic, Expressions expressions, Expressions expressions2, int n) throws Exception {
        Expression[] expressionArray = expressionArithmetic.getParams();
        int n2 = expressionArithmetic.getOperation();
        if (n2 == 21) {
            Expression expression = expressionArray[0];
            Expression expression2 = expressionArray[1];
            if (expression instanceof ExpressionArithmetic && expression2 instanceof ExpressionArithmetic) {
                n2 = this.createJoinScrollIndex((ExpressionArithmetic)expression, expressions, expressions2, n);
                if (n2 == 0) {
                    return 0;
                }
                return this.createJoinScrollIndex((ExpressionArithmetic)expression2, expressions, expressions2, n);
            }
            return 0;
        }
        if (n == 0) {
            n = n2;
        }
        if (n != n2) {
            return 0;
        }
        if (n == 51) {
            Expression expression = expressionArray[0];
            Expression expression3 = expressionArray[1];
            Expressions expressions3 = Utils.getExpressionNameFromTree(expression);
            Expressions expressions4 = Utils.getExpressionNameFromTree(expression3);
            if (this.left.isExpressionsFromThisRowSource(expressions3) && this.right.isExpressionsFromThisRowSource(expressions4)) {
                expressions.add(expression);
                expressions2.add(expression3);
            } else if (this.left.isExpressionsFromThisRowSource(expressions4) && this.right.isExpressionsFromThisRowSource(expressions3)) {
                expressions.add(expression3);
                expressions2.add(expression);
            } else {
                return 0;
            }
            return n;
        }
        return 0;
    }
}

