/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import smallsql.database.Expression;
import smallsql.database.Mutable;
import smallsql.database.SSConnection;
import smallsql.database.StorePage;

public class Identity
extends Number
implements Mutable {
    private final long filePos;
    private final FileChannel raFile;
    private final byte[] page = new byte[8];
    private long value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity(FileChannel fileChannel, long l) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.page);
        FileChannel fileChannel2 = fileChannel;
        synchronized (fileChannel2) {
            fileChannel.position(l);
            fileChannel.read(byteBuffer);
        }
        this.value = (long)this.page[0] << 56 | (long)(this.page[1] & 0xFF) << 48 | (long)(this.page[2] & 0xFF) << 40 | (long)(this.page[3] & 0xFF) << 32 | (long)(this.page[4] & 0xFF) << 24 | (long)((this.page[5] & 0xFF) << 16) | (long)((this.page[6] & 0xFF) << 8) | (long)(this.page[7] & 0xFF);
        this.raFile = fileChannel;
        this.filePos = l;
    }

    private StorePage createStorePage() {
        this.page[0] = (byte)(this.value >> 56);
        this.page[1] = (byte)(this.value >> 48);
        this.page[2] = (byte)(this.value >> 40);
        this.page[3] = (byte)(this.value >> 32);
        this.page[4] = (byte)(this.value >> 24);
        this.page[5] = (byte)(this.value >> 16);
        this.page[6] = (byte)(this.value >> 8);
        this.page[7] = (byte)this.value;
        return new StorePage(this.page, 8, this.raFile, this.filePos);
    }

    void createNextValue(SSConnection sSConnection) throws SQLException {
        ++this.value;
        sSConnection.add(this.createStorePage());
    }

    void setNextValue(Expression expression) throws Exception {
        long l = expression.getLong();
        if (l > this.value) {
            this.value = l;
            this.createStorePage().commit();
        }
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public Object getImmutableObject() {
        return new Long(this.value);
    }
}

